//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "CCPDemo.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
	m_PccpHandle = 0;

	// PCAN Channel to use
	//
	m_Channel = PCAN_USBBUS1;
	m_Baudrate = PCAN_BAUD_500K;

	// ECU Data
	//
	m_SlaveData.EcuAddress = 0x10;
	m_SlaveData.IdCRO = 0x200;
	m_SlaveData.IdDTO = 0x100;
	m_SlaveData.IntelFormat = true;
}
//---------------------------------------------------------------------------
AnsiString TForm1::GetErrorText(TCCPResult errorCode)
{
	char textBuffer[256] = {0};

	if(CCP_GetErrorText(errorCode, textBuffer) ==  CCP_ERROR_ACKNOWLEDGE_OK)
		return (AnsiString)textBuffer;
	return "";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
	CCP_UninitializeChannel(m_Channel);	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
	TCCPResult ccpResult;

	ccpResult = CCP_InitializeChannel(m_Channel, m_Baudrate, 0,0,0);
	if (ccpResult != CCP_ERROR_ACKNOWLEDGE_OK)
	{
		ShowMessage("Error: " + GetErrorText(ccpResult));
		btnConnect->Enabled = false;
		btnTest->Enabled = false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnConnectClick(TObject *Sender)
{
	TCCPResult ccpResult;
	bool bConnected;

	ccpResult = CCP_Connect(m_Channel, &m_SlaveData, &m_PccpHandle, 0);
	bConnected = ccpResult == CCP_ERROR_ACKNOWLEDGE_OK;

	btnConnect->Enabled = !bConnected;
	btnDisconnect->Enabled = bConnected;
	btnGetVersion->Enabled = bConnected;
	btnExchange->Enabled = bConnected;
	btnGetId->Enabled = false;

	if (!bConnected)
		ShowMessage("Error: " + GetErrorText(ccpResult));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnDisconnectClick(TObject *Sender)
{
	TCCPResult ccpResult;

	ccpResult = CCP_Disconnect(m_PccpHandle,false, 0);
	m_PccpHandle = 0;

	btnConnect->Enabled = true;
	btnDisconnect->Enabled = false;
	btnGetVersion->Enabled = false;
	btnGetId->Enabled = false;
	btnExchange->Enabled = false;

	if (ccpResult != CCP_ERROR_ACKNOWLEDGE_OK)
		ShowMessage("Error: " + GetErrorText(ccpResult));

	laSlaveVersion->Caption = "0.0";
	laSlaveId->Caption = "_________";
	laSlaveInfo->Caption = "_________";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnTestClick(TObject *Sender)
{
	TCCPResult ccpResult;

	ccpResult = CCP_Test(m_Channel, &m_SlaveData, 0);
	if(ccpResult == CCP_ERROR_ACKNOWLEDGE_OK)
		ShowMessage("ECU is available for connect");
	else if(ccpResult == CCP_ERROR_INTERNAL_TIMEOUT)
		ShowMessage("ECU NOT available");
	else
		ShowMessage("Error: " + GetErrorText(ccpResult));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnGetVersionClick(TObject *Sender)
{
	TCCPResult ccpResult;
	BYTE mainByte, releaseByte;

	ccpResult = CCP_GetCcpVersion(m_PccpHandle, &mainByte, &releaseByte, 0);

	if (ccpResult != CCP_ERROR_ACKNOWLEDGE_OK)
		ShowMessage("Error: " + GetErrorText(ccpResult));
	else
		laSlaveVersion->Caption = Format("%d.%d",ARRAYOFCONST((mainByte,releaseByte)));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExchangeClick(TObject *Sender)
{
	TCCPResult ccpResult;
	BYTE MasterData[4];

	MasterData[0] = 0x78;
	MasterData[1] = 0x56;
	MasterData[2] = 0x34;
	MasterData[3] = 0x12;


	ccpResult = CCP_ExchangeId(m_PccpHandle, &m_ExchangeData, MasterData, 4, 0);

	if (ccpResult != CCP_ERROR_ACKNOWLEDGE_OK)
		ShowMessage("Error: " + GetErrorText(ccpResult));
	else
	{
		laSlaveInfo->Caption = Format("ID Length %d. Data Type %d. Res. Mask %d. Protec. Mask %d. ",
							ARRAYOFCONST((m_ExchangeData.IdLength,m_ExchangeData.DataType,m_ExchangeData.AvailabilityMask, m_ExchangeData.ProtectionMask)));
		btnGetId->Enabled = true;
	}

}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnGetIdClick(TObject *Sender)
{
	TCCPResult ccpResult;
	BYTE IdArray[8];

	ccpResult =  CCP_Upload(m_PccpHandle,m_ExchangeData.IdLength, IdArray, 0);

	if (ccpResult != CCP_ERROR_ACKNOWLEDGE_OK)
		ShowMessage("Error: " + GetErrorText(ccpResult));
	else
		switch(m_ExchangeData.IdLength)
		{
			case 1:
				laSlaveId->Caption = IntToHex(IdArray[0], 2);
				break;
			case 2:
				laSlaveId->Caption = IntToHex((int)*PWORD(IdArray), 4);
				break;
			case 4:
				laSlaveId->Caption = IntToHex((int)*LPDWORD(IdArray), 8);
				break;
			default:
				laSlaveId->Caption = "";
				for(int iCount = 0; iCount < m_ExchangeData.IdLength; iCount++)
					laSlaveId->Caption = IntToHex(IdArray[iCount],2) + laSlaveId->Caption;
		}
}
//---------------------------------------------------------------------------
