#pragma once

#include "PCCP_CLR.h"

namespace CCPDemo {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;

	using namespace Peak::Can::Basic;
	using namespace Peak::Can::Ccp;

	/// <summary>
	/// Summary for Form1
	///
	/// WARNING: If you change the name of this class, you will need to change the
	///          'Resource File Name' property for the managed resource compiler tool
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Form1(void)
		{
			InitializeComponent();

            m_PccpHandle = 0;

            // PCAN Hardware to use
            //
			m_Channel = PCANBasic::PCAN_USBBUS1;
			m_Baudrate = TPCANBaudrate::PCAN_BAUD_500K;

            // ECU Data
            //
            m_SlaveData.EcuAddress = 0x10;
            m_SlaveData.IdCRO = 0x200;
            m_SlaveData.IdDTO = 0x100;
            m_SlaveData.IntelFormat = true;
		}

	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::Windows::Forms::Label^  laSlaveId;
	protected: 
	private: System::Windows::Forms::Label^  laSlaveInfo;
	private: System::Windows::Forms::Label^  laVersion;
	private: System::Windows::Forms::Label^  label3;
	private: System::Windows::Forms::Label^  label2;
	private: System::Windows::Forms::Label^  label1;
	private: System::Windows::Forms::Button^  btnSlaveId;
	private: System::Windows::Forms::Button^  btnExchangeId;
	private: System::Windows::Forms::Button^  btnGetVersion;
	private: System::Windows::Forms::Button^  btnDisconnect;
	private: System::Windows::Forms::Button^  btnTest;
	private: System::Windows::Forms::Button^  btnConnect;


	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->laSlaveId = (gcnew System::Windows::Forms::Label());
			this->laSlaveInfo = (gcnew System::Windows::Forms::Label());
			this->laVersion = (gcnew System::Windows::Forms::Label());
			this->label3 = (gcnew System::Windows::Forms::Label());
			this->label2 = (gcnew System::Windows::Forms::Label());
			this->label1 = (gcnew System::Windows::Forms::Label());
			this->btnSlaveId = (gcnew System::Windows::Forms::Button());
			this->btnExchangeId = (gcnew System::Windows::Forms::Button());
			this->btnGetVersion = (gcnew System::Windows::Forms::Button());
			this->btnDisconnect = (gcnew System::Windows::Forms::Button());
			this->btnTest = (gcnew System::Windows::Forms::Button());
			this->btnConnect = (gcnew System::Windows::Forms::Button());
			this->SuspendLayout();
			// 
			// laSlaveId
			// 
			this->laSlaveId->AutoEllipsis = true;
			this->laSlaveId->Location = System::Drawing::Point(85, 157);
			this->laSlaveId->Name = L"laSlaveId";
			this->laSlaveId->Size = System::Drawing::Size(282, 13);
			this->laSlaveId->TabIndex = 23;
			this->laSlaveId->Text = L"_________";
			// 
			// laSlaveInfo
			// 
			this->laSlaveInfo->AutoEllipsis = true;
			this->laSlaveInfo->Location = System::Drawing::Point(85, 134);
			this->laSlaveInfo->Name = L"laSlaveInfo";
			this->laSlaveInfo->Size = System::Drawing::Size(282, 13);
			this->laSlaveInfo->TabIndex = 22;
			this->laSlaveInfo->Text = L"_________";
			// 
			// laVersion
			// 
			this->laVersion->AutoSize = true;
			this->laVersion->Location = System::Drawing::Point(85, 94);
			this->laVersion->Name = L"laVersion";
			this->laVersion->Size = System::Drawing::Size(22, 13);
			this->laVersion->TabIndex = 21;
			this->laVersion->Text = L"0.0";
			// 
			// label3
			// 
			this->label3->AutoSize = true;
			this->label3->Location = System::Drawing::Point(7, 157);
			this->label3->Name = L"label3";
			this->label3->Size = System::Drawing::Size(51, 13);
			this->label3->TabIndex = 20;
			this->label3->Text = L"Slave ID:";
			// 
			// label2
			// 
			this->label2->AutoSize = true;
			this->label2->Location = System::Drawing::Point(7, 134);
			this->label2->Name = L"label2";
			this->label2->Size = System::Drawing::Size(58, 13);
			this->label2->TabIndex = 19;
			this->label2->Text = L"Slave Info:";
			// 
			// label1
			// 
			this->label1->AutoSize = true;
			this->label1->Location = System::Drawing::Point(7, 94);
			this->label1->Name = L"label1";
			this->label1->Size = System::Drawing::Size(45, 13);
			this->label1->TabIndex = 18;
			this->label1->Text = L"Version:";
			// 
			// btnSlaveId
			// 
			this->btnSlaveId->Enabled = false;
			this->btnSlaveId->Location = System::Drawing::Point(272, 44);
			this->btnSlaveId->Name = L"btnSlaveId";
			this->btnSlaveId->Size = System::Drawing::Size(95, 23);
			this->btnSlaveId->TabIndex = 17;
			this->btnSlaveId->Text = L"Get slave Id";
			this->btnSlaveId->UseVisualStyleBackColor = true;
			this->btnSlaveId->Click += gcnew System::EventHandler(this, &Form1::btnSlaveId_Click);
			// 
			// btnExchangeId
			// 
			this->btnExchangeId->Enabled = false;
			this->btnExchangeId->Location = System::Drawing::Point(272, 15);
			this->btnExchangeId->Name = L"btnExchangeId";
			this->btnExchangeId->Size = System::Drawing::Size(95, 23);
			this->btnExchangeId->TabIndex = 16;
			this->btnExchangeId->Text = L"Exchange Ids";
			this->btnExchangeId->UseVisualStyleBackColor = true;
			this->btnExchangeId->Click += gcnew System::EventHandler(this, &Form1::btnExchangeId_Click);
			// 
			// btnGetVersion
			// 
			this->btnGetVersion->Enabled = false;
			this->btnGetVersion->Location = System::Drawing::Point(191, 15);
			this->btnGetVersion->Name = L"btnGetVersion";
			this->btnGetVersion->Size = System::Drawing::Size(75, 23);
			this->btnGetVersion->TabIndex = 15;
			this->btnGetVersion->Text = L"Get Version";
			this->btnGetVersion->UseVisualStyleBackColor = true;
			this->btnGetVersion->Click += gcnew System::EventHandler(this, &Form1::btnGetVersion_Click);
			// 
			// btnDisconnect
			// 
			this->btnDisconnect->Enabled = false;
			this->btnDisconnect->Location = System::Drawing::Point(88, 15);
			this->btnDisconnect->Name = L"btnDisconnect";
			this->btnDisconnect->Size = System::Drawing::Size(75, 23);
			this->btnDisconnect->TabIndex = 14;
			this->btnDisconnect->Text = L"Disconnect";
			this->btnDisconnect->UseVisualStyleBackColor = true;
			this->btnDisconnect->Click += gcnew System::EventHandler(this, &Form1::btnDisconnect_Click);
			// 
			// btnTest
			// 
			this->btnTest->Location = System::Drawing::Point(7, 44);
			this->btnTest->Name = L"btnTest";
			this->btnTest->Size = System::Drawing::Size(75, 23);
			this->btnTest->TabIndex = 13;
			this->btnTest->Text = L"Test";
			this->btnTest->UseVisualStyleBackColor = true;
			this->btnTest->Click += gcnew System::EventHandler(this, &Form1::btnTest_Click);
			// 
			// btnConnect
			// 
			this->btnConnect->Location = System::Drawing::Point(7, 15);
			this->btnConnect->Name = L"btnConnect";
			this->btnConnect->Size = System::Drawing::Size(75, 23);
			this->btnConnect->TabIndex = 12;
			this->btnConnect->Text = L"Connect";
			this->btnConnect->UseVisualStyleBackColor = true;
			this->btnConnect->Click += gcnew System::EventHandler(this, &Form1::btnConnect_Click);
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(374, 184);
			this->Controls->Add(this->laSlaveId);
			this->Controls->Add(this->laSlaveInfo);
			this->Controls->Add(this->laVersion);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->label1);
			this->Controls->Add(this->btnSlaveId);
			this->Controls->Add(this->btnExchangeId);
			this->Controls->Add(this->btnGetVersion);
			this->Controls->Add(this->btnDisconnect);
			this->Controls->Add(this->btnTest);
			this->Controls->Add(this->btnConnect);
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::FixedDialog;
			this->MaximizeBox = false;
			this->MinimizeBox = false;
			this->Name = L"Form1";
			this->StartPosition = System::Windows::Forms::FormStartPosition::CenterScreen;
			this->Text = L"Form1";
			this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
			this->FormClosing += gcnew System::Windows::Forms::FormClosingEventHandler(this, &Form1::Form1_FormClosing);
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion
		private:
			TCCPHandle m_PccpHandle;
			TPCANHandle m_Channel;
			TPCANBaudrate m_Baudrate;
			TCCPSlaveData m_SlaveData;
			TCCPExchangeData m_ExchangeData;

	private: System::String^ GetErrorText(TCCPResult errorCode)
			 {
				 StringBuilder^ strText = gcnew StringBuilder(256);

				 if(CCPApi::GetErrorText(errorCode, strText) == TCCPResult::CCP_ERROR_ACKNOWLEDGE_OK)
					 return strText->ToString();
				 return String::Empty;
			 }

	private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e) 
			{
				TCCPResult result;

				result = CCPApi::InitializeChannel(m_Channel, m_Baudrate);
				if (result != TCCPResult::CCP_ERROR_ACKNOWLEDGE_OK)
				{
					MessageBox::Show(String::Format("Error: {0}", GetErrorText(result)), "Error");
					btnConnect->Enabled = false;
					btnTest->Enabled = false;
				}
			}

	private: System::Void Form1_FormClosing(System::Object^  sender, System::Windows::Forms::FormClosingEventArgs^  e) 
			{
				CCPApi::UninitializeChannel(m_Channel);
			}

	private: System::Void btnConnect_Click(System::Object^  sender, System::EventArgs^  e) 
			{
				TCCPResult result;
				bool bConnected;

				result = CCPApi::Connect(m_Channel, m_SlaveData, m_PccpHandle, 0);
				bConnected = (result == TCCPResult::CCP_ERROR_ACKNOWLEDGE_OK);

				btnConnect->Enabled = !bConnected;
				btnDisconnect->Enabled = bConnected;
				btnGetVersion->Enabled = bConnected;
				btnExchangeId->Enabled = bConnected;
				btnSlaveId->Enabled = false;

				if (!bConnected)
					MessageBox::Show(String::Format("Error: {0}", GetErrorText(result)), "Error");
			}

	private: System::Void btnDisconnect_Click(System::Object^  sender, System::EventArgs^  e) 
			{
				TCCPResult result;

				result = CCPApi::Disconnect(m_PccpHandle, false, 0);
				m_PccpHandle = 0;

				btnConnect->Enabled = true;
				btnDisconnect->Enabled = false;
				btnGetVersion->Enabled = false;
				btnExchangeId->Enabled = false;
				btnSlaveId->Enabled = false;

				if (result != TCCPResult::CCP_ERROR_ACKNOWLEDGE_OK)
					MessageBox::Show(String::Format("Error: {0}", GetErrorText(result)), "Error");

				laVersion->Text = "0.0";
				laSlaveId->Text = "_________";
				laSlaveInfo->Text = "_________";
			}

	private: System::Void btnTest_Click(System::Object^  sender, System::EventArgs^  e) 
		   {
				TCCPResult result;

				result = CCPApi::Test(m_Channel, m_SlaveData, 0);

				if(result == TCCPResult::CCP_ERROR_ACKNOWLEDGE_OK)
					MessageBox::Show("ECU is available for connect");
				else if(result == TCCPResult::CCP_ERROR_INTERNAL_TIMEOUT)
					MessageBox::Show("ECU NOT available");
				else
					MessageBox::Show(String::Format("Error: {0}",GetErrorText(result)),"Error");
		   }

	private: System::Void btnGetVersion_Click(System::Object^  sender, System::EventArgs^  e)
		   {
				TCCPResult result;
				Byte main, release;

				main = release = 0;
				result = CCPApi::GetCcpVersion(m_PccpHandle, main, release, 0);

				if (result != TCCPResult::CCP_ERROR_ACKNOWLEDGE_OK)
					MessageBox::Show(String::Format("Error: {0}", GetErrorText(result)), "Error");
				else
					laVersion->Text = String::Format("{0}.{1}", main, release);
		   }

	private: System::Void btnExchangeId_Click(System::Object^  sender, System::EventArgs^  e) 
		   {
				TCCPResult result;
				array<Byte>^ masterData;

				masterData = gcnew array<Byte> { 0x78, 0x56, 0x34, 0x12 };
				result = CCPApi::ExchangeId(m_PccpHandle, m_ExchangeData, masterData, masterData->Length, 0);

				if (result != TCCPResult::CCP_ERROR_ACKNOWLEDGE_OK)
					MessageBox::Show(String::Format("Error: {0}", GetErrorText(result)), "Error");
				else
				{
					laSlaveInfo->Text = String::Format("ID Length {0}. Data Type {1}. Res. Mask {2}. Protec. Mask {3}.", gcnew array<Object^> { m_ExchangeData.IdLength, m_ExchangeData.DataType, m_ExchangeData.AvailabilityMask, m_ExchangeData.ProtectionMask });
					btnSlaveId->Enabled = true;
				}
		   }

	private: System::Void btnSlaveId_Click(System::Object^  sender, System::EventArgs^  e) 
		  {
				TCCPResult result;
				array<Byte>^ IdArray;

				IdArray = gcnew array<Byte>(m_ExchangeData.IdLength);
				result = CCPApi::Upload(m_PccpHandle, m_ExchangeData.IdLength, IdArray, 0);

				if (result != TCCPResult::CCP_ERROR_ACKNOWLEDGE_OK)
					MessageBox::Show(String::Format("Error: {0}", GetErrorText(result)), "Error");
				else
					switch (m_ExchangeData.IdLength)
					{
						case 1:
							laSlaveId->Text = IdArray[0].ToString("X2");
							break;
						case 2:
							laSlaveId->Text = BitConverter::ToUInt16(IdArray, 0).ToString("X4");
							break;
						case 4:
							laSlaveId->Text = BitConverter::ToUInt32(IdArray, 0).ToString("X8");
							break;
						default:
							laSlaveId->Text = "";
							for (int i = 0; i < m_ExchangeData.IdLength; i++)
								laSlaveId->Text = IdArray[i].ToString("X2") + laSlaveId->Text;
							break;                        
					}
		  }
};
}

