unit CCPDemo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, PCANBasic, PCCP;

type
  TForm1 = class(TForm)
    btnConnect: TButton;
    btnTest: TButton;
    btnDisconnect: TButton;
    btnGetVersion: TButton;
    btnGetId: TButton;
    Label1: TLabel;
    laSlaveVersion: TLabel;
    Label2: TLabel;
    laSlaveId: TLabel;
    btnExchange: TButton;
    Label3: TLabel;
    laSlaveInfo: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnConnectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnDisconnectClick(Sender: TObject);
    procedure btnTestClick(Sender: TObject);
    procedure btnGetVersionClick(Sender: TObject);
    procedure btnGetIdClick(Sender: TObject);
    procedure btnExchangeClick(Sender: TObject);

  private
      m_PccpHandle : TCCPHandle;
      m_Channel : TPCANHandle;
      m_Baudrate : TPCANBaudrate;
      m_SlaveData : TCCPSlaveData;
      m_ExchangeData : TCCPExchangeData;

      function GetErrorText(errorCode: TCCPResult) : AnsiString;

  public
    { Public declarations }
  end;

var
  Form1: TForm1;


implementation

{$R *.dfm}


procedure TForm1.FormCreate(Sender: TObject);
begin
    m_PccpHandle := 0;

    // PCAN Channel to use
    //
    m_Channel := TPCANBasic.PCAN_USBBUS1;
    m_Baudrate := PCAN_BAUD_500K;

    // ECU Data
    //
    m_SlaveData.EcuAddress := $10;
    m_SlaveData.IdCRO := $200;
    m_SlaveData.IdDTO := $100;
    m_SlaveData.IntelFormat := True;

end;

function TForm1.GetErrorText(errorCode: TCCPResult) : AnsiString;
var
    textBuffer : array[0..255] of Ansichar;
begin
    if CCP_GetErrorText(errorCode, textBuffer) = CCP_ERROR_ACKNOWLEDGE_OK then
        result := textBuffer
    else
        result := '';    
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    CCP_UninitializeChannel(m_Channel);
end;

procedure TForm1.FormShow(Sender: TObject);
var
    ccpResult : TCCPResult;
begin
    ccpResult := CCP_InitializeChannel(m_Channel, m_Baudrate,TPCANType(0),0,0);
    if ccpResult <> CCP_ERROR_ACKNOWLEDGE_OK then
    begin
        ShowMessage('Error: ' + GetErrorText(ccpResult));
        btnConnect.Enabled := false;
        btnTest.Enabled := false;
    end;
end;

procedure TForm1.btnConnectClick(Sender: TObject);
var
    ccpResult : TCCPResult;
    bConnected : boolean;
begin
    ccpResult := CCP_Connect(m_Channel, m_SlaveData, m_PccpHandle, 0);
    bConnected := ccpResult = CCP_ERROR_ACKNOWLEDGE_OK;

    btnConnect.Enabled := Not bConnected;
    btnDisconnect.Enabled := bConnected;
    btnGetVersion.Enabled := bConnected;
    btnExchange.Enabled := bConnected;
    btnGetId.Enabled := false;

    if Not bConnected then
        ShowMessage('Error: ' + GetErrorText(ccpResult));
end;

procedure TForm1.btnDisconnectClick(Sender: TObject);
var
    ccpResult : TCCPResult;
begin
    ccpResult := CCP_Disconnect(m_PccpHandle,false, 0);
    m_PccpHandle := 0;

    btnConnect.Enabled := true;
    btnDisconnect.Enabled := false;
    btnGetVersion.Enabled := false;
    btnGetId.Enabled := false;
    btnExchange.Enabled := false;

    if ccpResult <> CCP_ERROR_ACKNOWLEDGE_OK then
        ShowMessage('Error: ' + GetErrorText(ccpResult));

    laSlaveVersion.Caption := '0.0';
    laSlaveId.Caption := '_________';
    laSlaveInfo.Caption := '_________';
end;

procedure TForm1.btnTestClick(Sender: TObject);
var
    ccpResult : TCCPResult;
begin
    ccpResult := CCP_Test(m_Channel, m_SlaveData, 0);
    if ccpResult = CCP_ERROR_ACKNOWLEDGE_OK then
        ShowMessage('ECU is available for connect')
    else if ccpResult = CCP_ERROR_INTERNAL_TIMEOUT then
        ShowMessage('ECU NOT available')
    else
        ShowMessage('CCP Error: ' + GetErrorText(ccpResult));
end;

procedure TForm1.btnGetVersionClick(Sender: TObject);
var
    ccpResult : TCCPResult;
    main, release : Byte;
begin
    ccpResult := CCP_GetCcpVersion(m_PccpHandle, main, release, 0);

    if ccpResult <> CCP_ERROR_ACKNOWLEDGE_OK then
        ShowMessage('Error: ' + GetErrorText(ccpResult))
    else
        laSlaveVersion.Caption := Format('%d.%d',[main,release]);
end;

procedure TForm1.btnExchangeClick(Sender: TObject);
var
    ccpResult : TCCPResult;
    MasterData : Array [0..3] of Byte;
begin
    MasterData[0] := $78;
    MasterData[1] := $56;
    MasterData[2] := $34;
    MasterData[3] := $12;


    ccpResult := CCP_ExchangeId(m_PccpHandle, m_ExchangeData, @MasterData, 4, 0);

    if ccpResult <> CCP_ERROR_ACKNOWLEDGE_OK then
        ShowMessage('Error: ' + GetErrorText(ccpResult))
    else
    begin
        laSlaveInfo.Caption := Format('ID Length %d. Data Type %d. Res. Mask %d. Protec. Mask %d. ',
                            [m_ExchangeData.IdLength,m_ExchangeData.DataType,m_ExchangeData.AvailabilityMask, m_ExchangeData.ProtectionMask]);
        btnGetId.Enabled := true;
    end;
end;

procedure TForm1.btnGetIdClick(Sender: TObject);
var
    ccpResult : TCCPResult;
    IdArray : Array [0..7]of Byte;
    iCount: Longword;
begin
    ccpResult :=  CCP_Upload(m_PccpHandle,m_ExchangeData.IdLength, @IdArray, 0);

    if ccpResult <> CCP_ERROR_ACKNOWLEDGE_OK then
        ShowMessage('Error: ' + GetErrorText(ccpResult))
    else
        case m_ExchangeData.IdLength of
            1: laSlaveId.Caption := IntToHex(IdArray[0], 2);
            2: laSlaveId.Caption := IntToHex(PWORD(@IdArray)^, 4);
            4: laSlaveId.Caption := IntToHex(LPDWORD(@IdArray)^, 8);
            else
            begin
                laSlaveId.Caption := '';
                for iCount := 0 to m_ExchangeData.IdLength - 1 do
                begin
                    laSlaveId.Caption := IntToHex(IdArray[iCount],2) + laSlaveId.Caption;
                end;
            end;
        end;

end;

end.
