﻿Imports Peak.Can.Ccp
Imports Peak.Can.Basic
Imports System.Text

Imports TCCPHandle = System.UInt32
Imports TPCANHandle = System.UInt16


Public Class Form1
    Private m_PccpHandle As TCCPHandle
    Private m_Channel As TPCANHandle
    Private m_Baudrate As TPCANBaudrate
    Private m_SlaveData As TCCPSlaveData
    Private m_ExchangeData As TCCPExchangeData

    Public Sub New()

        InitializeComponent()

        m_PccpHandle = 0

        ' PCAN Hardware to use
        '
        m_Channel = PCANBasic.PCAN_USBBUS1
        m_Baudrate = TPCANBaudrate.PCAN_BAUD_500K

        ' ECU Data
        '
        m_SlaveData = New TCCPSlaveData()
        m_SlaveData.EcuAddress = &H10
        m_SlaveData.IdCRO = &H200
        m_SlaveData.IdDTO = &H100
        m_SlaveData.IntelFormat = True
    End Sub

    Private Function GetErrorText(ByVal errCode As TCCPResult)
        Dim strText As StringBuilder = New StringBuilder(256)

        If CCPApi.GetErrorText(errCode, strText) = TCCPResult.CCP_ERROR_ACKNOWLEDGE_OK Then
            Return strText.ToString()
        End If
        Return String.Empty
    End Function


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim result As TCCPResult

        result = CCPApi.InitializeChannel(m_Channel, m_Baudrate)
        If result <> TCCPResult.CCP_ERROR_ACKNOWLEDGE_OK Then
            MessageBox.Show(String.Format("Error: {0}", GetErrorText(result)), "Error")
            btnConnect.Enabled = False
            btnTest.Enabled = False
        End If
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        CCPApi.UninitializeChannel(m_Channel)
    End Sub

    Private Sub btnConnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnConnect.Click
        Dim result As TCCPResult
        Dim bConnected As Boolean

        result = CCPApi.Connect(m_Channel, m_SlaveData, m_PccpHandle, 0)
        bConnected = (result = TCCPResult.CCP_ERROR_ACKNOWLEDGE_OK)

        btnConnect.Enabled = Not bConnected
        btnDisconnect.Enabled = bConnected
        btnGetVersion.Enabled = bConnected
        btnExchangeId.Enabled = bConnected
        btnSlaveId.Enabled = False

        If Not bConnected Then
            MessageBox.Show(String.Format("Error: {0}", GetErrorText(result)), "Error")
        End If
    End Sub

    Private Sub btnDisconnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDisconnect.Click
        Dim result As TCCPResult

        result = CCPApi.Disconnect(m_PccpHandle, False, 0)
        m_PccpHandle = 0

        btnConnect.Enabled = True
        btnDisconnect.Enabled = False
        btnGetVersion.Enabled = False
        btnExchangeId.Enabled = False
        btnSlaveId.Enabled = False

        If result <> TCCPResult.CCP_ERROR_ACKNOWLEDGE_OK Then
            MessageBox.Show(String.Format("Error: {0}", GetErrorText(result)), "Error")
        End If

        laVersion.Text = "0.0"
        laSlaveId.Text = "_________"
        laSlaveInfo.Text = "_________"
    End Sub

    Private Sub btnTest_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTest.Click
        Dim result As TCCPResult

        result = CCPApi.Test(m_Channel, m_SlaveData, 0)

        If result = TCCPResult.CCP_ERROR_ACKNOWLEDGE_OK Then
            MessageBox.Show("ECU is available for connect")
        Else
            If result = TCCPResult.CCP_ERROR_INTERNAL_TIMEOUT Then
                MessageBox.Show("ECU NOT available")
            Else
                MessageBox.Show(String.Format("Error: {0}", GetErrorText(result)), "Error")
            End If
        End If
    End Sub

    Private Sub btnGetVersion_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetVersion.Click
        Dim result As TCCPResult
        Dim main, release As Byte

        main = release = 0
        result = CCPApi.GetCcpVersion(m_PccpHandle, main, release, 0)

        If result <> TCCPResult.CCP_ERROR_ACKNOWLEDGE_OK Then
            MessageBox.Show(String.Format("Error: {0}", GetErrorText(result)), "Error")
        Else
            laVersion.Text = String.Format("{0}.{1}", main, release)
        End If
    End Sub

    Private Sub btnExchangeId_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExchangeId.Click
        Dim result As TCCPResult
        Dim masterData As Byte()

        masterData = New Byte() {&H78, &H56, &H34, &H12}
        result = CCPApi.ExchangeId(m_PccpHandle, m_ExchangeData, masterData, masterData.Length, 0)

        If result <> TCCPResult.CCP_ERROR_ACKNOWLEDGE_OK Then
            MessageBox.Show(String.Format("PCAN Error: {0}", GetErrorText(result)), "Error")
        Else
            laSlaveInfo.Text = String.Format("ID Length {0}. Data Type {1}. Res. Mask {2}. Protec. Mask {3}.", New Object() {m_ExchangeData.IdLength, m_ExchangeData.DataType, m_ExchangeData.AvailabilityMask, m_ExchangeData.ProtectionMask})
            btnSlaveId.Enabled = True
        End If

    End Sub

    Private Sub btnSlaveId_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSlaveId.Click
        Dim result As TCCPResult
        Dim IdArray As Byte()

        IdArray = New Byte(m_ExchangeData.IdLength - 1) {}
        result = CCPApi.Upload(m_PccpHandle, m_ExchangeData.IdLength, IdArray, 0)


        If result <> TCCPResult.CCP_ERROR_ACKNOWLEDGE_OK Then
            MessageBox.Show(String.Format("CCP Error: {0}", GetErrorText(result)), "Error")
        Else
            Select Case m_ExchangeData.IdLength
                Case 1
                    laSlaveId.Text = IdArray(0).ToString("X2")
                    Exit Select
                Case 2
                    laSlaveId.Text = BitConverter.ToUInt16(IdArray, 0).ToString("X4")
                    Exit Select
                Case 4
                    laSlaveId.Text = BitConverter.ToUInt32(IdArray, 0).ToString("X8")
                    Exit Select
                Case Else
                    laSlaveId.Text = ""
                    For I As Integer = 0 To m_ExchangeData.IdLength - 1
                        laSlaveId.Text = IdArray(I).ToString("X2") + laSlaveId.Text
                    Next
                    Exit Select
            End Select
        End If
    End Sub
End Class
