// client_ISO15765-2_normal_addressing.cpp: Defines the entry point for the console application.
//

#include "stdafx.h"

#include "PCAN-ISO-TP_2016.h"

#define STMIN_600US 0xF6
#define OK_KO(test) (test)?"OK":"KO"
#define STATUS_OK_KO(test) OK_KO(CANTP_StatusIsOk_2016(test, PCANTP_STATUS_OK, false))

#define DATA_UNSEGMENTED	"PEAK"
#define DATA_SEGMENTED		"PEAK-System - PCAN-ISO-TP Sample"
// Change MSG definition to perform UNSEGMENTED or SEGMENTED ISO-TP message
#define MSG DATA_SEGMENTED
#define MSG_SIZE sizeof(MSG)

/// <summary>Entry point of the program, start a small CAN ISO TP read/write example</summary>
/// <returns>By convention, return success.</returns>
int main()
{
	// Local variables
	cantp_status res;
	char buffer[500];
	uint32_t STmin;
	cantp_msg tx_msg, rx_msg;
	cantp_mapping mapping;
	cantp_handle client_handle;

	// Initialize structs 
	client_handle = PCANTP_HANDLE_USBBUS1; // TODO: modify the value according to your available PCAN devices.
	memset(&tx_msg, 0, sizeof(cantp_msg));
	memset(&mapping, 0, sizeof(cantp_mapping));

	// Print version informations
	CANTP_GetValue_2016(PCANTP_HANDLE_NONEBUS, PCANTP_PARAMETER_API_VERSION, buffer, 500);
	printf("PCAN-ISO-TP API Version: %s\n", buffer);

	// Initialize channels: CAN2.0 - 500Kbit/s
	res = CANTP_Initialize_2016(client_handle, PCANTP_BAUDRATE_500K, (cantp_hwtype)0, 0, 0);
	printf("Initialize: %s\n", STATUS_OK_KO(res));

	// Change STmin value to 600us
	STmin = STMIN_600US;
	res = CANTP_SetValue_2016(client_handle, PCANTP_PARAMETER_SEPARATION_TIME, &STmin, sizeof(STmin));
	printf("Set STMIN = 600us: %s\n", STATUS_OK_KO(res));

	// Allocate tx message
	res = CANTP_MsgDataAlloc_2016(&tx_msg, PCANTP_MSGTYPE_ISOTP);
	printf("Allocate tx message: %s\n", STATUS_OK_KO(res));

	// Create a simple physical mapping: 
	//    - Source 0xF1 (client), target 0x01 (server), CAN id 0xA1, CAN ID flow control 0xA2
	//    - Diagnostic message in a classic format
	mapping.can_id = 0xA1;
	mapping.can_id_flow_ctrl = 0xA2;
	mapping.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD;
	mapping.netaddrinfo.extension_addr = 0x00;
	mapping.netaddrinfo.format = PCANTP_ISOTP_FORMAT_NORMAL;
	mapping.netaddrinfo.msgtype = PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC;
	mapping.netaddrinfo.source_addr = 0xF1;
	mapping.netaddrinfo.target_addr = 0x01;
	mapping.netaddrinfo.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL;

	// Add mapping on channels
	res = CANTP_AddMapping_2016(client_handle, &mapping);
	printf("Add a simple mapping: %s\n", STATUS_OK_KO(res));

	if (MSG_SIZE > 7) {
		cantp_mapping mappingSegmented;
		// data is too big to fit in an ISO-TP "Single Frame",
		//	Communication will be segmented a mapping to receive communications from the receiver: 
		//    - Source 0x01 (server), target 0xF1 (client), CAN id 0xA2, CAN ID flow control 0xA1
		//    - Diagnostic message in a classic format
		memset(&mappingSegmented, 0, sizeof(mappingSegmented));
		mappingSegmented.can_id = 0xA2;
		mappingSegmented.can_id_flow_ctrl = 0xA1;
		mappingSegmented.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD;
		mappingSegmented.netaddrinfo.extension_addr = 0x00;
		mappingSegmented.netaddrinfo.format = PCANTP_ISOTP_FORMAT_NORMAL;
		mappingSegmented.netaddrinfo.msgtype = PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC;
		mappingSegmented.netaddrinfo.source_addr = 0x01;
		mappingSegmented.netaddrinfo.target_addr = 0xF1;
		mappingSegmented.netaddrinfo.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL;

		// Add mapping on channels
		res = CANTP_AddMapping_2016(client_handle, &mappingSegmented);
		printf("Add a simple mapping: %s\n", STATUS_OK_KO(res));
	}

	// Initialize Tx message
	res = CANTP_MsgDataInit_2016(&tx_msg, PCANTP_CAN_ID_DEFINED_BY_NAI, mapping.can_msgtype, MSG_SIZE, MSG, &mapping.netaddrinfo);
	printf("Initialize tx message: %s\n", STATUS_OK_KO(res));

	// Write message
	res = CANTP_Write_2016(client_handle, &tx_msg);
	printf("Write \"%s\" message: %s\n", MSG, STATUS_OK_KO(PCANTP_STATUS_OK));

	// Sleep to let the transmission runs
	Sleep(100);

	if (MSG_SIZE > 7) {
		// Initialize Rx message
		res = CANTP_MsgDataAlloc_2016(&rx_msg, PCANTP_MSGTYPE_NONE);
		printf("Initialize rx message: %s\n", STATUS_OK_KO(res));
		// Read loopback indication ISO-TP message
		res = CANTP_Read_2016(client_handle, &rx_msg, NULL, PCANTP_MSGTYPE_NONE);
		printf("CANTP_Read_2016 (indication): %s, netstatus=%02x\n", STATUS_OK_KO(res), rx_msg.msgdata.any->netstatus);
		// Free message space
		res = CANTP_MsgDataFree_2016(&rx_msg);
		printf("Free rx message: %s\n", STATUS_OK_KO(res));
		// Sleep to let the transmission complete
		Sleep(1000);
	}

	// Initialize Rx message
	res = CANTP_MsgDataAlloc_2016(&rx_msg, PCANTP_MSGTYPE_NONE);
	printf("Initialize rx message: %s\n", STATUS_OK_KO(res));
	// Read loopback indication ISO-TP message
	res = CANTP_Read_2016(client_handle, &rx_msg, NULL, PCANTP_MSGTYPE_NONE);
	printf("CANTP_Read_2016 (complete): %s, netstatus=%02x\n", STATUS_OK_KO(res), rx_msg.msgdata.any->netstatus);
	// Free message space
	res = CANTP_MsgDataFree_2016(&rx_msg);
	printf("Free rx message: %s\n", STATUS_OK_KO(res));

	// Free message space
	res = CANTP_MsgDataFree_2016(&tx_msg);
	printf("Free tx message: %s\n", STATUS_OK_KO(res));

	// Uninitialize
	res = CANTP_Uninitialize_2016(client_handle);
	printf("Uninitialize: %s\n", STATUS_OK_KO(res));

	// Exit
	system("PAUSE");
	return EXIT_SUCCESS;
}

