// classic_can_read_write.cpp: Defines the entry point for the console application.
//

#include "stdafx.h"


#include "PCAN-ISO-TP_2016.h"

#define OK_KO(test) (test)?"OK":"KO"
#define STATUS_OK_KO(test) OK_KO(CANTP_StatusIsOk_2016(test, PCANTP_STATUS_OK, false))

/// <summary>Entry point of the program, start a small ISO TP classic CAN read/write example</summary>
/// <returns>By convention, return success.</returns>
int main()
{
	// Local variables
	cantp_status res;
	char buffer[500];
	cantp_msg tx_msg;
	cantp_msg rx_msg;
	int can_id;
	HANDLE receive_event;
	int wait_result;
	BOOL res_b;
	uint64_t null_handle = 0;
	cantp_handle transmitter_handle;
	cantp_handle receiver_handle;

	// Initialize structs 
	transmitter_handle = PCANTP_HANDLE_USBBUS1; // TODO: modify the value according to your available PCAN devices.
	receiver_handle = PCANTP_HANDLE_USBBUS2; // TODO: modify the value according to your available PCAN devices.
	memset(&rx_msg, 0, sizeof(cantp_msg));
	memset(&tx_msg, 0, sizeof(cantp_msg));

	// Print version informations
	CANTP_GetValue_2016(PCANTP_HANDLE_NONEBUS, PCANTP_PARAMETER_API_VERSION, buffer, 500);
	printf("PCAN-ISO-TP API Version: %s\n", buffer);

	// Initialize channels: CAN2.0 - 500Kbit/s
	res = CANTP_Initialize_2016(transmitter_handle, PCANTP_BAUDRATE_500K, (cantp_hwtype)0, 0, 0);
	printf("Initialize transmitter: %s\n", STATUS_OK_KO(res));
	res = CANTP_Initialize_2016(receiver_handle, PCANTP_BAUDRATE_500K, (cantp_hwtype)0, 0, 0);
	printf("Initialize receiver: %s\n", STATUS_OK_KO(res));

	// Create a receive event on receiver:
	receive_event = CreateEvent(NULL, FALSE, FALSE, NULL);
	res = CANTP_SetValue_2016(receiver_handle, PCANTP_PARAMETER_RECEIVE_EVENT, &receive_event, sizeof(receive_event));
	printf("Create a receive event on receiver: %s\n", STATUS_OK_KO(res));

	// Allocate tx message
	res = CANTP_MsgDataAlloc_2016(&tx_msg, PCANTP_MSGTYPE_CAN);
	printf("Allocate tx CAN message: %s\n", STATUS_OK_KO(res));

	// Allocate rx message
	res = CANTP_MsgDataAlloc_2016(&rx_msg, PCANTP_MSGTYPE_NONE);
	printf("Allocate rx message: %s\n", STATUS_OK_KO(res));

	// Initialize Tx message containing "42"
	can_id = 0xA1;
	res = CANTP_MsgDataInit_2016(&tx_msg, can_id, PCANTP_CAN_MSGTYPE_STANDARD, 1, NULL, NULL);
	tx_msg.msgdata.can->data[0] = 0x42;
	printf("Initialize tx message: %s\n", STATUS_OK_KO(res));

	// Write "42" message
	res = CANTP_Write_2016(transmitter_handle, &tx_msg);
	printf("Write \"42\" message on transmitter: %s\n", STATUS_OK_KO(res));

	// Wait a receive event on receiver
	wait_result = WaitForSingleObject(receive_event, 100);
	printf("Wait a message on receiver: %s\n", OK_KO(wait_result == WAIT_OBJECT_0));

	// If we receive something on receiver, read the message
	if (wait_result == WAIT_OBJECT_0) {
		res = CANTP_Read_2016(receiver_handle, &rx_msg, NULL, PCANTP_MSGTYPE_NONE);
		printf("Read message on receiver: %s\n", STATUS_OK_KO(res));
		char *data = (char*)rx_msg.msgdata.any->data;
		printf("Check if the message is \"42\": %s\n", OK_KO(*data == 0x42));
	}

	// Free messages space
	res = CANTP_MsgDataFree_2016(&tx_msg);
	printf("Free tx message: %s\n", STATUS_OK_KO(res));
	res = CANTP_MsgDataFree_2016(&rx_msg);
	printf("Free rx message: %s\n", STATUS_OK_KO(res));

	// Close receive event
	res = CANTP_SetValue_2016(receiver_handle, PCANTP_PARAMETER_RECEIVE_EVENT, &null_handle, sizeof(HANDLE));
	printf("Stop receive event on receiver: %s\n", STATUS_OK_KO(res));
	res_b = CloseHandle(receive_event);
	printf("Close receive event: %s\n", OK_KO(res_b));

	// Uninitialize channels
	res = CANTP_Uninitialize_2016(transmitter_handle);
	printf("Uninitialize transmitter: %s\n", STATUS_OK_KO(res));
	res = CANTP_Uninitialize_2016(receiver_handle);
	printf("Uninitialize receiver: %s\n", STATUS_OK_KO(res));

	// Exit
	system("PAUSE");
	return EXIT_SUCCESS;
}

