import string
import os
from time import sleep
from PCAN_ISO_TP_2016 import *

IS_WINDOWS = platform.system() == 'Windows'

# Support keyboard
def getInput():
	sys.stdin.read(1)

# Isotp library
objPCANIsotp = PCAN_ISO_TP_2016()

# Help functions
def OK_KO(test):
    return "OK" if test else "KO" 

def STATUS_OK_KO(test):
    return OK_KO(objPCANIsotp.StatusIsOk_2016(test))

# Definitions
STMIN_600US = 0xF6
DATA_UNSEGMENTED = "PEAK"
DATA_SEGMENTED = "PEAK-System - PCAN-ISO-TP Sample"
# TODO: Change MSG definition to perform UNSEGMENTED or SEGMENTED ISO-TP message
MSG = DATA_SEGMENTED

#
# Main entry point of the program, start a small CAN ISO TP read/write example, client-side (writing)
#

# Initialize structs 
client_handle = PCANTP_HANDLE_USBBUS1 # TODO: modify the value according to your available PCAN devices.
#memset(&tx_msg, 0, sizeof(cantp_msg))
#memset(&mapping, 0, sizeof(cantp_mapping))

# Print version information
buffer = create_string_buffer(500)
objPCANIsotp.GetValue_2016(PCANTP_HANDLE_NONEBUS, PCANTP_PARAMETER_API_VERSION, buffer, 500)
print("PCAN-ISO-TP API Version: ", buffer.value)

# Initialize channel: CAN2.0 - 500Kbit/s
res = objPCANIsotp.Initialize_2016(client_handle, PCANTP_BAUDRATE_500K, 0, 0, 0)
print("Initialize: ", STATUS_OK_KO(res))

# Change STmin value to 600us
STmin = c_uint32(STMIN_600US)
res = objPCANIsotp.SetValue_2016(client_handle, PCANTP_PARAMETER_SEPARATION_TIME, STmin, sizeof(STmin))
print("Set STMIN = 600us: ", STATUS_OK_KO(res))

# Allocate tx message
tx_msg = cantp_msg()
res = objPCANIsotp.MsgDataAlloc_2016(tx_msg, PCANTP_MSGTYPE_ISOTP)
print("Allocate tx message: ", STATUS_OK_KO(res))

# Create a simple physical mapping: 
#    - Source 0xF1 (client), target 0x01 (server), CAN id 0xA1, CAN ID flow control 0xA2
#    - Diagnostic message in a classic format
mapping = cantp_mapping()
mapping.can_id = 0xA1
mapping.can_id_flow_ctrl = 0xA2
mapping.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD
mapping.netaddrinfo.extension_addr = 0x00
mapping.netaddrinfo.format = PCANTP_ISOTP_FORMAT_NORMAL
mapping.netaddrinfo.msgtype = PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC
mapping.netaddrinfo.source_addr = 0xF1
mapping.netaddrinfo.target_addr = 0x01
mapping.netaddrinfo.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL

# Add mapping on channel
res = objPCANIsotp.AddMapping_2016(client_handle, mapping)
print("Add a simple mapping: ", STATUS_OK_KO(res))
   		
if len(MSG) > 7:
	mappingSegmented = cantp_mapping()
	# data is too big to fit in an ISO-TP "Single Frame",
	#	Communication will be segmented a mapping to receive communications from the receiver: 
	#    - Source 0x01 (server), target 0xF1 (client), CAN id 0xA2, CAN ID flow control 0xA1
	#    - Diagnostic message in a classic format
	mappingSegmented.can_id = 0xA2
	mappingSegmented.can_id_flow_ctrl = 0xA1
	mappingSegmented.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD
	mappingSegmented.netaddrinfo.extension_addr = 0x00
	mappingSegmented.netaddrinfo.format = PCANTP_ISOTP_FORMAT_NORMAL
	mappingSegmented.netaddrinfo.msgtype = PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC
	mappingSegmented.netaddrinfo.source_addr = 0x01
	mappingSegmented.netaddrinfo.target_addr = 0xF1
	mappingSegmented.netaddrinfo.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL

	# Add mapping on channel
	res = objPCANIsotp.AddMapping_2016(client_handle, mappingSegmented)
	print("Add a simple mapping: ", STATUS_OK_KO(res))

# Initialize Tx message
txbuffer = create_string_buffer(len(MSG))
for i in range(len(MSG)):
	txbuffer[i] = ord(MSG[i]) if sys.version_info.major >= 3 else MSG[i]
res = objPCANIsotp.MsgDataInit_2016(tx_msg, PCANTP_CAN_ID_DEFINED_BY_NAI, mapping.can_msgtype, len(MSG), txbuffer, mapping.netaddrinfo)
print("Initialize tx message: ", STATUS_OK_KO(res))

# Write message
res = objPCANIsotp.Write_2016(client_handle, tx_msg)
print("Write \"", MSG, "\" message: ", STATUS_OK_KO(PCANTP_STATUS_OK))

# Sleep to let the transmission run
sleep(0.1)

rx_msg = cantp_msg()
if len(MSG) > 7:
	# Initialize Rx message
	res = objPCANIsotp.MsgDataAlloc_2016(rx_msg, PCANTP_MSGTYPE_NONE)
	print("Initialize rx message: ", STATUS_OK_KO(res))
	# Read loopback indication ISO-TP message
	res = objPCANIsotp.Read_2016(client_handle, rx_msg, None, PCANTP_MSGTYPE_NONE)
	print("CANTP_Read_2016 (indication): %s, netstatus=%02x" %(STATUS_OK_KO(res), rx_msg.msgdata.any.contents.netstatus))
	# Free message space
	res = objPCANIsotp.MsgDataFree_2016(rx_msg)
	print("Free rx message: ", STATUS_OK_KO(res))
	# Sleep to let the transmission complete
	sleep(1)

# Initialize Rx message
res = objPCANIsotp.MsgDataAlloc_2016(rx_msg, PCANTP_MSGTYPE_NONE)
print("Initialize rx message: ", STATUS_OK_KO(res))
# Read loopback indication ISO-TP message
res = objPCANIsotp.Read_2016(client_handle, rx_msg, None, PCANTP_MSGTYPE_NONE)
print("CANTP_Read_2016 (complete): %s, netstatus=%02x" %(STATUS_OK_KO(res), rx_msg.msgdata.any.contents.netstatus))
# Free message space
res = objPCANIsotp.MsgDataFree_2016(rx_msg)
print("Free rx message: ", STATUS_OK_KO(res))

# Free message space
res = objPCANIsotp.MsgDataFree_2016(tx_msg)
print("Free tx message: ", STATUS_OK_KO(res))

# Uninitialize channel
res = objPCANIsotp.Uninitialize_2016(client_handle)
print("Uninitialize: ", STATUS_OK_KO(res))

# Exit
print("Press <Enter> to close")
getInput()

