import string
import os
from time import sleep
from PCAN_ISO_TP_2016 import *

IS_WINDOWS = platform.system() == 'Windows'

# Support events
if not IS_WINDOWS: 
	import select
	__LIBC_OBJ = cdll.LoadLibrary("libc.so.6")

WAIT_OBJECT_0 = 0
def NULL_HANDLE():
	return c_void_p(0) if IS_WINDOWS else c_int(0)

# Support keyboard
def getInput():
    sys.stdin.read(1)

# Isotp library
objPCANIsotp = PCAN_ISO_TP_2016()

# Help functions
def OK_KO(test):
    return "OK" if test else "KO" 

def STATUS_OK_KO(test):
    return OK_KO(objPCANIsotp.StatusIsOk_2016(test))

# Definitions
STMIN_600US = 0xF6

#
# Main entry point of the program, start a small CAN ISO TP read/write example
#

# Initialize variables 
transmitter_handle = PCANTP_HANDLE_USBBUS1 # TODO: modify the value according to your available PCAN devices.
receiver_handle = PCANTP_HANDLE_USBBUS2 # TODO: modify the value according to your available PCAN devices.

# Print version information
buffer = create_string_buffer(500)
objPCANIsotp.GetValue_2016(PCANTP_HANDLE_NONEBUS, PCANTP_PARAMETER_API_VERSION, buffer, 500)
print("PCAN-ISO-TP API Version: ", buffer.value)

print("\n")
print("WARNING: this sample is not suited for segmented communication.")
print("         Data must be contained in a Single ISO-TP frame only.")
print("         Please check sample \"06_isotp_segmented_read_write\" for standard segmented communications.")
print("\n")
sleep(2)

# Initialize channels: CAN2.0 - 500Kbit/s
res = objPCANIsotp.Initialize_2016(transmitter_handle, PCANTP_BAUDRATE_500K, 0, 0, 0)
print("Initialize transmitter: ", STATUS_OK_KO(res))
res = objPCANIsotp.Initialize_2016(receiver_handle, PCANTP_BAUDRATE_500K, 0, 0, 0)
print("Initialize receiver: ", STATUS_OK_KO(res))

#Create a receive event on receiver
if IS_WINDOWS:
    receive_event = c_void_p(windll.kernel32.CreateEventA(None, 0,0,None))
    res = objPCANIsotp.SetValue_2016(receiver_handle, PCANTP_PARAMETER_RECEIVE_EVENT, receive_event, sizeof(receive_event))
    print("Create a receive event on receiver: ", STATUS_OK_KO(res))
else:
    receive_event = NULL_HANDLE()
    res = objPCANIsotp.GetValue_2016(receiver_handle, PCANTP_PARAMETER_RECEIVE_EVENT, receive_event, sizeof(receive_event))
    print("Get receive event on receiver: ", STATUS_OK_KO(res))

# Change STmin value to 600us
STmin = c_uint32(STMIN_600US)
res = objPCANIsotp.SetValue_2016(transmitter_handle, PCANTP_PARAMETER_SEPARATION_TIME, STmin, sizeof(STmin))
print("Set STMIN = 600us on transmitter: ", STATUS_OK_KO(res))
res = objPCANIsotp.SetValue_2016(receiver_handle, PCANTP_PARAMETER_SEPARATION_TIME, STmin, sizeof(STmin))
print("Set STMIN = 600us on receiver: ", STATUS_OK_KO(res))

# Allocate tx message
tx_msg = cantp_msg()
res = objPCANIsotp.MsgDataAlloc_2016(tx_msg, PCANTP_MSGTYPE_ISOTP)
print("Allocate tx message: ", STATUS_OK_KO(res))

# Allocate rx message
rx_msg = cantp_msg()
res = objPCANIsotp.MsgDataAlloc_2016(rx_msg, PCANTP_MSGTYPE_NONE)
print("Allocate rx message: ", STATUS_OK_KO(res))

# Create a simple physical mapping: 
#    - Source 0xF1 (transmitter), target 0x01 (receiver), CAN id 0xA1, CAN ID flow control 0xA2
#    - Diagnostic message in a classic format
mapping = cantp_mapping()
mapping.can_id = 0xA1
mapping.can_id_flow_ctrl = 0xA2
mapping.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD
mapping.netaddrinfo.extension_addr = 0x00
mapping.netaddrinfo.format = PCANTP_ISOTP_FORMAT_NORMAL
mapping.netaddrinfo.msgtype = PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC
mapping.netaddrinfo.source_addr = 0xF1
mapping.netaddrinfo.target_addr = 0x01
mapping.netaddrinfo.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL

# Add mapping on channels
res = objPCANIsotp.AddMapping_2016(transmitter_handle, mapping)
print("Add a simple mapping on transmitter: ", STATUS_OK_KO(res))
res = objPCANIsotp.AddMapping_2016(receiver_handle, mapping)
print("Add a simple mapping on receiver: ", STATUS_OK_KO(res))

# Initialize Tx message containing "42"
res = objPCANIsotp.MsgDataInit_2016(tx_msg, PCANTP_CAN_ID_DEFINED_BY_NAI, mapping.can_msgtype, 1, None, mapping.netaddrinfo)
tx_msg.msgdata.isotp.contents.data[0] = 0x42
print("Initialize tx message: ", STATUS_OK_KO(res))

# Write "42" message
res = objPCANIsotp.Write_2016(transmitter_handle, tx_msg)
print("Write \"42\" message: ", STATUS_OK_KO(res))

# Wait a receive event on receiver
if IS_WINDOWS:
	windows_wait_result = c_uint64(windll.kernel32.WaitForSingleObject(receive_event, 100))
	wait_result = True if windows_wait_result.value == WAIT_OBJECT_0 else False
else:
	readable, _, _ = select.select([receive_event.value], [], [], 0.1)
	wait_result = True if len(readable) > 0 else False
print("Wait a message on receiver: ", OK_KO(wait_result))

# If we receive something on the receiver, read the message
if wait_result:
	res = objPCANIsotp.Read_2016(receiver_handle, rx_msg, None, PCANTP_MSGTYPE_NONE)
	print("Read message on receiver: ", STATUS_OK_KO(res))
	data = rx_msg.msgdata.any.contents.data[0]
	print("Check if the message is \"42\": ", OK_KO(data == 0x42))

# Free messages space
res = objPCANIsotp.MsgDataFree_2016(tx_msg)
print("Free tx message: ", STATUS_OK_KO(res))
res = objPCANIsotp.MsgDataFree_2016(rx_msg)
print("Free rx message: ", STATUS_OK_KO(res))

# Close receive event
if IS_WINDOWS:
	res = objPCANIsotp.SetValue_2016(receiver_handle, PCANTP_PARAMETER_RECEIVE_EVENT, NULL_HANDLE(), sizeof(NULL_HANDLE()))
	print("Stop receive event on receiver: ", STATUS_OK_KO(res))
	res_b = windll.kernel32.CloseHandle(receive_event)
	print("Close receive event: ", OK_KO(res_b))

# Uninitialize transmitter and receiver
res = objPCANIsotp.Uninitialize_2016(transmitter_handle)
print("Uninitialize transmitter: ", STATUS_OK_KO(res))
res = objPCANIsotp.Uninitialize_2016(receiver_handle)
print("Uninitialize receiver: ", STATUS_OK_KO(res))

# Exit
print("Press <Enter> to close")
getInput()
    