import string
import os
from time import sleep
import copy
from PCAN_ISO_TP_2016 import *
import heavy_data

IS_WINDOWS = platform.system() == 'Windows'

# Support events
if not IS_WINDOWS: 
	import select
	__LIBC_OBJ = cdll.LoadLibrary("libc.so.6")

WAIT_OBJECT_0 = 0
def NULL_HANDLE():
	return c_void_p(0) if IS_WINDOWS else c_int(0)

# Support keyboard
def getInput():
    sys.stdin.read(1)

# Isotp library
objPCANIsotp = PCAN_ISO_TP_2016()

# Help functions
def OK_KO(test):
    return "OK" if test else "KO" 

def STATUS_OK_KO(test):
    return OK_KO(objPCANIsotp.StatusIsOk_2016(test))

def cantp_handle_toShortString(handle):
	"""
	Return the name of the channel

	parameters:
	 handle: Channel handle
	returns: 
	 string containing the name of the channel
	"""	
	
	if handle == PCANTP_HANDLE_NONEBUS: return "NONEBUS"		
	if handle == PCANTP_HANDLE_ISABUS1:	return "ISA1"
	if handle == PCANTP_HANDLE_ISABUS2: return "ISA2"
	if handle == PCANTP_HANDLE_ISABUS3: return "ISA3"
	if handle == PCANTP_HANDLE_ISABUS4: return "ISA4"
	if handle == PCANTP_HANDLE_ISABUS5: return "ISA5"
	if handle == PCANTP_HANDLE_ISABUS6: return "ISA6"
	if handle == PCANTP_HANDLE_ISABUS7: return "ISA7"
	if handle == PCANTP_HANDLE_ISABUS8: return "ISA8"
	if handle == PCANTP_HANDLE_DNGBUS1: return "DNG1"
	if handle == PCANTP_HANDLE_PCIBUS1: return "PCI1"
	if handle == PCANTP_HANDLE_PCIBUS2: return "PCI2"
	if handle == PCANTP_HANDLE_PCIBUS3: return "PCI3"
	if handle == PCANTP_HANDLE_PCIBUS4: return "PCI4"
	if handle == PCANTP_HANDLE_PCIBUS5: return "PCI5"
	if handle == PCANTP_HANDLE_PCIBUS6: return "PCI6"
	if handle == PCANTP_HANDLE_PCIBUS7: return "PCI7"
	if handle == PCANTP_HANDLE_PCIBUS8: return "PCI8"
	if handle == PCANTP_HANDLE_PCIBUS9: return "PCI9"
	if handle == PCANTP_HANDLE_PCIBUS10: return "PCI10"
	if handle == PCANTP_HANDLE_PCIBUS11: return "PCI11"
	if handle == PCANTP_HANDLE_PCIBUS12: return "PCI12"
	if handle == PCANTP_HANDLE_PCIBUS13: return "PCI13"
	if handle == PCANTP_HANDLE_PCIBUS14: return "PCI14"
	if handle == PCANTP_HANDLE_PCIBUS15: return "PCI15"
	if handle == PCANTP_HANDLE_PCIBUS16: return "PCI16"
	if handle == PCANTP_HANDLE_USBBUS1: return "USB1"
	if handle == PCANTP_HANDLE_USBBUS2: return "USB2"
	if handle == PCANTP_HANDLE_USBBUS3: return "USB3"
	if handle == PCANTP_HANDLE_USBBUS4: return "USB4"
	if handle == PCANTP_HANDLE_USBBUS5: return "USB5"
	if handle == PCANTP_HANDLE_USBBUS6: return "USB6"
	if handle == PCANTP_HANDLE_USBBUS7: return "USB7"
	if handle == PCANTP_HANDLE_USBBUS8: return "USB8"
	if handle == PCANTP_HANDLE_USBBUS9: return "USB9"
	if handle == PCANTP_HANDLE_USBBUS10: return "USB10"
	if handle == PCANTP_HANDLE_USBBUS11: return "USB11"
	if handle == PCANTP_HANDLE_USBBUS12: return "USB12"
	if handle == PCANTP_HANDLE_USBBUS13: return "USB13"
	if handle == PCANTP_HANDLE_USBBUS14: return "USB14"
	if handle == PCANTP_HANDLE_USBBUS15: return "USB15"
	if handle == PCANTP_HANDLE_USBBUS16: return "USB16"
	if handle == PCANTP_HANDLE_PCCBUS1: return "PCC1"
	if handle == PCANTP_HANDLE_PCCBUS2: return "PCC2"
	if handle == PCANTP_HANDLE_LANBUS1: return "LAN1"
	if handle == PCANTP_HANDLE_LANBUS2: return "LAN2"
	if handle == PCANTP_HANDLE_LANBUS3: return "LAN3"
	if handle == PCANTP_HANDLE_LANBUS4: return "LAN4"
	if handle == PCANTP_HANDLE_LANBUS5: return "LAN5"
	if handle == PCANTP_HANDLE_LANBUS6: return "LAN6"
	if handle == PCANTP_HANDLE_LANBUS7: return "LAN7"
	if handle == PCANTP_HANDLE_LANBUS8: return "LAN8"
	if handle == PCANTP_HANDLE_LANBUS9: return "LAN9"
	if handle == PCANTP_HANDLE_LANBUS10: return "LAN10"
	if handle == PCANTP_HANDLE_LANBUS11: return "LAN11"
	if handle == PCANTP_HANDLE_LANBUS12: return "LAN12"
	if handle == PCANTP_HANDLE_LANBUS13: return "LAN13"
	if handle == PCANTP_HANDLE_LANBUS14: return "LAN14"
	if handle == PCANTP_HANDLE_LANBUS15: return "LAN15"
	if handle == PCANTP_HANDLE_LANBUS16: return "LAN16"
	return "UNKNOWN"

def write_binary_output_file(file_path, data, len):
	"""
	Write a byte array in a binary file

	parameters:
	 file_path: Output file path
	 data: Data to write
	 len: Data length (in bytes)
	"""

	pdata = cast(data, POINTER(c_ubyte))
	with open(file_path, "wb") as file:
		for i in range(0, len, 2):
			msb = c_ubyte(pdata[i+1])
			file.write(msb)
			lsb = c_ubyte(pdata[i])
			file.write(lsb)

def wait_and_read_msg(handle, msg_buffer) :
	"""
	Wait and read single message

	parameters:
	 handle: Channel handle
	 msg_buffer: Received message (out)
	returns:
	 status
	"""

	# Get receive event if any
	receive_event = NULL_HANDLE()
	res = objPCANIsotp.GetValue_2016(handle, PCANTP_PARAMETER_RECEIVE_EVENT, receive_event, sizeof(receive_event))
	print("Get receive event on %s : %s" %(cantp_handle_toShortString(handle), STATUS_OK_KO(res)))

	# Wait receive event and get a message
	if objPCANIsotp.StatusIsOk_2016(res, PCANTP_STATUS_OK, False) and receive_event != None:
		res = PCANTP_STATUS_NO_MESSAGE
		if IS_WINDOWS:
			windows_wait_result = c_uint64(windll.kernel32.WaitForSingleObject(receive_event, 100))
			wait_result = True if windows_wait_result.value == WAIT_OBJECT_0 else False
		else:
			readable, _, _ = select.select([receive_event.value], [], [], 0.1)
			wait_result = True if len(readable) > 0 else False
		# If we receive something, read the message
		if wait_result:
			pMsgBuffer = cast(msg_buffer, POINTER(cantp_msg))
			res = objPCANIsotp.Read_2016(handle, pMsgBuffer.contents, None, PCANTP_MSGTYPE_NONE)
			print("Wait a message on %s : %s" %(cantp_handle_toShortString(handle), STATUS_OK_KO(res)))

			# Check if the message is totaly received (only in ISOTP mode)
			if objPCANIsotp.StatusIsOk_2016(res, PCANTP_STATUS_OK, False)\
				and (PCANTP_MSGTYPE_ISOTP.value & pMsgBuffer.contents.type) == PCANTP_MSGTYPE_ISOTP.value\
				and (pMsgBuffer.contents.msgdata.isotp.contents.netaddrinfo.msgtype & PCANTP_ISOTP_MSGTYPE_FLAG_INDICATION_RX.value) == PCANTP_ISOTP_MSGTYPE_FLAG_INDICATION_RX.value:

				# The message is being received, wait and show progress
				progress = cantp_msgprogress()			
				stopit = False
				while not stopit:
					sleep(0.3)
					res = objPCANIsotp.GetMsgProgress_2016(handle, pMsgBuffer.contents, PCANTP_MSGDIRECTION_RX, progress)
					print("RX Progress on %s = %d%%: %s" %(cantp_handle_toShortString(handle), progress.percentage, STATUS_OK_KO(res)))
					stopit = (progress.state != PCANTP_MSGPROGRESS_STATE_PROCESSING.value) 

				# The message is received, read it
				res = objPCANIsotp.Read_2016(handle, pMsgBuffer.contents, None, PCANTP_MSGTYPE_NONE)

	return res

# Definitions
STMIN_600US = 0xF6

#
# Main entry point of the program, start a small CAN ISO TP read/write example
#   -> Send a message containing Peak logo 
#   -> Receive message, wait complete reception (show progress)
#   -> Show loopback message and received message (Peak logo)
#

# Define TX and RX channels
transmitter_handle = PCANTP_HANDLE_USBBUS1 # TODO: modify the value according to your available PCAN devices.
receiver_handle = PCANTP_HANDLE_USBBUS2 # TODO: modify the value according to your available PCAN devices.

# Print version information
buffer = create_string_buffer(500)
objPCANIsotp.GetValue_2016(PCANTP_HANDLE_NONEBUS, PCANTP_PARAMETER_API_VERSION, buffer, 500)
print("PCAN-ISO-TP API Version: ", buffer.value)

# Initialize channels: CAN2.0 - 500Kbit/s
res = objPCANIsotp.Initialize_2016(transmitter_handle, PCANTP_BAUDRATE_500K, 0, 0, 0)
print("Initialize channel %s: %s" %(cantp_handle_toShortString(transmitter_handle), STATUS_OK_KO(res)))
res = objPCANIsotp.Initialize_2016(receiver_handle, PCANTP_BAUDRATE_500K, 0, 0, 0)
print("Initialize channel %s: %s" %(cantp_handle_toShortString(receiver_handle), STATUS_OK_KO(res)))

# Change STmin value to 600us
STmin = c_uint32(STMIN_600US)
res = objPCANIsotp.SetValue_2016(transmitter_handle, PCANTP_PARAMETER_SEPARATION_TIME, STmin, sizeof(STmin))
print("Set STMIN = 600us on channel %s: %s" %(cantp_handle_toShortString(transmitter_handle), STATUS_OK_KO(res)))
res = objPCANIsotp.SetValue_2016(receiver_handle, PCANTP_PARAMETER_SEPARATION_TIME, STmin, sizeof(STmin))
print("Set STMIN = 600us on channel %s: %s" %(cantp_handle_toShortString(receiver_handle), STATUS_OK_KO(res)))

#Create a receive event on transmitter (for loopback message)
if IS_WINDOWS:
	transmitter_receive_event = c_void_p(windll.kernel32.CreateEventA(None, 0,0,None))
	res = objPCANIsotp.SetValue_2016(transmitter_handle, PCANTP_PARAMETER_RECEIVE_EVENT, transmitter_receive_event, sizeof(transmitter_receive_event))
	print("Create a receive event on channel %s: %s" %(cantp_handle_toShortString(transmitter_handle), STATUS_OK_KO(res)))
else:
	transmitter_receive_event = NULL_HANDLE()
	res = objPCANIsotp.GetValue_2016(transmitter_handle, PCANTP_PARAMETER_RECEIVE_EVENT, transmitter_receive_event, sizeof(transmitter_receive_event))
	print("Get receive event on channel %s: %s" %(cantp_handle_toShortString(transmitter_handle), STATUS_OK_KO(res)))

#Create a receive event on receiver
if IS_WINDOWS:
	receiver_receive_event = c_void_p(windll.kernel32.CreateEventA(None, 0,0,None))
	res = objPCANIsotp.SetValue_2016(receiver_handle, PCANTP_PARAMETER_RECEIVE_EVENT, receiver_receive_event, sizeof(receiver_receive_event))
	print("Create a receive event on channel %s: %s" %(cantp_handle_toShortString(receiver_handle), STATUS_OK_KO(res)))
else:
	receiver_receive_event = NULL_HANDLE()
	res = objPCANIsotp.GetValue_2016(receiver_handle, PCANTP_PARAMETER_RECEIVE_EVENT, receiver_receive_event, sizeof(receiver_receive_event))
	print("Get receive event on channel %s: %s" %(cantp_handle_toShortString(receiver_handle), STATUS_OK_KO(res)))

# Allocate messages
tx_msg = cantp_msg()
res = objPCANIsotp.MsgDataAlloc_2016(tx_msg, PCANTP_MSGTYPE_ISOTP)
print("Allocate tx message: ", STATUS_OK_KO(res))
loopback_msg = cantp_msg()
res = objPCANIsotp.MsgDataAlloc_2016(loopback_msg, PCANTP_MSGTYPE_NONE)
print("Allocate loopback message: ", STATUS_OK_KO(res))
rx_msg = cantp_msg()
res = objPCANIsotp.MsgDataAlloc_2016(rx_msg, PCANTP_MSGTYPE_NONE)
print("Allocate rx message: ", STATUS_OK_KO(res))

# Create a simple physical mapping: 
#    - Source 0xF1 (transmitter), target 0x01 (receiver), CAN id 0xA1, CAN ID flow control 0xA2
#    - Diagnostic message in a classic format
mapping = cantp_mapping()
mapping.can_id = 0xA1
mapping.can_id_flow_ctrl = 0xA2
mapping.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD
mapping.can_tx_dlc = 0x0
mapping.netaddrinfo.extension_addr = 0x00
mapping.netaddrinfo.format = PCANTP_ISOTP_FORMAT_NORMAL
mapping.netaddrinfo.msgtype = PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC
mapping.netaddrinfo.source_addr = 0xF1
mapping.netaddrinfo.target_addr = 0x01
mapping.netaddrinfo.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL

# Create the associated reversed mapping: 
reverse_mapping = cantp_mapping()
reverse_mapping.can_id = mapping.can_id_flow_ctrl
reverse_mapping.can_id_flow_ctrl = mapping.can_id
reverse_mapping.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD
reverse_mapping.can_tx_dlc = 0x0
reverse_mapping.netaddrinfo = copy.deepcopy(mapping.netaddrinfo)
reverse_mapping.netaddrinfo.source_addr = mapping.netaddrinfo.target_addr
reverse_mapping.netaddrinfo.target_addr = mapping.netaddrinfo.source_addr

# Add mappings on channels
res = objPCANIsotp.AddMapping_2016(transmitter_handle, mapping)
print("Add a simple mapping on channel %s: %s" %(cantp_handle_toShortString(transmitter_handle), STATUS_OK_KO(res)))
res = objPCANIsotp.AddMapping_2016(transmitter_handle, reverse_mapping)
print("Add the reverse mapping on channel %s: %s" %(cantp_handle_toShortString(transmitter_handle), STATUS_OK_KO(res)))
res = objPCANIsotp.AddMapping_2016(receiver_handle, mapping)
print("Add a simple mapping on channel %s: %s" %(cantp_handle_toShortString(receiver_handle), STATUS_OK_KO(res)))
res = objPCANIsotp.AddMapping_2016(receiver_handle, reverse_mapping)
print("Add the reverse mapping on channel %s: %s" %(cantp_handle_toShortString(receiver_handle), STATUS_OK_KO(res)))

# Initialize Tx message containing a heavy data
res = objPCANIsotp.MsgDataInit_2016(tx_msg, PCANTP_CAN_ID_DEFINED_BY_NAI, mapping.can_msgtype, heavy_data.HEAVY_DATA_SIZE, heavy_data.HEAVY_DATA, mapping.netaddrinfo)
print("Initialize tx message: ", STATUS_OK_KO(res))

# Write message
res = objPCANIsotp.Write_2016(transmitter_handle, tx_msg)
print("Write message on channel %s: %s" %(cantp_handle_toShortString(transmitter_handle), STATUS_OK_KO(res)))

# Read loopback message and save it 
res = wait_and_read_msg(transmitter_handle, pointer(loopback_msg))
print("Read loopback message on channel %s: %s" %(cantp_handle_toShortString(transmitter_handle), STATUS_OK_KO(res)))
fileTxOk = objPCANIsotp.StatusIsOk_2016(res, PCANTP_STATUS_OK, False)
if fileTxOk:
	write_binary_output_file("loopback_message.png", loopback_msg.msgdata.any.contents.data, loopback_msg.msgdata.any.contents.length)

# Read received message and save it
res = wait_and_read_msg(receiver_handle, pointer(rx_msg))
print("Read message on channel %s: %s" %(cantp_handle_toShortString(receiver_handle), STATUS_OK_KO(res)))
fileRxOk = objPCANIsotp.StatusIsOk_2016(res, PCANTP_STATUS_OK, False)
if fileRxOk:
	write_binary_output_file("received_message.png", rx_msg.msgdata.any.contents.data, rx_msg.msgdata.any.contents.length)


	# Show & remove result: 
	if fileTxOk:
		print("\n >>> Opening transmitted message (PEAK logo).\nClose opening application to continue...\n")
		os.system("loopback_message.png" if IS_WINDOWS else "display loopback_message.png")
	else:
		print("\n >>> Failed to successfully transmit message (PEAK logo)!\n")

	if fileRxOk:
		print("\n >>> Opening received message (PEAK logo).\nClose opening application to continue...\n")
		os.system("received_message.png" if IS_WINDOWS else "display received_message.png")
	else:
		print("\n >>> Failed to successfully receive message (PEAK logo)!\n")

# Free messages space
res = objPCANIsotp.MsgDataFree_2016(tx_msg)
print("Free tx message: ", STATUS_OK_KO(res))
res = objPCANIsotp.MsgDataFree_2016(loopback_msg)
print("Free loopback message: ", STATUS_OK_KO(res))
res = objPCANIsotp.MsgDataFree_2016(rx_msg)
print("Free rx message: ", STATUS_OK_KO(res))

# Close receive event on transmitter
if IS_WINDOWS:
	res = objPCANIsotp.SetValue_2016(transmitter_handle, PCANTP_PARAMETER_RECEIVE_EVENT, NULL_HANDLE(), sizeof(NULL_HANDLE()))
	print("Stop receive event on transmitter: ", STATUS_OK_KO(res))
	res_b = windll.kernel32.CloseHandle(transmitter_receive_event)
	print("Close receive event: ", OK_KO(res_b))

# Close receive event on receiver
if IS_WINDOWS:
	res = objPCANIsotp.SetValue_2016(receiver_handle, PCANTP_PARAMETER_RECEIVE_EVENT, NULL_HANDLE(), sizeof(NULL_HANDLE()))
	print("Stop receive event on receiver: ", STATUS_OK_KO(res))
	res_b = windll.kernel32.CloseHandle(receiver_receive_event)
	print("Close receive event: ", OK_KO(res_b))

# Uninitialize channels
res = objPCANIsotp.Uninitialize_2016(transmitter_handle)
print("Uninitialize channel %s: %s" %(cantp_handle_toShortString(transmitter_handle), STATUS_OK_KO(res)))
res = objPCANIsotp.Uninitialize_2016(receiver_handle)
print("Uninitialize channel %s: %s" %(cantp_handle_toShortString(receiver_handle), STATUS_OK_KO(res)))

# Remove results and exit
print("Press <Enter> to close")
getInput()
if IS_WINDOWS:
	os.system("del loopback_message.png")
	os.system("del received_message.png")
else:
	os.system("rm -f loopback_message.png")
	os.system("rm -f received_message.png")



