﻿Imports System
Imports System.Collections.Generic
Imports System.Linq
Imports System.Text
Imports System.Threading.Tasks


Imports Peak.Can.Basic
Imports Peak.Can.IsoTp

Imports cantp_timestamp = System.UInt64

Module Module1

    Const STMIN_600US As UInt32 = &HF6

    ''' <summary>Entry point of the program, start a small CAN ISO TP read/write example</summary>
    Sub Main()
        ' Local variables
        Dim Res As cantp_status
        Dim read_status As cantp_status
        Dim Buffer As StringBuilder = New StringBuilder(500)
        Dim STmin As UInt32
        Dim rx_msg As cantp_msg
        Dim mapping As cantp_mapping
        Dim server_handle As cantp_handle

        ' Initialize variables
        server_handle = cantp_handle.PCANTP_HANDLE_USBBUS2 ' TODO: modify the value according to your available PCAN devices.
        ' Print version informations
        CanTpApi.GetValue_2016(cantp_handle.PCANTP_HANDLE_NONEBUS, cantp_parameter.PCANTP_PARAMETER_API_VERSION, Buffer, 500)
        Console.WriteLine("PCAN-ISO-TP API Version : {0}", Buffer)
        ' Initialize channel: CAN2.0 - 500Kbit/s
        Res = CanTpApi.Initialize_2016(server_handle, cantp_baudrate.PCANTP_BAUDRATE_500K)
        Console.WriteLine("Initialize : {0}", STATUS_OK_KO(Res))

        ' Create and set a receive event on receiver
        Dim receive_event As System.Threading.AutoResetEvent = New System.Threading.AutoResetEvent(False)
        If (IntPtr.Size = 4) Then
            Dim iBuffer As UInt32 = Convert.ToUInt32(receive_event.SafeWaitHandle.DangerousGetHandle.ToInt32)
            Res = CanTpApi.SetValue_2016(server_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, iBuffer, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt32))
        ElseIf (IntPtr.Size = 8) Then
            Dim iBuffer As Int64 = receive_event.SafeWaitHandle.DangerousGetHandle.ToInt64
            Dim byteArray() As Byte = BitConverter.GetBytes(iBuffer)
            Res = CanTpApi.SetValue_2016(server_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, byteArray, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt64))
        End If
        Console.WriteLine("Set receive event : {0}", STATUS_OK_KO(Res))

        ' Change STmin value to 600us
        STmin = STMIN_600US
        Res = CanTpApi.SetValue_2016(server_handle, cantp_parameter.PCANTP_PARAMETER_SEPARATION_TIME, STmin, CType(System.Runtime.InteropServices.Marshal.SizeOf(STmin), UInt32))
        Console.WriteLine("Set STMIN = 600us : {0}", STATUS_OK_KO(Res))

        ' Create a simple physical mapping 
        '    - Source 0xF1 (client), target 0x01 (server), CAN id 0xA1, CAN ID flow control 0xA2
        '    - Diagnostic message in a classic format
        mapping.can_id = &HA1
        mapping.can_id_flow_ctrl = &HA2
        mapping.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD
        mapping.netaddrinfo.extension_addr = &H0
        mapping.netaddrinfo.format = cantp_isotp_format.PCANTP_ISOTP_FORMAT_NORMAL
        mapping.netaddrinfo.msgtype = cantp_isotp_msgtype.PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC
        mapping.netaddrinfo.source_addr = &HF1
        mapping.netaddrinfo.target_addr = &H1
        mapping.netaddrinfo.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL


        ' Add mapping on channel
        Res = CanTpApi.AddMapping_2016(server_handle, mapping)
        Console.WriteLine("Add a simple mapping : {0}", STATUS_OK_KO(Res))
        ' NOTE: this Is a one-way mapping, the server Is only capable of 
        '	receiving segmented Or unsegmented ISO-TP message using "0xA1" CAN ID
        '	to be able to send ISO-TP message, another mapping Is required.

        ' Read while user do Not press Q
        Console.WriteLine("Start listening, press Q to quit.")
        Dim stopit As Boolean = False
        While Not stopit
            ' Wait a receive event on receiver
            '	note: timeout Is used to check keyboard hit.
            Dim wait_result As Boolean = receive_event.WaitOne(1000)
            ' If we receive something, read the message
            If wait_result Then
                Do
                    ' Allocate rx message
                    Res = CanTpApi.MsgDataAlloc_2016(rx_msg, cantp_msgtype.PCANTP_MSGTYPE_NONE)
                    Console.WriteLine("Allocate rx message : {0}", STATUS_OK_KO(Res))

                    ' Read first available message (no filtering based on message's type is set): 
                    Dim ts As cantp_timestamp
                    read_status = CanTpApi.Read_2016(server_handle, rx_msg, ts)
                    Console.WriteLine("Try to read a message : {0}", STATUS_OK_KO(read_status))

                    ' If we read something, print the message
                    If CanTpApi.StatusIsOk_2016(read_status) Then
                        Console.WriteLine()
                        Console.WriteLine("Print received data :")
                        print_data(rx_msg)
                        Console.WriteLine()
                    End If

                    ' Free message
                    Res = CanTpApi.MsgDataFree_2016(rx_msg)
                    Console.WriteLine("Free rx message : {0}", STATUS_OK_KO(Res))

                Loop While Not CanTpApi.StatusIsOk_2016(read_status, cantp_status.PCANTP_STATUS_NO_MESSAGE)
            End If

            ' Quit when user press Q
            If (Console.KeyAvailable) Then
                Dim keyboard_res As Char = Console.ReadKey().KeyChar
                If (keyboard_res = "Q"c OrElse keyboard_res = "q"c) Then
                    stopit = True
                End If
            End If
        End While

        ' Close receive event
        If IntPtr.Size = 4 Then
            Dim iBuffer As UInt32 = 0
            Res = CanTpApi.SetValue_2016(server_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, iBuffer, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt32))
        ElseIf IntPtr.Size = 8 Then
            Dim iBuffer As Int64 = 0
            Dim byteArray As Byte() = BitConverter.GetBytes(iBuffer)
            Res = CanTpApi.SetValue_2016(server_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, byteArray, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt64))
        End If
        Console.WriteLine("Stop receive event  : {0}", STATUS_OK_KO(Res))
        receive_event.Close()

        ' Uninitialize
        Res = CanTpApi.Uninitialize_2016(server_handle)
        Console.WriteLine("Uninitialize : {0}", STATUS_OK_KO(Res))

        ' Exit
        Console.WriteLine("Press any key to exit...")
        Console.In.Read()

    End Sub

    Private Function OK_KO(ByVal test As Boolean) As String
        If test Then
            Return "OK"
        End If
        Return "KO"
    End Function

    Private Function STATUS_OK_KO(ByVal test As cantp_status) As String
        Return OK_KO(CanTpApi.StatusIsOk_2016(test))
    End Function

    ''' <summary>Helper: print message data</summary>
    ''' <param name="msg">message to print</param>
    Private Sub print_data(ByRef msg As cantp_msg)
        If msg.Msgdata <> IntPtr.Zero Then
            Dim len As UInt32 = msg.Msgdata_any_Copy.length
            If len <> 0 Then
                Dim vals() As Byte = New Byte(len) {}
                If CanTpApi.getData_2016(msg, 0, vals, len) Then
                    Console.Write(vbTab & " Byte:")
                    For i As UInt32 = 0 To len - 1
                        Console.Write(" 0x{0:X2}", vals(i))
                    Next
                    Console.WriteLine()
                    Console.Write(vbTab & " Ascii:""")
                    For i As UInt32 = 0 To len - 1
                        Console.Write("{0}", Convert.ToChar(vals(i)))
                    Next
                    Console.WriteLine("""")
                End If
            End If
        End If
    End Sub

End Module
