﻿Imports System
Imports System.Collections.Generic
Imports System.Linq
Imports System.Text
Imports System.Threading.Tasks


Imports Peak.Can.Basic
Imports Peak.Can.IsoTp

Imports cantp_timestamp = System.UInt64

Module Module1

    Const STMIN_600US As UInt32 = &HF6
    Const DATA_UNSEGMENTED As String = "PEAK"
    Const DATA_SEGMENTED As String = "PEAK-System - PCAN-ISO-TP Sample"
    ' TODO: Change MSG definition To perform UNSEGMENTED Or SEGMENTED ISO-TP message
    Const MSG As String = DATA_SEGMENTED

    ''' <summary>Entry point of the program, start a small CAN ISO TP read/write example</summary>
    Sub Main()

        ' Local variables
        Dim Res As cantp_status
        Dim Buffer As StringBuilder = New StringBuilder(500)
        Dim STmin As UInt32
        Dim tx_msg As cantp_msg
        Dim rx_msg As cantp_msg
        Dim mapping As cantp_mapping
        Dim client_handle As cantp_handle
        Dim MSG_SIZE As Integer = MSG.Length

        ' Initialize variables
        client_handle = cantp_handle.PCANTP_HANDLE_USBBUS1 ' TODO: modify the value according to your available PCAN devices.

        ' Print version informations
        CanTpApi.GetValue_2016(cantp_handle.PCANTP_HANDLE_NONEBUS, cantp_parameter.PCANTP_PARAMETER_API_VERSION, Buffer, 500)
        Console.WriteLine("PCAN-ISO-TP API Version : {0}", Buffer)

        ' Initialize channel: CAN2.0 - 500Kbit/s
        Res = CanTpApi.Initialize_2016(client_handle, cantp_baudrate.PCANTP_BAUDRATE_500K)
        Console.WriteLine("Initialize : {0}", STATUS_OK_KO(Res))

        ' Change STmin value to 600us
        STmin = STMIN_600US
        Res = CanTpApi.SetValue_2016(client_handle, cantp_parameter.PCANTP_PARAMETER_SEPARATION_TIME, STmin, CType(System.Runtime.InteropServices.Marshal.SizeOf(STmin), UInt32))
        Console.WriteLine("Set STMIN = 600us : {0}", STATUS_OK_KO(Res))

        ' Allocate tx message
        Res = CanTpApi.MsgDataAlloc_2016(tx_msg, cantp_msgtype.PCANTP_MSGTYPE_ISOTP)
        Console.WriteLine("Allocate tx message : {0}", STATUS_OK_KO(Res))

        ' Create a simple physical mapping 
        '    - Source 0xF1 (client), target 0x01 (server), CAN id 0xA1, CAN ID flow control 0xA2
        '    - Diagnostic message in a classic format
        mapping.can_id = &HA1
        mapping.can_id_flow_ctrl = &HA2
        mapping.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD
        mapping.netaddrinfo.extension_addr = &H0
        mapping.netaddrinfo.format = cantp_isotp_format.PCANTP_ISOTP_FORMAT_NORMAL
        mapping.netaddrinfo.msgtype = cantp_isotp_msgtype.PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC
        mapping.netaddrinfo.source_addr = &HF1
        mapping.netaddrinfo.target_addr = &H1
        mapping.netaddrinfo.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL

        ' Add mapping on channel
        Res = CanTpApi.AddMapping_2016(client_handle, mapping)
        Console.WriteLine("Add a simple mapping : {0}", STATUS_OK_KO(Res))

        If (MSG_SIZE > 7) Then
            Dim mappingSegmented As cantp_mapping
            ' data Is too big to fit in an ISO-TP "Single Frame",
            '	Communication will be segmented a mapping to receive communications from the receiver: 
            '    - Source 0x01 (server), target 0xF1 (client), CAN id 0xA2, CAN ID flow control 0xA1
            '    - Diagnostic message in a classic format
            mappingSegmented.can_id = &HA2
            mappingSegmented.can_id_flow_ctrl = &HA1
            mappingSegmented.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD
            mappingSegmented.netaddrinfo.extension_addr = &H0
            mappingSegmented.netaddrinfo.format = cantp_isotp_format.PCANTP_ISOTP_FORMAT_NORMAL
            mappingSegmented.netaddrinfo.msgtype = cantp_isotp_msgtype.PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC
            mappingSegmented.netaddrinfo.source_addr = &H1
            mappingSegmented.netaddrinfo.target_addr = &HF1
            mappingSegmented.netaddrinfo.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL

            ' Add mapping on channel
            Res = CanTpApi.AddMapping_2016(client_handle, mappingSegmented)
            Console.WriteLine("Add a simple mapping : {0}", STATUS_OK_KO(Res))
        End If

        ' Initialize Tx message
        Dim bytes As Byte() = Encoding.ASCII.GetBytes(MSG)
        Res = CanTpApi.MsgDataInit_2016(tx_msg, CanTpApi.PCANTP_CAN_ID_DEFINED_BY_NAI, mapping.can_msgtype, MSG_SIZE, bytes, mapping.netaddrinfo)
        Console.WriteLine("Initialize tx message : {0}", STATUS_OK_KO(Res))

        ' Write message
        Res = CanTpApi.Write_2016(client_handle, tx_msg)
        Console.WriteLine("Write ""{0}"" message : {1}", MSG, STATUS_OK_KO(Res))

        ' Sleep to let the transmission runs
        System.Threading.Thread.Sleep(100)

        If (MSG_SIZE > 7) Then
            ' Initialize Rx message
            Res = CanTpApi.MsgDataAlloc_2016(rx_msg, cantp_msgtype.PCANTP_MSGTYPE_NONE)
            Console.WriteLine("Initialize rx message : {0}", STATUS_OK_KO(Res))
            ' Read loopback indication ISO-TP message
            Res = CanTpApi.Read_2016(client_handle, rx_msg)
            Console.WriteLine("CANTP_Read_2016 (indication) : {0}, netstatus={1}", STATUS_OK_KO(Res), getNetStatusAsHexaString(rx_msg))
            ' Free message space
            Res = CanTpApi.MsgDataFree_2016(rx_msg)
            Console.WriteLine("Free rx message : {0}", STATUS_OK_KO(Res))
            ' Sleep to let the transmission complete
            System.Threading.Thread.Sleep(1000)
        End If

        ' Initialize Rx message
        Res = CanTpApi.MsgDataAlloc_2016(rx_msg, cantp_msgtype.PCANTP_MSGTYPE_NONE)
        Console.WriteLine("Initialize rx message : {0}", STATUS_OK_KO(Res))
        ' Read ISO-TP message
        Res = CanTpApi.Read_2016(client_handle, rx_msg)
        Console.WriteLine("CANTP_Read_2016 (complete) : {0}, netstatus={1}", STATUS_OK_KO(Res), getNetStatusAsHexaString(rx_msg))
        ' Free message space
        Res = CanTpApi.MsgDataFree_2016(rx_msg)
        Console.WriteLine("Free rx message : {0}", STATUS_OK_KO(Res))

        ' Free message space
        Res = CanTpApi.MsgDataFree_2016(tx_msg)
        Console.WriteLine("Free tx message : {0}", STATUS_OK_KO(Res))

        ' Uninitialize
        Res = CanTpApi.Uninitialize_2016(client_handle)
        Console.WriteLine("Uninitialize : {0}", STATUS_OK_KO(Res))

        ' Exit
        Console.WriteLine("Press any key to exit...")
        Console.In.Read()

    End Sub

    Private Function OK_KO(ByVal test As Boolean) As String
        If test Then
            Return "OK"
        End If
        Return "KO"
    End Function

    Private Function STATUS_OK_KO(ByVal test As cantp_status) As String
        Return OK_KO(CanTpApi.StatusIsOk_2016(test))
    End Function

    Private Function getNetStatusAsHexaString(ByRef msg As cantp_msg) As String
        Dim netstatus As cantp_netstatus
        If CanTpApi.getNetStatus_2016(msg, netstatus) Then
            Return netstatus.ToString("X")
        Else
            Return "Unknown"
        End If
    End Function


End Module
