﻿Imports System
Imports System.Collections.Generic
Imports System.Linq
Imports System.Text
Imports System.Threading.Tasks


Imports Peak.Can.Basic
Imports Peak.Can.IsoTp

Imports cantp_timestamp = System.UInt64

Module Module1

    Const STMIN_600US As UInt32 = &HF6

    ''' <summary>Entry point of the program, start a small CAN ISO TP read/write example</summary> 
    Sub Main()
        ' Local variables
        Dim Res As cantp_status
        Dim Buffer As StringBuilder = New StringBuilder(500)
        Dim STmin As UInt32
        Dim rx_msg As cantp_msg
        Dim tx_msg As cantp_msg
        Dim mapping As cantp_mapping
        Dim receiver_handle As cantp_handle
        Dim transmitter_handle As cantp_handle

        ' Initialize handles
        transmitter_handle = cantp_handle.PCANTP_HANDLE_USBBUS1 ' TODO: modify the value according to your available PCAN devices.
        receiver_handle = cantp_handle.PCANTP_HANDLE_USBBUS2 ' TODO: modify the value according to your available PCAN devices.

        ' Print version informations
        CanTpApi.GetValue_2016(cantp_handle.PCANTP_HANDLE_NONEBUS, cantp_parameter.PCANTP_PARAMETER_API_VERSION, Buffer, 500)
        Console.WriteLine("PCAN-ISO-TP API Version : {0}", Buffer)

        Console.WriteLine(vbNewLine)
        Console.WriteLine("WARNING: this sample is not suited for segmented communication.")
        Console.WriteLine("         Data must be contained in a Single ISO-TP frame only.")
        Console.WriteLine("         Please check sample ""06_isotp_segmented_read_write"" for standard segmented communications.")
        Console.WriteLine(vbNewLine)
        System.Threading.Thread.Sleep(2000)

        ' Initialize channels : CAN2.0 - 500Kbit/s
        Res = CanTpApi.Initialize_2016(transmitter_handle, cantp_baudrate.PCANTP_BAUDRATE_500K)
        Console.WriteLine("Initialize transmitter : {0}", STATUS_OK_KO(Res))
        Res = CanTpApi.Initialize_2016(receiver_handle, cantp_baudrate.PCANTP_BAUDRATE_500K)
        Console.WriteLine("Initialize receiver : {0}", STATUS_OK_KO(Res))

        ' Create and set a receive event on receiver
        Dim receive_event As System.Threading.AutoResetEvent = New System.Threading.AutoResetEvent(False)
        If (IntPtr.Size = 4) Then
            Dim iBuffer As UInt32 = Convert.ToUInt32(receive_event.SafeWaitHandle.DangerousGetHandle.ToInt32)
            Res = CanTpApi.SetValue_2016(receiver_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, iBuffer, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt32))
        ElseIf (IntPtr.Size = 8) Then
            Dim iBuffer As Int64 = receive_event.SafeWaitHandle.DangerousGetHandle.ToInt64
            Dim byteArray() As Byte = BitConverter.GetBytes(iBuffer)
            Res = CanTpApi.SetValue_2016(receiver_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, byteArray, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt64))
        End If
        Console.WriteLine("Set receive event : {0}", STATUS_OK_KO(Res))

        ' Change STmin value to 600us
        STmin = STMIN_600US
        Res = CanTpApi.SetValue_2016(receiver_handle, cantp_parameter.PCANTP_PARAMETER_SEPARATION_TIME, STmin, CType(System.Runtime.InteropServices.Marshal.SizeOf(STmin), UInt32))
        Console.WriteLine("Set STMIN = 600us : {0}", STATUS_OK_KO(Res))
        Res = CanTpApi.SetValue_2016(transmitter_handle, cantp_parameter.PCANTP_PARAMETER_SEPARATION_TIME, STmin, CType(System.Runtime.InteropServices.Marshal.SizeOf(STmin), UInt32))
        Console.WriteLine("Set STMIN = 600us : {0}", STATUS_OK_KO(Res))

        ' Allocate tx message
        Res = CanTpApi.MsgDataAlloc_2016(tx_msg, cantp_msgtype.PCANTP_MSGTYPE_ISOTP)
        Console.WriteLine("Allocate tx message : {0}", STATUS_OK_KO(Res))

        ' Allocate rx message
        Res = CanTpApi.MsgDataAlloc_2016(rx_msg, cantp_msgtype.PCANTP_MSGTYPE_NONE)
        Console.WriteLine("Allocate rx message : {0}", STATUS_OK_KO(Res))

        ' Create a simple physical mapping 
        '    - Source 0xF1 (transmitter), target 0x01 (receiver), CAN id 0xA1, CAN ID flow control 0xA2
        '    - Diagnostic message in a classic format
        mapping.can_id = &HA1
        mapping.can_id_flow_ctrl = &HA2
        mapping.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD
        mapping.netaddrinfo.extension_addr = &H0
        mapping.netaddrinfo.format = cantp_isotp_format.PCANTP_ISOTP_FORMAT_NORMAL
        mapping.netaddrinfo.msgtype = cantp_isotp_msgtype.PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC
        mapping.netaddrinfo.source_addr = &HF1
        mapping.netaddrinfo.target_addr = &H1
        mapping.netaddrinfo.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL

        ' Add mapping on channels
        Res = CanTpApi.AddMapping_2016(transmitter_handle, mapping)
        Console.WriteLine("Add a simple mapping on transmitter : {0}", STATUS_OK_KO(Res))
        Res = CanTpApi.AddMapping_2016(receiver_handle, mapping)
        Console.WriteLine("Add a simple mapping on receiver : {0}", STATUS_OK_KO(Res))

        ' Initialize Tx message containing "42"
        Dim data() As Byte = {&H42}
        Res = CanTpApi.MsgDataInit_2016(tx_msg, CanTpApi.PCANTP_CAN_ID_DEFINED_BY_NAI, mapping.can_msgtype, 1, data, mapping.netaddrinfo)
        Console.WriteLine("Initialize tx message : {0}", STATUS_OK_KO(Res))
        ' Write "42" message
        Res = CanTpApi.Write_2016(transmitter_handle, tx_msg)
        Console.WriteLine("Write ""42"" message : {0}", STATUS_OK_KO(Res))

        ' Wait a receive event on receiver
        Dim wait_result As Boolean = receive_event.WaitOne(100)
        Console.WriteLine("Wait a message on receiver : {0}", OK_KO(wait_result))

        ' If we receive something on the receiver, read the message
        If wait_result Then
            Res = CanTpApi.Read_2016(receiver_handle, rx_msg)
            Console.WriteLine("Read message on receiver : {0}", STATUS_OK_KO(Res))
            Dim val As Byte = 0
            If (CanTpApi.getData_2016(rx_msg, 0, val)) Then
                Console.WriteLine("Check if the message is ""42"" : {0}", OK_KO(val = &H42))
            Else
                Console.WriteLine("Check if the message is ""42"" : NOK")
            End If
        End If

        ' Free messages
        Res = CanTpApi.MsgDataFree_2016(rx_msg)
        Console.WriteLine("Free rx message : {0}", STATUS_OK_KO(Res))
        Res = CanTpApi.MsgDataFree_2016(tx_msg)
        Console.WriteLine("Free tx message : {0}", STATUS_OK_KO(Res))

        ' Close receive event
        If IntPtr.Size = 4 Then
            Dim iBuffer As UInt32 = 0
            Res = CanTpApi.SetValue_2016(receiver_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, iBuffer, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt32))
        ElseIf IntPtr.Size = 8 Then
            Dim iBuffer As Int64 = 0
            Dim byteArray As Byte() = BitConverter.GetBytes(iBuffer)
            Res = CanTpApi.SetValue_2016(receiver_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, byteArray, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt64))
        End If
        Console.WriteLine("Stop receive event  : {0}", STATUS_OK_KO(Res))
        receive_event.Close()

        ' Uninitialize
        Res = CanTpApi.Uninitialize_2016(transmitter_handle)
        Console.WriteLine("Uninitialize transmitter : {0}", STATUS_OK_KO(Res))
        Res = CanTpApi.Uninitialize_2016(receiver_handle)
        Console.WriteLine("Uninitialize receiver : {0}", STATUS_OK_KO(Res))

        ' Exit
        Console.WriteLine("Press any key to exit...")
        Console.In.Read()

    End Sub

    Private Function OK_KO(ByVal test As Boolean) As String
        If test Then
            Return "OK"
        End If
        Return "KO"
    End Function

    Private Function STATUS_OK_KO(ByVal test As cantp_status) As String
        Return OK_KO(CanTpApi.StatusIsOk_2016(test))
    End Function

End Module
