﻿Imports System
Imports System.Collections.Generic
Imports System.Linq
Imports System.Text
Imports System.Threading.Tasks


Imports Peak.Can.Basic
Imports Peak.Can.IsoTp

Imports cantp_timestamp = System.UInt64
Imports cantp_bitrate = System.String

Module Module1
    'Define Bitrate: SAE J2284-4: High-Speed CAN (HSC) for Vehicle Applications at 500 kbps with CAN FD Data at 2 Mbps 
    Const PCAN_BITRATE_SAE_J2284_4 As cantp_bitrate = "f_clock=80000000,nom_brp=2,nom_tseg1=63,nom_tseg2=16,nom_sjw=16,data_brp=2,data_tseg1=15,data_tseg2=4,data_sjw=4"

    ''' <summary>Entry point of the program, start a small CANFD ISO TP read/write example</summary> 
    Sub Main()
        ' Local variables
        Dim Res As cantp_status
        Dim Buffer As StringBuilder = New StringBuilder(500)
        Dim rx_msg As cantp_msg
        Dim tx_msg As cantp_msg
        Dim receiver_handle As cantp_handle
        Dim transmitter_handle As cantp_handle

        ' Initialize handles
        transmitter_handle = cantp_handle.PCANTP_HANDLE_USBBUS1 ' TODO: modify the value according to your available PCAN devices.
        receiver_handle = cantp_handle.PCANTP_HANDLE_USBBUS2 ' TODO: modify the value according to your available PCAN devices.

        ' Print version informations
        CanTpApi.GetValue_2016(cantp_handle.PCANTP_HANDLE_NONEBUS, cantp_parameter.PCANTP_PARAMETER_API_VERSION, Buffer, 500)
        Console.WriteLine("PCAN-ISO-TP API Version : {0}", Buffer)

        ' Initialize channels, bitrate: SAE J2284-4
        Res = CanTpApi.InitializeFD_2016(transmitter_handle, PCAN_BITRATE_SAE_J2284_4)
        Console.WriteLine("Initialize transmitter : {0}", STATUS_OK_KO(Res))
        Res = CanTpApi.InitializeFD_2016(receiver_handle, PCAN_BITRATE_SAE_J2284_4)
        Console.WriteLine("Initialize receiver : {0}", STATUS_OK_KO(Res))

        ' Create and set a receive event on receiver
        Dim receive_event As System.Threading.AutoResetEvent = New System.Threading.AutoResetEvent(False)
        If (IntPtr.Size = 4) Then
            Dim iBuffer As UInt32 = Convert.ToUInt32(receive_event.SafeWaitHandle.DangerousGetHandle.ToInt32)
            Res = CanTpApi.SetValue_2016(receiver_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, iBuffer, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt32))
        ElseIf (IntPtr.Size = 8) Then
            Dim iBuffer As Int64 = receive_event.SafeWaitHandle.DangerousGetHandle.ToInt64
            Dim byteArray() As Byte = BitConverter.GetBytes(iBuffer)
            Res = CanTpApi.SetValue_2016(receiver_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, byteArray, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt64))
        End If
        Console.WriteLine("Set receive event : {0}", STATUS_OK_KO(Res))

        ' Allocate tx CAN-FD message
        Res = CanTpApi.MsgDataAlloc_2016(tx_msg, cantp_msgtype.PCANTP_MSGTYPE_CANFD)
        Console.WriteLine("Allocate tx message : {0}", STATUS_OK_KO(Res))

        ' Allocate rx message
        Res = CanTpApi.MsgDataAlloc_2016(rx_msg, cantp_msgtype.PCANTP_MSGTYPE_NONE)
        Console.WriteLine("Allocate rx message : {0}", STATUS_OK_KO(Res))

        ' Initialize Tx message containing "42"
        Dim can_id As UInt32 = &HA1
        Dim data() As Byte = {&H42}
        Res = CanTpApi.MsgDataInit_2016(tx_msg, can_id, cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD, 1, data)
        Console.WriteLine("Initialize tx message : {0}", STATUS_OK_KO(Res))

        ' Write "42" message
        Res = CanTpApi.Write_2016(transmitter_handle, tx_msg)
        Console.WriteLine("Write ""42"" message : {0}", STATUS_OK_KO(Res))

        ' Wait a receive event on receiver
        Dim wait_result As Boolean = receive_event.WaitOne(100)
        Console.WriteLine("Wait a message on receiver : {0}", OK_KO(wait_result))

        ' If we receive something on the receiver, read the message
        If wait_result Then
            Res = CanTpApi.Read_2016(receiver_handle, rx_msg)
            Console.WriteLine("Read message on receiver : {0}", STATUS_OK_KO(Res))
            Dim val As Byte = 0
            If (CanTpApi.getData_2016(rx_msg, 0, val)) Then
                Console.WriteLine("Check if the message is ""42"" : {0}", OK_KO(val = &H42))
            Else
                Console.WriteLine("Check if the message is ""42"" : NOK")
            End If
        End If

        ' Free messages
        Res = CanTpApi.MsgDataFree_2016(rx_msg)
        Console.WriteLine("Free rx message : {0}", STATUS_OK_KO(Res))
        Res = CanTpApi.MsgDataFree_2016(tx_msg)
        Console.WriteLine("Free tx message : {0}", STATUS_OK_KO(Res))

        ' Close receive event
        If IntPtr.Size = 4 Then
            Dim iBuffer As UInt32 = 0
            Res = CanTpApi.SetValue_2016(receiver_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, iBuffer, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt32))
        ElseIf IntPtr.Size = 8 Then
            Dim iBuffer As Int64 = 0
            Dim byteArray As Byte() = BitConverter.GetBytes(iBuffer)
            Res = CanTpApi.SetValue_2016(receiver_handle, cantp_parameter.PCANTP_PARAMETER_RECEIVE_EVENT, byteArray, CType(System.Runtime.InteropServices.Marshal.SizeOf(iBuffer), UInt64))
        End If
        Console.WriteLine("Stop receive event  : {0}", STATUS_OK_KO(Res))
        receive_event.Close()

        ' Uninitialize channels
        Res = CanTpApi.Uninitialize_2016(transmitter_handle)
        Console.WriteLine("Uninitialize transmitter : {0}", STATUS_OK_KO(Res))
        Res = CanTpApi.Uninitialize_2016(receiver_handle)
        Console.WriteLine("Uninitialize receiver : {0}", STATUS_OK_KO(Res))

        ' Exit
        Console.WriteLine("Press any key to exit...")
        Console.In.Read()

    End Sub

    Private Function OK_KO(ByVal test As Boolean) As String
        If test Then
            Return "OK"
        End If
        Return "KO"
    End Function

    Private Function STATUS_OK_KO(ByVal test As cantp_status) As String
        Return OK_KO(CanTpApi.StatusIsOk_2016(test))
    End Function

End Module
