#include <stdio.h>

#include "lib/PCAN-OBDonUDS.h"

#define OK_KO(test) (test)?"OK":"KO"
#define STATUS_OK_KO(test) OK_KO(OBDonUDS_StatusIsOk(test, POBDONUDS_STATUS_OK, false))

#define BUFFER_SIZE 256
#define MAX_NB_RESPONSES 16

int main()
{
	int result = -1;
	// Get API version
	char buffer[BUFFER_SIZE];
	memset(buffer, 0, BUFFER_SIZE);
	obd_status status = OBDonUDS_GetValue(PCANTP_HANDLE_NONEBUS, POBDONUDS_PARAMETER_API_VERSION, buffer, sizeof(buffer));
	printf("Get API version (%s): %s\n", STATUS_OK_KO(status), buffer);

	// Initialize
	cantp_handle channel = PCANTP_HANDLE_USBBUS1; // TODO: modify the value according to your available PCAN devices.
	printf("Channel : 0x%02x, Channel status : 0x%02x\n", channel, OBDonUDS_GetStatus(channel));
	printf("Connecting with automatic detection of baudrate...\n");
	status = OBDonUDS_Initialize(channel, (cantp_baudrate)OBD_BAUDRATE_AUTODETECT, (cantp_hwtype)(0), 0, 0);
	printf("Initialize (%s)\n", STATUS_OK_KO(status));

	if (OBDonUDS_StatusIsOk(status, POBDONUDS_STATUS_OK, false))
	{
		result = 1;
		obd_baudrate baudrate = (obd_baudrate)0;
		status = OBDonUDS_GetValue(channel, POBDONUDS_PARAMETER_BAUDRATE, &baudrate, sizeof(baudrate));
		printf("-> Baudrate (%s): %s\n", STATUS_OK_KO(status), (baudrate == OBD_BAUDRATE_500K) ? "500 kbit/s" : (baudrate == OBD_BAUDRATE_250K) ? "250kbit/s" : "unknown");

		obd_msgprotocol canIdLen = (obd_msgprotocol)0;
		status = OBDonUDS_GetValue(channel, POBDONUDS_PARAMETER_CAN_ID_LENGTH, &canIdLen, sizeof(canIdLen));
		printf("-> Can Id length (%s): %s\n", STATUS_OK_KO(status), (canIdLen == OBD_MSGPROTOCOL_11BIT) ? "11" : (canIdLen == OBD_MSGPROTOCOL_29BIT) ? "29" : "unknown");

		uint8_t numberOfECU = 0;
		status = OBDonUDS_GetValue(channel, POBDONUDS_PARAMETER_AVAILABLE_ECUS, &numberOfECU, sizeof(numberOfECU));
		printf("-> Number of OBDonUDS ECU detected (%s): %d\n", STATUS_OK_KO(status), numberOfECU);

		// Request to clear trouble codes using functional addressing scheme
		obd_DTC_t emissionSystemGroup = OBDONUDS_DTC_EMISSION_SYSTEM_GROUP;
		obd_msg msg_request; 
		memset(&msg_request, 0, sizeof(msg_request));
		status = OBDonUDS_ClearTroubleCodes(channel, canIdLen == OBD_MSGPROTOCOL_11BIT ? OBD_NAI_REQUEST_FUNCTIONAL_11B : OBD_NAI_REQUEST_FUNCTIONAL_29B,
			&msg_request, emissionSystemGroup);
		printf("Request Clear Emission-System Trouble Codes (%s)\n", STATUS_OK_KO(status));

		if (OBDonUDS_StatusIsOk(status, POBDONUDS_STATUS_OK, false)) {
			result = 2;
			// Wait for responses
			obd_msg msg_responses[MAX_NB_RESPONSES];
			memset(msg_responses, 0, sizeof(msg_responses));
			uint32_t nb_responses;
			obd_msg msg_request_confirmation;
			memset(&msg_request_confirmation, 0, sizeof(msg_request_confirmation));
			status = OBDonUDS_WaitForServiceFunctional(channel, &msg_request, MAX_NB_RESPONSES, false, msg_responses, &nb_responses, &msg_request_confirmation);
			printf("Wait for service functional (%s):\n", STATUS_OK_KO(status));
			if (OBDonUDS_StatusIsOk(status, POBDONUDS_STATUS_OK, false))
			{
				result = 3;
				printf("-> Received %d responses\n", nb_responses);
				for (uint32_t i = 0; i < nb_responses; ++i)
				{
					printf("Response number %d from ECU %d : service 0x%x ", i + 1, msg_responses[i].nai.source_addr, *(msg_responses[i].links.service_id));
					if (msg_responses[i].links.nrc != NULL)
					{
						printf("NRC 0x%x\n", *(msg_responses[i].links.nrc));
					}
					else 
					{
						printf("OK\n");
						result = 0;
					}
				}
			}
			else {
				printf("-> failed status: 0x%08X\n", status);
			}
			// Free messages
			OBDonUDS_MsgFree(&msg_request_confirmation);
			for (uint32_t i = 0; i < nb_responses; ++i)
				OBDonUDS_MsgFree(&(msg_responses[i]));
		}
		else {
			printf("-> failed status: 0x%08X\n", status);
		}

		// Free messages
		OBDonUDS_MsgFree(&msg_request);
	}
	else {
		printf("-> failed status: 0x%08X\n", status);
	}


	status = OBDonUDS_Uninitialize(channel);
	printf("Uninitialize (%s)\n", STATUS_OK_KO(status));
	return result;
}