#include "PCANBasicCLR.h"
#include "PCAN-ISO-TP-CLR_2016.h"
#include "PCAN-UDS-CLR_2013.h"


using namespace System;
using namespace System::IO;
using namespace System::Threading;
using namespace System::Runtime::InteropServices;
using namespace Peak::Can::IsoTp;
using namespace Peak::Can::Uds;

static String^ OK_KO(bool test)
{
	if (test)
		return "OK";
	return "KO";
}

static String^ STATUS_OK_KO(uds_status test)
{
	return OK_KO(UDSApi::StatusIsOk_2013(test));
}

/// <summary>Entry point of the program, start a UDS channel, ask ECureset service in UUDT mode (using 0x123 and 0x124 can id)</summary>
int main(array<System::String^>^ args)
{
	const int BUFFER_SIZE = 256;
	StringBuilder^ buffer = gcnew StringBuilder(BUFFER_SIZE);
	uds_status status;
	cantp_handle tp_handle;
	uds_msgconfig config_physical = {};
	uds_msg msg_request = {};
	uds_msg request_confirmation = {};
	uds_msg response = {};
	UInt32 timeout_request = 0;
	UInt32 timeout_response = 0;
	bool do_read;

	// Initialize variables
	tp_handle = cantp_handle::PCANTP_HANDLE_USBBUS1; // TODO: modify the value according to your available PCAN devices.

	// Print version informations
	status = UDSApi::GetValue_2013(cantp_handle::PCANTP_HANDLE_NONEBUS, uds_parameter::PUDS_PARAMETER_API_VERSION, buffer, BUFFER_SIZE);
	Console::WriteLine("PCAN-UDS API Version - {0}: {1}", buffer, STATUS_OK_KO(status));

	// Initialize channel
	status = UDSApi::Initialize_2013(tp_handle, cantp_baudrate::PCANTP_BAUDRATE_500K);
	Console::WriteLine("Initialize channel: {0}", STATUS_OK_KO(status));

	// Get timeout values
	status = UDSApi::GetValue_2013(tp_handle, uds_parameter::PUDS_PARAMETER_TIMEOUT_REQUEST, timeout_request, sizeof(UInt32));
	Console::WriteLine("Get request timeout value ({0}ms): {1}", timeout_request, STATUS_OK_KO(status));
	status = UDSApi::GetValue_2013(tp_handle, uds_parameter::PUDS_PARAMETER_TIMEOUT_RESPONSE, timeout_response, sizeof(UInt32));
	Console::WriteLine("Get response timeout value ({0}ms): {1}", timeout_response, STATUS_OK_KO(status));

	// Add filter on 0x123 and 0x124 can id
	status = UDSApi::AddCanIdFilter_2013(tp_handle, 0x123);
	Console::WriteLine("Add can id filter (0x123): {0}", STATUS_OK_KO(status));
	status = UDSApi::AddCanIdFilter_2013(tp_handle, 0x124);
	Console::WriteLine("Add can id filter (0x124): {0}", STATUS_OK_KO(status));

	// Initialize the request configuration: UUDT message using 0x123 can id.
	config_physical.can_id = 0x123;
	config_physical.can_msgtype = cantp_can_msgtype::PCANTP_CAN_MSGTYPE_STANDARD;
	config_physical.nai.protocol = uds_msgprotocol::PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL;
	config_physical.nai.target_type = cantp_isotp_addressing::PCANTP_ISOTP_ADDRESSING_PHYSICAL;
	config_physical.type = uds_msgtype::PUDS_MSGTYPE_UUDT;

	// Execute ECUReset
	status = UDSApi::SvcECUReset_2013(tp_handle, config_physical, msg_request, UDSApi::uds_svc_param_er::PUDS_SVC_PARAM_ER_HR);
	Console::WriteLine("Execute ECUReset service: {0}", STATUS_OK_KO(status));

	// Wait request confirmation (loopback)
	status = UDSApi::WaitForSingleMessage_2013(tp_handle, msg_request, true, timeout_request, UDSApi::PUDS_P2CAN_ENHANCED_SERVER_MAX_DEFAULT, request_confirmation);
	Console::WriteLine("Wait request confirmation: {0}", STATUS_OK_KO(status));

	// Read the first available UUDT message (server should reply with can id 0x124)
	do
	{
		status = UDSApi::Read_2013(tp_handle, response);
		do_read = UDSApi::StatusIsOk_2013(status, PUDS_STATUS_NO_MESSAGE, false);
	} while (do_read);

	if (UDSApi::StatusIsOk_2013(status, PUDS_STATUS_OK, false))
	{
		Byte val;
		Console::Write("Read response can ID=0x{0:X4} [", response.msg.can_info.can_id);
		for (int i = 0; i < response.msg.msgdata.any->length; i++)
		{
			Console::Write(" 0x{0:X2}", (int)response.msg.msgdata.any->data[i]);
		}
		Console::WriteLine(" ]");
	}
	else
	{
		Console::WriteLine("Failed to read message: {0}", STATUS_OK_KO(status));
	}

	// Free message structures
	status = UDSApi::MsgFree_2013(msg_request);
	Console::WriteLine("Free request message: {0}", STATUS_OK_KO(status));
	status = UDSApi::MsgFree_2013(request_confirmation);
	Console::WriteLine("Free request confirmation: {0}", STATUS_OK_KO(status));
	status = UDSApi::MsgFree_2013(response);
	Console::WriteLine("Free response message: {0}", STATUS_OK_KO(status));

	// Close client
	status = UDSApi::Uninitialize_2013(tp_handle);
	Console::WriteLine("Uninitialize channel: {0}", STATUS_OK_KO(status));

	// Exit
	Console::WriteLine("Press any key to continue...");
	Console::Read();
}
