#include "stdafx.h"

#include "lib/PCAN-UDS_2013.h"

#define OK_KO(test) (test)?"OK":"KO"
#define STATUS_OK_KO(test) OK_KO(UDS_StatusIsOk_2013(test, PUDS_STATUS_OK, false))

#define BUFFER_SIZE 256
#define FORCE_CUSTOM_SESSION 1

/// <summary>Helper: check if two UDS session info structure are the same</summary>
/// <param name="session_1">Session to compare</param>
/// <param name="session_2">Session to compare</param>
/// <returns>Same session info (true) or not (false)</returns>
bool is_same_uds_sessioninfo(uds_sessioninfo *session_1, uds_sessioninfo *session_2) {
	bool res = false;
	if (session_1->nai.protocol == session_2->nai.protocol
		&& session_1->nai.target_type == session_2->nai.target_type
		&& session_1->nai.source_addr == session_2->nai.source_addr
		&& session_1->nai.target_addr == session_2->nai.target_addr
		&& session_1->nai.extension_addr == session_2->nai.extension_addr
		&& session_1->can_msg_type == session_2->can_msg_type
		&& session_1->session_type == session_2->session_type
		&& session_1->timeout_p2can_server_max == session_2->timeout_p2can_server_max
		&& session_1->timeout_enhanced_p2can_server_max == session_2->timeout_enhanced_p2can_server_max
		&& session_1->s3_client_ms == session_2->s3_client_ms) {
		res = true;
	}
	return res;
}

/// <summary>Entry point of the program, start a UDS channel, ask ECureset service and set new session info</summary>
int main()
{
	char buffer[BUFFER_SIZE];
	uds_status status;
	cantp_handle tp_handle;
	uds_msgconfig config_physical;
	uds_msg msg_request;
	uds_msg request_confirmation;
	uds_msg response;
	uds_sessioninfo new_sessioninfo;
	uds_sessioninfo read_sessioninfo;

	// Initialize variables
	tp_handle = PCANTP_HANDLE_USBBUS1; // TODO: modify the value according to your available PCAN devices.
	buffer[0] = '\0';
	memset(&config_physical, 0, sizeof(uds_msgconfig));
	memset(&msg_request, 0, sizeof(uds_msg));
	memset(&request_confirmation, 0, sizeof(uds_msg));
	memset(&response, 0, sizeof(uds_msg));
	memset(&new_sessioninfo, 0, sizeof(uds_sessioninfo));
	memset(&read_sessioninfo, 0, sizeof(uds_sessioninfo));

	// Print version informations
	status = UDS_GetValue_2013(PCANTP_HANDLE_NONEBUS, PUDS_PARAMETER_API_VERSION, buffer, BUFFER_SIZE);
	printf("PCAN-UDS API Version - %s: %s\n", buffer, STATUS_OK_KO(status));

	// Initialize client
	status = UDS_Initialize_2013(tp_handle, PCANTP_BAUDRATE_500K, (cantp_hwtype)0, 0, 0);
	printf("Initialize channel: %s\n", STATUS_OK_KO(status));

	// Initialize a physical configuration
	config_physical.can_id = (uint32_t)-1;
	config_physical.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD;
	config_physical.nai.protocol = PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL;
	config_physical.nai.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL;
	config_physical.type = PUDS_MSGTYPE_USDT;
	config_physical.nai.source_addr = PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT;
	config_physical.nai.target_addr = PUDS_ISO_15765_4_ADDR_ECU_1;
	config_physical.nai.extension_addr = 0;

	// Execute ECUReset and wait response
	status = UDS_SvcECUReset_2013(tp_handle, config_physical, &msg_request, PUDS_SVC_PARAM_ER_HR);
	printf("Execute ECUReset service: %s\n", STATUS_OK_KO(status));
	status = UDS_WaitForService_2013(tp_handle, &msg_request, &response, &request_confirmation);
	printf("Wait for service: %s\n", STATUS_OK_KO(status));

	if (FORCE_CUSTOM_SESSION) {
		// Some custom ECU may be in a non default session after reset
		// to inform the UDS API, it is possible to override the current session information:

		// Initialize new session info
		new_sessioninfo.can_msg_type = PCANTP_CAN_MSGTYPE_STANDARD;
		new_sessioninfo.session_type = 0x05;
		new_sessioninfo.timeout_p2can_server_max = 1;
		new_sessioninfo.timeout_enhanced_p2can_server_max = 2;
		new_sessioninfo.s3_client_ms = 8;
		new_sessioninfo.nai = config_physical.nai;

		// Set new session info
		status = UDS_SetValue_2013(tp_handle, PUDS_PARAMETER_SESSION_INFO, &new_sessioninfo, sizeof(uds_sessioninfo));
		printf("Set new session info: %s\n", STATUS_OK_KO(status));

		// Get session info parameter and check if the new value is added
		read_sessioninfo.nai = config_physical.nai;
		status = UDS_GetValue_2013(tp_handle, PUDS_PARAMETER_SESSION_INFO, &read_sessioninfo, sizeof(uds_sessioninfo));
		printf("Get session info: %s\n", STATUS_OK_KO(status));
		printf("Check added session info: %s\n", OK_KO(is_same_uds_sessioninfo(&read_sessioninfo, &new_sessioninfo) == true));
	}

	// Free message structures
	status = UDS_MsgFree_2013(&msg_request);
	printf("Free request message: %s\n", STATUS_OK_KO(status));
	status = UDS_MsgFree_2013(&request_confirmation);
	printf("Free request confirmation: %s\n", STATUS_OK_KO(status));
	status = UDS_MsgFree_2013(&response);
	printf("Free response message: %s\n", STATUS_OK_KO(status));

	// Close client
	status = UDS_Uninitialize_2013(tp_handle);
	printf("Uninitialize channel: %s\n", STATUS_OK_KO(status));

	// Exit
	system("PAUSE");
	return EXIT_SUCCESS;
}

