#include "stdafx.h"

#include "lib/PCAN-UDS_2013.h"

#define OK_KO(test) (test)?"OK":"KO"
#define STATUS_OK_KO(test) OK_KO(UDS_StatusIsOk_2013(test, PUDS_STATUS_OK, false))

#define BUFFER_SIZE 256

/// <summary>
///   Entry point of the program, start a small server wich only support ECUReset service.
///   This server listen only 0x123 can id and respond with 0x124 can id in UUDT mode.
/// </summary>
int main()
{
	uds_status status;
	cantp_handle tp_handle;
	uint32_t server_address;
	uint64_t null_handle;
	char buffer[BUFFER_SIZE];
	HANDLE receive_event;
	BOOL boolean_status;
	uds_msgconfig config_physical;
	bool stop;
	DWORD wait_result;
	uds_status read_status;
	uds_msg request_msg;
	uds_msg response_msg;
	int keyboard_res;

	// Initialize variables
	tp_handle = PCANTP_HANDLE_USBBUS2; // TODO: modify the value according to your available PCAN devices.
	null_handle = 0;
	server_address = PUDS_ISO_15765_4_ADDR_ECU_1;
	buffer[0] = '\0';
	memset(&config_physical, 0, sizeof(uds_msgconfig));
	memset(&request_msg, 0, sizeof(uds_msg));
	memset(&response_msg, 0, sizeof(uds_msg));

	// Print version informations
	status = UDS_GetValue_2013(PCANTP_HANDLE_NONEBUS, PUDS_PARAMETER_API_VERSION, buffer, BUFFER_SIZE);
	printf("PCAN-UDS API Version - %s: %s\n", buffer, STATUS_OK_KO(status));

	// Initialize server
	status = UDS_Initialize_2013(tp_handle, PCANTP_BAUDRATE_500K, (cantp_hwtype)0, 0, 0);
	printf("Initialize channel: %s\n", STATUS_OK_KO(status));

	// Set server address parameter
	status = UDS_SetValue_2013(tp_handle, PUDS_PARAMETER_SERVER_ADDRESS, &server_address, sizeof(uint32_t));
	printf("Set server address: %s\n", STATUS_OK_KO(status));

	// Set a receive event
	receive_event = CreateEvent(NULL, FALSE, FALSE, NULL);
	status = UDS_SetValue_2013(tp_handle, PUDS_PARAMETER_RECEIVE_EVENT, &receive_event, sizeof(receive_event));
	printf("Set receive event parameter: %s\n", STATUS_OK_KO(status));

	// Add filter on 0x123 and 0x124 can id
	status = UDS_AddCanIdFilter_2013(tp_handle, 0x123);
	printf("Add can id filter (0x123): %s\n", STATUS_OK_KO(status));
	status = UDS_AddCanIdFilter_2013(tp_handle, 0x124);
	printf("Add can id filter (0x124): %s\n", STATUS_OK_KO(status));

	// Initialize the response configuration
	config_physical.can_id = 0x124;
	config_physical.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD;
	config_physical.nai.protocol = PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL;
	config_physical.nai.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL;
	config_physical.type = PUDS_MSGTYPE_UUDT;

	// Read while user do not press Q
	printf("Start listening, press Q to quit.\n");
	stop = false;
	do {

		// Wait a receive event on receiver
		//	note: timeout is used to check keyboard hit.
		wait_result = WaitForSingleObject(receive_event, 1000);

		// If we get a receive event
		if (wait_result == WAIT_OBJECT_0) {

			do {

				// Read first available message (no filtering based on message's type is set):
				read_status = UDS_Read_2013(tp_handle, &request_msg, NULL, NULL);
				printf("Try to read a message: %s\n", STATUS_OK_KO(read_status));
				if (UDS_StatusIsOk_2013(read_status, PUDS_STATUS_OK, false)) {

					// We receive a request, check its length and if it is not a loopback message and if it is a UUDT message
					if ((request_msg.type & PUDS_MSGTYPE_UUDT) == PUDS_MSGTYPE_UUDT && request_msg.msg.msgdata.any->length >= 1 && (request_msg.msg.msgdata.any->flags & PCANTP_MSGFLAG_LOOPBACK) == 0) {

						// This is a valid request, switch services
						switch (*request_msg.links.service_id) {
						case PUDS_SI_ECUReset:

							// Allocate response message
							if (request_msg.links.param[0] == PUDS_SVC_PARAM_ER_ERPSD) {
								status = UDS_MsgAlloc_2013(&response_msg, config_physical, 3);
								response_msg.links.param[1] = 0x66;	// power down time
							}
							else {
								status = UDS_MsgAlloc_2013(&response_msg, config_physical, 2);
							}
							printf("Prepare response message for ECUReset service: %s\n", STATUS_OK_KO(status));

							if (UDS_StatusIsOk_2013(status, PUDS_STATUS_OK, false)) {
								// Fill parameters
								*response_msg.links.service_id = PUDS_SI_ECUReset + PUDS_SI_POSITIVE_RESPONSE;
								response_msg.links.param[0] = request_msg.links.param[0];

								// Write response message
								status = UDS_Write_2013(tp_handle, &response_msg);
								printf("Write response message for ECUReset service: %s\n", STATUS_OK_KO(status));
							}

							// Free response message (and clean memory in order to reallocate later)
							status = UDS_MsgFree_2013(&response_msg);
							printf("Free response message: %s\n", STATUS_OK_KO(status));
							break;
						default:
							printf("Unknown service (0x%02x)\n", *request_msg.links.service_id);
							break;
						}
					}
				}

				// Free request message (and clean memory in order to reallocate later)
				status = UDS_MsgFree_2013(&request_msg);
				printf("Free request message: %s\n", STATUS_OK_KO(status));
			} while (!UDS_StatusIsOk_2013(read_status, PUDS_STATUS_NO_MESSAGE, false));
		}

		// Quit when user press Q
		if (_kbhit()) {
			keyboard_res = _getch();
			if (keyboard_res == 'Q' || keyboard_res == 'q') {
				stop = true;
			}
		}
	} while (stop == false);

	// Close receive event
	status = UDS_SetValue_2013(tp_handle, PUDS_PARAMETER_RECEIVE_EVENT, &null_handle, sizeof(HANDLE));
	printf("Stop receive event: %s\n", STATUS_OK_KO(status));
	boolean_status = CloseHandle(receive_event);
	printf("Close receive event: %s\n", OK_KO(boolean_status));

	// Close server
	status = UDS_Uninitialize_2013(tp_handle);
	printf("Uninitialize channel: %s\n", STATUS_OK_KO(status));

	//Exit
	system("PAUSE");
	return EXIT_SUCCESS;
}

