#include "stdafx.h"

#include "lib/PCAN-UDS_2013.h"

#define OK_KO(test) (test)?"OK":"KO"
#define STATUS_OK_KO(test) OK_KO(UDS_StatusIsOk_2013(test, PUDS_STATUS_OK, false))

#define BUFFER_SIZE 256

/// <summary>Entry point of the program, start a UDS channel, ask ECureset service in UUDT mode (using 0x123 and 0x124 can id)</summary>
int main()
{
	char buffer[BUFFER_SIZE];
	uds_status status;
	cantp_handle tp_handle;
	uds_msgconfig config_physical;
	uds_msg msg_request;
	uds_msg request_confirmation;
	uds_msg response;
	uint32_t timeout_request;
	uint32_t timeout_response;
	bool do_read;

	// Initialize variables
	tp_handle = PCANTP_HANDLE_USBBUS1; // TODO: modify the value according to your available PCAN devices.
	buffer[0] = '\0';
	memset(&config_physical, 0, sizeof(uds_msgconfig));
	memset(&msg_request, 0, sizeof(uds_msg));
	memset(&request_confirmation, 0, sizeof(uds_msg));
	memset(&response, 0, sizeof(uds_msg));

	// Print version informations
	status = UDS_GetValue_2013(PCANTP_HANDLE_NONEBUS, PUDS_PARAMETER_API_VERSION, buffer, BUFFER_SIZE);
	printf("PCAN-UDS API Version - %s: %s\n", buffer, STATUS_OK_KO(status));

	// Initialize channel
	status = UDS_Initialize_2013(tp_handle, PCANTP_BAUDRATE_500K, (cantp_hwtype)0, 0, 0);
	printf("Initialize channel: %s\n", STATUS_OK_KO(status));

	// Get timeout values
	status = UDS_GetValue_2013(tp_handle, PUDS_PARAMETER_TIMEOUT_REQUEST, &timeout_request, sizeof(timeout_request));
	printf("Get request timeout value (%ums): %s\n", timeout_request, STATUS_OK_KO(status));
	status = UDS_GetValue_2013(tp_handle, PUDS_PARAMETER_TIMEOUT_RESPONSE, &timeout_response, sizeof(timeout_response));
	printf("Get response timeout value (%ums): %s\n", timeout_response, STATUS_OK_KO(status));

	// Add filter on 0x123 and 0x124 can id
	status = UDS_AddCanIdFilter_2013(tp_handle, 0x123);
	printf("Add can id filter (0x123): %s\n", STATUS_OK_KO(status));
	status = UDS_AddCanIdFilter_2013(tp_handle, 0x124);
	printf("Add can id filter (0x124): %s\n", STATUS_OK_KO(status));

	// Initialize the request configuration: UUDT message using 0x123 can id.
	config_physical.can_id = 0x123;
	config_physical.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD;
	config_physical.nai.protocol = PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL;
	config_physical.nai.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL;
	config_physical.type = PUDS_MSGTYPE_UUDT;

	// Execute ECUReset
	status = UDS_SvcECUReset_2013(tp_handle, config_physical, &msg_request, PUDS_SVC_PARAM_ER_HR);
	printf("Execute ECUReset service: %s\n", STATUS_OK_KO(status));

	// Wait request confirmation (loopback)
	status = UDS_WaitForSingleMessage_2013(tp_handle, &msg_request, true, timeout_request, PUDS_P2CAN_ENHANCED_SERVER_MAX_DEFAULT, &request_confirmation);
	printf("Wait request confirmation: %s\n", STATUS_OK_KO(status));

	// Read the first available UUDT message (server should reply with can id 0x124)
	do {
		status = UDS_Read_2013(tp_handle, &response, NULL, NULL);
		do_read = UDS_StatusIsOk_2013(status, PUDS_STATUS_NO_MESSAGE, false);
	} while (do_read);

	if (UDS_StatusIsOk_2013(status, PUDS_STATUS_OK, false)) {
		printf("Read response can ID=0x%04x [", response.msg.can_info.can_id);
		for (uint32_t i = 0; i < response.msg.msgdata.any->length; i++)
			printf(" 0x%02x", response.msg.msgdata.any->data[i]);
		printf(" ]\n");
	}
	else {
		printf("Failed to read message: %s\n", STATUS_OK_KO(status));
	}

	// Free message structures
	status = UDS_MsgFree_2013(&msg_request);
	printf("Free request message: %s\n", STATUS_OK_KO(status));
	status = UDS_MsgFree_2013(&request_confirmation);
	printf("Free request confirmation: %s\n", STATUS_OK_KO(status));
	status = UDS_MsgFree_2013(&response);
	printf("Free response message: %s\n", STATUS_OK_KO(status));

	// Close client
	status = UDS_Uninitialize_2013(tp_handle);
	printf("Uninitialize channel: %s\n", STATUS_OK_KO(status));

	// Exit
	system("PAUSE");
	return EXIT_SUCCESS;
}

