program client_request_ecu_reset_UUDT;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  ShellApi,
  windows,
  PUDS_2013 in 'PUDS_2013.pas',
  PCANBasic in 'PCANBasic.pas',
  PCANTP_2016 in 'PCANTP_2016.pas';

type
  Puds_sessioninfo = ^uds_sessioninfo;

Function OK_KO(test: Boolean): String;
begin
  If test Then
    result := 'OK'
  else
    result := 'KO';
End;

Function STATUS_OK_KO(test: uds_status): String;
begin
  result := OK_KO(TUDSApi.StatusIsOk_2013(test));
End;

/// <summary>Entry point of the program, start a UDS channel, ask ECureset service in UUDT mode (using 0x123 and 0x124 can id)</summary>
var

  buffer: array [0 .. 255] of AnsiChar;
  status: uds_status;
  tp_handle: cantp_handle;
  config_physical: uds_msgconfig;
  msg_request: uds_msg;
  request_confirmation: uds_msg;
  response: uds_msg;
  timeout_request: UInt32;
  timeout_response: UInt32;
  do_read: Boolean;
  i: Integer;
  data_pointer: PByte;

  dummy: char;

begin
  try
    // Initialize variables
    FillChar(msg_request, sizeof(msg_request), 0);
    FillChar(request_confirmation, sizeof(request_confirmation), 0);
    FillChar(response, sizeof(response), 0);
    buffer[0] := #0;

    // TODO: modify the value according to your available PCAN devices.
    tp_handle := cantp_handle.PCANTP_HANDLE_USBBUS1;

    // Print version informations
    status := TUDSApi.GetValue_2013(cantp_handle.PCANTP_HANDLE_NONEBUS,
      uds_parameter.PUDS_PARAMETER_API_VERSION, buffer, 256);
    Writeln(Format('PCAN-UDS API Version - %s: %s',
      [buffer, STATUS_OK_KO(status)]));

    // Initialize channel
    status := TUDSApi.Initialize_2013(tp_handle,
      cantp_baudrate.PCANTP_BAUDRATE_500K);
    Writeln(Format('Initialize channel: %s', [STATUS_OK_KO(status)]));

    // Get timeout values
    status := TUDSApi.GetValue_2013(tp_handle,
      uds_parameter.PUDS_PARAMETER_TIMEOUT_REQUEST, PLongWord(@timeout_request),
      sizeof(UInt32));
    Writeln(Format('Get request timeout value (%dms): %s',
      [timeout_request, STATUS_OK_KO(status)]));
    status := TUDSApi.GetValue_2013(tp_handle,
      uds_parameter.PUDS_PARAMETER_TIMEOUT_RESPONSE,
      PLongWord(@timeout_response), sizeof(UInt32));
    Writeln(Format('Get response timeout value (%dms): %s',
      [timeout_response, STATUS_OK_KO(status)]));

    // Add filter on 0x123 and 0x124 can id
    status := TUDSApi.AddCanIdFilter_2013(tp_handle, $123);
    Writeln(Format('Add can id filter (0x123): %s', [STATUS_OK_KO(status)]));
    status := TUDSApi.AddCanIdFilter_2013(tp_handle, $124);
    Writeln(Format('Add can id filter (0x124): %s', [STATUS_OK_KO(status)]));

    // Initialize the request configuration: UUDT message using 0x123 can id.
    FillChar(config_physical, sizeof(config_physical), 0);
    config_physical.can_id := $123;
    config_physical.can_msgtype :=
      cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD;
    config_physical.nai.protocol :=
      uds_msgprotocol.PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL;
    config_physical.nai.target_type :=
      cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL;
    config_physical.typem := uds_msgtype.PUDS_MSGTYPE_UUDT;

    // Execute ECUReset
    status := TUDSApi.SvcECUReset_2013(tp_handle, config_physical, msg_request,
      uds_svc_param_er.PUDS_SVC_PARAM_ER_HR);
    Writeln(Format('Execute ECUReset service: %s', [STATUS_OK_KO(status)]));

    // Wait request confirmation (loopback)
    status := TUDSApi.WaitForSingleMessage_2013(tp_handle, @msg_request, true,
      timeout_request, TUDSApi.PUDS_P2CAN_ENHANCED_SERVER_MAX_DEFAULT,
      request_confirmation);
    Writeln(Format('Wait request confirmation: %s', [STATUS_OK_KO(status)]));

    // Read the first available UUDT message (server should reply with can id 0x124)
    do_read := True;
    While do_read do
    begin
      status := TUDSApi.Read_2013(tp_handle, response);
      do_read := TUDSApi.StatusIsOk_2013(status, PUDS_STATUS_NO_MESSAGE, false);
    end;

    If (TUDSApi.StatusIsOk_2013(status, PUDS_STATUS_OK, false)) Then
    begin
      Write(Format('Read response can ID=0x%.4x [', [response.msg.can_info.can_id]));

      data_pointer := PByte(response.msg.msgdata_isotp.data);
      For i := 0 To response.msg.msgdata_any.length - 1 do
      begin
        Write(Format(' 0x%.2x', [data_pointer^]));
        inc(data_pointer)
      end;
      Writeln(' ]');
    end
    Else
      Writeln('Failed to read message: %s', STATUS_OK_KO(status));

    // Free message structures
    status := TUDSApi.MsgFree_2013(&msg_request);
    Writeln(Format('Free request message: %s', [STATUS_OK_KO(status)]));
    status := TUDSApi.MsgFree_2013(&request_confirmation);
    Writeln(Format('Free request confirmation: %s', [STATUS_OK_KO(status)]));
    status := TUDSApi.MsgFree_2013(&response);
    Writeln(Format('Free response message: %s', [STATUS_OK_KO(status)]));

    // Close client
    status := TUDSApi.Uninitialize_2013(tp_handle);
    Writeln(Format('Uninitialize channel: %s', [STATUS_OK_KO(status)]));

    // Exit
    Writeln('Press any key to continue...');
    Readln(dummy);

  except
    on E: Exception do
      Writeln(E.Classname, ': ', E.Message);
  end;

end.
