from PCAN_UDS_2013 import *

# Support keyboard
def getInput():
	sys.stdin.read(1)

# UDS library
objPCANUds = PCAN_UDS_2013()

# Help functions
def OK_KO(test):
	return "OK" if test else "KO"

def STATUS_OK_KO(test):
	return OK_KO(objPCANUds.StatusIsOk_2013(test, PUDS_STATUS_OK, False))

def is_same_uds_sessioninfo(session_1, session_2):
	"""
	Helper: check is two UDS session info structure are the same
		session_1: Session to compare
		session_2: Session to compare
	returns : Same session info (True) or not (False)
	"""
	res = False
	if session_1.nai.protocol == session_2.nai.protocol\
		and session_1.nai.target_type == session_2.nai.target_type\
		and session_1.nai.source_addr == session_2.nai.source_addr\
		and session_1.nai.target_addr == session_2.nai.target_addr\
		and session_1.nai.extension_addr == session_2.nai.extension_addr\
		and session_1.can_msg_type == session_2.can_msg_type\
		and session_1.session_type == session_2.session_type\
		and session_1.timeout_p2can_server_max == session_2.timeout_p2can_server_max\
		and session_1.timeout_enhanced_p2can_server_max == session_2.timeout_enhanced_p2can_server_max\
		and session_1.s3_client_ms == session_2.s3_client_ms:
		res = True
	return res

# Definitions
BUFFER_SIZE = 256
FORCE_CUSTOM_SESSION = 1

#
# Main entry point of the program, start a UDS channel, ask ECureset service and set new session info
#

# Initialize variables
tp_handle = PCANTP_HANDLE_USBBUS1 # TODO : modify the value according to your available PCAN devices.


# Print version informations
buffer = create_string_buffer(BUFFER_SIZE)
status = objPCANUds.GetValue_2013(PCANTP_HANDLE_NONEBUS, PUDS_PARAMETER_API_VERSION, buffer, BUFFER_SIZE)
print("PCAN-UDS API Version - %s: %s" %( buffer.value, STATUS_OK_KO(status)))

# Initialize client
status = objPCANUds.Initialize_2013(tp_handle, PCANTP_BAUDRATE_500K, 0, 0, 0)
print("Initialize channel: %s" %( STATUS_OK_KO(status)))

# Initialize a physical configuration
config_physical = uds_msgconfig()
config_physical.can_id = -1
config_physical.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD
config_physical.nai.protocol = PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL
config_physical.nai.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL
config_physical.type = PUDS_MSGTYPE_USDT
config_physical.nai.source_addr = PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT
config_physical.nai.target_addr = PUDS_ISO_15765_4_ADDR_ECU_1
config_physical.nai.extension_addr = 0

# Execute ECUReset and wait response
msg_request = uds_msg()
response = uds_msg()
request_confirmation = uds_msg()
status = objPCANUds.SvcECUReset_2013(tp_handle, config_physical, msg_request, objPCANUds.PUDS_SVC_PARAM_ER_HR)
print("Execute ECUReset service: %s" %( STATUS_OK_KO(status)))
status = objPCANUds.WaitForService_2013(tp_handle, msg_request, response, request_confirmation)
print("Wait for service: %s" %( STATUS_OK_KO(status)))

if FORCE_CUSTOM_SESSION :
	# Some custom ECU may be in a non default session after reset
	# to inform the UDS API, it is possible to override the current session information:

	# Initialize new session info
	new_sessioninfo = uds_sessioninfo()
	new_sessioninfo.can_msg_type = PCANTP_CAN_MSGTYPE_STANDARD
	new_sessioninfo.session_type = 0x05
	new_sessioninfo.timeout_p2can_server_max = 1
	new_sessioninfo.timeout_enhanced_p2can_server_max = 2
	new_sessioninfo.s3_client_ms = 8
	new_sessioninfo.nai = config_physical.nai

	# Set new session info
	status = objPCANUds.SetValue_2013(tp_handle, PUDS_PARAMETER_SESSION_INFO, new_sessioninfo, sizeof(uds_sessioninfo))
	print("Set new session info: %s" %( STATUS_OK_KO(status)))

	# Get session info parameter and check if the new value is added
	read_sessioninfo = uds_sessioninfo()
	read_sessioninfo.nai = config_physical.nai
	status = objPCANUds.GetValue_2013(tp_handle, PUDS_PARAMETER_SESSION_INFO, read_sessioninfo, sizeof(uds_sessioninfo))
	print("Get session info: %s" %( STATUS_OK_KO(status)))
	print("Check added session info: %s" %( OK_KO(is_same_uds_sessioninfo(read_sessioninfo, new_sessioninfo) == True)))

# Free message structures
objPCANUds.MsgFree_2013(msg_request)
print("Free request message: %s" %(STATUS_OK_KO(status)))
objPCANUds.MsgFree_2013(request_confirmation)
print("Free request confirmation: %s" %(STATUS_OK_KO(status)))
objPCANUds.MsgFree_2013(response)
print("Free response message: %s" %(STATUS_OK_KO(status)))

# Close client
status = objPCANUds.Uninitialize_2013(tp_handle)
print("Uninitialize channel: %s" %( STATUS_OK_KO(status)))

# Exit
print("Press any key to continue...")
getInput()



