from PCAN_UDS_2013 import *

# Support keyboard
def getInput():
	sys.stdin.read(1)

# UDS library
objPCANUds = PCAN_UDS_2013()

# Help functions
def OK_KO(test):
	return "OK" if test else "KO"

def STATUS_OK_KO(test):
	return OK_KO(objPCANUds.StatusIsOk_2013(test, PUDS_STATUS_OK, False))

# Definitions
BUFFER_SIZE = 256

#
# Main entry point of the program, start a UDS channel, ask ECureset service in UUDT mode (using 0x123 and 0x124 can id)
#

# Initialize variables
tp_handle = PCANTP_HANDLE_USBBUS1 # TODO : modify the value according to your available PCAN devices.

# Print version informations
buffer = create_string_buffer(BUFFER_SIZE)
status = objPCANUds.GetValue_2013(PCANTP_HANDLE_NONEBUS, PUDS_PARAMETER_API_VERSION, buffer, BUFFER_SIZE)
print("PCAN-UDS API Version - %s: %s" %( buffer.value, STATUS_OK_KO(status)))

# Initialize channel
status = objPCANUds.Initialize_2013(tp_handle, PCANTP_BAUDRATE_500K, 0, 0, 0)
print("Initialize channel: %s" %(STATUS_OK_KO(status)))

# Get timeout values
timeout_request = c_uint32(0)
status = objPCANUds.GetValue_2013(tp_handle, PUDS_PARAMETER_TIMEOUT_REQUEST, timeout_request, sizeof(timeout_request))
print("Get request timeout value (%ums): %s" %(timeout_request.value, STATUS_OK_KO(status)))
timeout_response = c_uint32(0)
status = objPCANUds.GetValue_2013(tp_handle, PUDS_PARAMETER_TIMEOUT_RESPONSE, timeout_response, sizeof(timeout_response))
print("Get response timeout value (%ums): %s" %(timeout_response.value, STATUS_OK_KO(status)))

# Add filter on 0x123 and 0x124 can id
status = objPCANUds.AddCanIdFilter_2013(tp_handle, 0x123)
print("Add can id filter (0x123): %s" %(STATUS_OK_KO(status)))
status = objPCANUds.AddCanIdFilter_2013(tp_handle, 0x124)
print("Add can id filter (0x124): %s" %(STATUS_OK_KO(status)))

# Initialize the request configuration: UUDT message using 0x123 can id.
config_physical = uds_msgconfig()
config_physical.can_id = 0x123
config_physical.can_msgtype = PCANTP_CAN_MSGTYPE_STANDARD
config_physical.nai.protocol = PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL
config_physical.nai.target_type = PCANTP_ISOTP_ADDRESSING_PHYSICAL
config_physical.type = PUDS_MSGTYPE_UUDT

# Execute ECUReset
msg_request = uds_msg()
response = uds_msg()
request_confirmation = uds_msg()
status = objPCANUds.SvcECUReset_2013(tp_handle, config_physical, msg_request, objPCANUds.PUDS_SVC_PARAM_ER_HR)
print("Execute ECUReset service: %s" %(STATUS_OK_KO(status)))

# Wait request confirmation (loopback)
status = objPCANUds.WaitForSingleMessage_2013(tp_handle, msg_request, True, timeout_request, PUDS_P2CAN_ENHANCED_SERVER_MAX_DEFAULT, request_confirmation)
print("Wait request confirmation: %s" %(STATUS_OK_KO(status)))

# Read the first available UUDT message (server should reply with can id 0x124)
do_read = True
while do_read:
	status = objPCANUds.Read_2013(tp_handle, response, None, None)
	do_read = objPCANUds.StatusIsOk_2013(status, PUDS_STATUS_NO_MESSAGE, False)


if objPCANUds.StatusIsOk_2013(status, PUDS_STATUS_OK, False):
	s = "Read response can ID=0x{x1} [".format(x1=format(response.msg.can_info.can_id, '04X'))
	for i in range(response.msg.msgdata.any.contents.length):
		s += " 0x{x1}".format(x1=format(response.msg.msgdata.any.contents.data[i], '02x'))
	s += (" ]")
	print(s)
else:
	print("Failed to read message: %s" %(STATUS_OK_KO(status)))


# Free message structures
status = objPCANUds.MsgFree_2013(msg_request)
print("Free request message: %s" %(STATUS_OK_KO(status)))
status = objPCANUds.MsgFree_2013(request_confirmation)
print("Free request confirmation: %s" %(STATUS_OK_KO(status)))
status = objPCANUds.MsgFree_2013(response)
print("Free response message: %s" %(STATUS_OK_KO(status)))

# Close client
status = objPCANUds.Uninitialize_2013(tp_handle)
print("Uninitialize channel: %s" %(STATUS_OK_KO(status)))

# Exit
print("Press any key to continue...")
getInput()



