﻿Imports System
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Threading

Imports Peak.Can.Basic
Imports Peak.Can.IsoTp
Imports Peak.Can.Uds


Module Module1
    Function OK_KO(ByVal test As Boolean) As String
        If test Then Return "OK"
        Return "KO"
    End Function

    Function STATUS_OK_KO(ByVal test As uds_status) As String
        Return OK_KO(UDSApi.StatusIsOk_2013(test))
    End Function



    ''' <summary>Entry point of the program, start a small server wich only support ECUReset service</summary>
    Sub Main(ByVal args As String())
        Dim status As uds_status
        Dim tp_handle As cantp_handle
        Dim server_address As UInt32
        Const BUFFER_SIZE As Integer = 256
        Dim buffer As StringBuilder = New StringBuilder(BUFFER_SIZE)
        Dim config_physical As uds_msgconfig = New uds_msgconfig()
        Dim stopit As Boolean
        Dim wait_result As Boolean
        Dim read_status As uds_status
        Dim request_msg As uds_msg = New uds_msg()
        Dim response_msg As uds_msg = New uds_msg()

        ' Initialize variables
        tp_handle = cantp_handle.PCANTP_HANDLE_USBBUS2 ' TODO: modify the value according to your available PCAN devices.
        server_address = CType(uds_address.PUDS_ADDRESS_ISO_15765_4_ADDR_ECU_1, UInt32)

        ' Print version informations
        status = UDSApi.GetValue_2013(cantp_handle.PCANTP_HANDLE_NONEBUS, uds_parameter.PUDS_PARAMETER_API_VERSION, buffer, BUFFER_SIZE)
        Console.WriteLine("PCAN-UDS API Version - {0}: {1}", buffer, STATUS_OK_KO(status))

        ' Initialize server
        status = UDSApi.Initialize_2013(tp_handle, cantp_baudrate.PCANTP_BAUDRATE_500K)
        Console.WriteLine("Initialize channel: {0}", STATUS_OK_KO(status))

        'Set server address parameter
        status = UDSApi.SetValue_2013(tp_handle, uds_parameter.PUDS_PARAMETER_SERVER_ADDRESS, server_address, CType(Marshal.SizeOf(server_address), UInt32))
        Console.WriteLine("Set server address: {0}", STATUS_OK_KO(status))

        ' Set a receive event
        Dim receive_event As Threading.AutoResetEvent = New Threading.AutoResetEvent(False)

        If IntPtr.Size = 4 Then
            Dim tmp_buffer As UInt32 = Convert.ToUInt32(receive_event.SafeWaitHandle.DangerousGetHandle().ToInt32())
            status = UDSApi.SetValue_2013(tp_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, tmp_buffer, CType(Marshal.SizeOf(tmp_buffer), UInt32))
        ElseIf IntPtr.Size = 8 Then
            Dim tmp_buffer As UInt64 = receive_event.SafeWaitHandle.DangerousGetHandle().ToInt64()
            Dim byte_array As Byte() = BitConverter.GetBytes(tmp_buffer)
            status = UDSApi.SetValue_2013(tp_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, byte_array, CType(Marshal.SizeOf(tmp_buffer), UInt64))
        End If

        Console.WriteLine("Set receive event parameter: {0}", STATUS_OK_KO(status))

        ' Initialize a physical configuration
        config_physical.can_id = &HFFFFFFFFUI
        config_physical.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD
        config_physical.nai.protocol = uds_msgprotocol.PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL
        config_physical.nai.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL
        config_physical.type = uds_msgtype.PUDS_MSGTYPE_USDT
        config_physical.nai.extension_addr = 0

        ' Read while user do not press Q
        Console.WriteLine("Start listening, press Q to quit.")
        stopit = False

        Do

            ' Wait a receive event on receiver
            '	note: timeout is used to check keyboard hit.
            wait_result = receive_event.WaitOne(1000)


            ' If we get a receive event
            If wait_result Then

                Do

                    ' Read first available message (no filtering based on message's type is set):
                    read_status = UDSApi.Read_2013(tp_handle, request_msg)
                    Console.WriteLine("Try to read a message: {0}", STATUS_OK_KO(read_status))

                    If UDSApi.StatusIsOk_2013(read_status) Then
                        Dim req_any As cantp_msgdata = New cantp_msgdata()
                        If request_msg.msg.Msgdata <> IntPtr.Zero Then req_any = request_msg.msg.Msgdata_any_Copy


                        ' We receive a request, check its length and if it is not a loopback message
                        If (req_any.length >= 1) And ((req_any.flags And cantp_msgflag.PCANTP_MSGFLAG_LOOPBACK) = 0) Then
                            Dim req_srv_id As Byte
                            UDSApi.GetDataServiceId_2013(request_msg, req_srv_id)

                            ' This is a valid request, switch services
                            Select Case req_srv_id
                                Case CByte(uds_service.PUDS_SERVICE_SI_ECUReset)

                                    ' Allocate response message
                                    Dim param0 As Byte
                                    UDSApi.GetDataParameter_2013(request_msg, 0, param0)

                                    If param0 = CType(UDSApi.uds_svc_param_er.PUDS_SVC_PARAM_ER_ERPSD, Byte) Then
                                        status = UDSApi.MsgAlloc_2013(response_msg, config_physical, 3)
                                        UDSApi.SetDataParameter_2013(response_msg, 1, &H66) ' Power down time
                                    Else
                                        status = UDSApi.MsgAlloc_2013(response_msg, config_physical, 2)
                                    End If

                                    Console.WriteLine("Prepare response message for ECUReset service: {0}", STATUS_OK_KO(status))

                                    If UDSApi.StatusIsOk_2013(status) Then
                                        ' Fill parameters
                                        Dim net_addr_info As cantp_netaddrinfo = request_msg.msg.Msgdata_isotp_Copy.netaddrinfo
                                        net_addr_info.target_addr = net_addr_info.source_addr
                                        net_addr_info.source_addr = server_address
                                        CanTpApi.setNetaddrinfo_2016(response_msg.msg, net_addr_info)
                                        UDSApi.SetDataServiceId_2013(response_msg, CType(uds_service.PUDS_SERVICE_SI_ECUReset, Byte) + UDSApi.PUDS_SI_POSITIVE_RESPONSE)
                                        UDSApi.SetDataParameter_2013(response_msg, 0, param0)

                                        ' Write response message
                                        status = UDSApi.Write_2013(tp_handle, response_msg)
                                        Console.WriteLine("Write response message for ECUReset service: {0}", STATUS_OK_KO(status))
                                    End If

                                    ' Free response message (and clean memory in order to reallocate later)
                                    status = UDSApi.MsgFree_2013(response_msg)
                                    Console.WriteLine("Free response message: {0}", STATUS_OK_KO(status))
                                Case Else
                                    Console.WriteLine("Unknown service (0x{0:X})", req_srv_id)
                            End Select
                        End If
                    End If


                    ' Free request message (and clean memory in order to reallocate later)
                    status = UDSApi.MsgFree_2013(request_msg)
                    Console.WriteLine("Free request message: {0}", STATUS_OK_KO(status))
                Loop While Not UDSApi.StatusIsOk_2013(read_status, uds_status.PUDS_STATUS_NO_MESSAGE)
            End If


            ' Quit when user press Q
            If Console.KeyAvailable Then
                Dim keyboard_res As Char = Console.ReadKey().KeyChar

                If keyboard_res = "Q"c OrElse keyboard_res = "q"c Then
                    stopit = True
                End If
            End If
        Loop While stopit = False


        ' Close receive event
        If IntPtr.Size = 4 Then
            Dim tmp_buffer As UInt32 = 0
            status = UDSApi.SetValue_2013(tp_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, tmp_buffer, CType(Marshal.SizeOf(tmp_buffer), UInt32))
        ElseIf IntPtr.Size = 8 Then
            Dim tmp_buffer As UInt64 = 0
            Dim byte_array As Byte() = BitConverter.GetBytes(tmp_buffer)
            status = UDSApi.SetValue_2013(tp_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, byte_array, CType(Marshal.SizeOf(tmp_buffer), UInt64))
        End If

        Console.WriteLine("Stop receive event: {0}", STATUS_OK_KO(status))
        receive_event.Close()
        Console.WriteLine("Close receive event: {0}", STATUS_OK_KO(status))

        ' Close server
        status = UDSApi.Uninitialize_2013(tp_handle)
        Console.WriteLine("Uninitialize channel: {0}", STATUS_OK_KO(status))

        ' Exit
        Console.WriteLine("Press any key to continue...")
        Console.In.Read()
    End Sub

End Module
