﻿Imports System
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Threading

Imports Peak.Can.Basic
Imports Peak.Can.IsoTp
Imports Peak.Can.Uds


Module Module1
    Dim FORCE_CUSTOM_SESSION As Boolean = True

    Function OK_KO(ByVal test As Boolean) As String
        If test Then Return "OK"
        Return "KO"
    End Function

    Function STATUS_OK_KO(ByVal test As uds_status) As String
        Return OK_KO(UDSApi.StatusIsOk_2013(test))
    End Function

    ''' <summary>Helper: check if two UDS session info structure are the same</summary>
    ''' <param name="session_1">Session to compare</param>
    ''' <param name="session_2">Session to compare</param>
    ''' <returns>Same session info (true) or not (false)</returns>
    Function is_same_uds_sessioninfo(ByRef session_1 As uds_sessioninfo, ByRef session_2 As uds_sessioninfo) As Boolean
        Dim res As Boolean = False
        If (session_1.nai.protocol = session_2.nai.protocol) And (session_1.nai.target_type = session_2.nai.target_type) _
                And (session_1.nai.source_addr = session_2.nai.source_addr) _
                And (session_1.nai.target_addr = session_2.nai.target_addr) _
                And (session_1.nai.extension_addr = session_2.nai.extension_addr) _
                And (session_1.can_msg_type = session_2.can_msg_type) _
                And (session_1.session_type = session_2.session_type) _
                And (session_1.timeout_p2can_server_max = session_2.timeout_p2can_server_max) _
                And (session_1.timeout_enhanced_p2can_server_max = session_2.timeout_enhanced_p2can_server_max) _
                And (session_1.s3_client_ms = session_2.s3_client_ms) Then

            res = True
        End If
        Return res
    End Function

    ''' <summary>Entry point of the program, start a UDS channel, ask ECureset service and set new session info</summary>
    Sub Main(ByVal args As String())
        Const BUFFER_SIZE As Integer = 256
        Dim buffer As StringBuilder = New StringBuilder(BUFFER_SIZE)
        Dim status As uds_status
        Dim tp_handle As cantp_handle
        Dim config_physical As uds_msgconfig = New uds_msgconfig()
        Dim msg_request As uds_msg  = New uds_msg()
        Dim request_confirmation As uds_msg = New uds_msg()
        Dim response As uds_msg = New uds_msg()
        Dim new_sessioninfo As uds_sessioninfo = New uds_sessioninfo()
        Dim read_sessioninfo As uds_sessioninfo = New uds_sessioninfo()

        ' Initialize variables
        tp_handle = cantp_handle.PCANTP_HANDLE_USBBUS1 ' TODO: modify the value according to your available PCAN devices.

        ' Print version informations
        status = UDSApi.GetValue_2013(cantp_handle.PCANTP_HANDLE_NONEBUS, uds_parameter.PUDS_PARAMETER_API_VERSION, buffer, BUFFER_SIZE)
        Console.WriteLine("PCAN-UDS API Version - {0}: {1}", buffer, STATUS_OK_KO(status))

        ' Initialize client
        status = UDSApi.Initialize_2013(tp_handle, cantp_baudrate.PCANTP_BAUDRATE_500K)
        Console.WriteLine("Initialize channel: {0}", STATUS_OK_KO(status))

        ' Initialize a physical configuration
        config_physical.can_id = CType(uds_can_id.PUDS_CAN_ID_ISO_15765_4_PHYSICAL_REQUEST_1, UInteger)
        config_physical.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD
        config_physical.nai.protocol = uds_msgprotocol.PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL
        config_physical.nai.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL
        config_physical.type = uds_msgtype.PUDS_MSGTYPE_USDT
        config_physical.nai.source_addr = CType(uds_address.PUDS_ADDRESS_ISO_15765_4_ADDR_TEST_EQUIPMENT, UShort)
        config_physical.nai.target_addr = CType(uds_address.PUDS_ADDRESS_ISO_15765_4_ADDR_ECU_1, UShort)
        config_physical.nai.extension_addr = 0

        ' Execute ECUReset and wait response
        status = UDSApi.SvcECUReset_2013(tp_handle, config_physical, msg_request, UDSApi.uds_svc_param_er.PUDS_SVC_PARAM_ER_HR)
        Console.WriteLine("Execute ECUReset service: {0}", STATUS_OK_KO(status))
        status = UDSApi.WaitForService_2013(tp_handle, msg_request, response, request_confirmation)
        Console.WriteLine("Wait for service: {0}", STATUS_OK_KO(status))

        If FORCE_CUSTOM_SESSION Then
            ' Some custom ECU may be in a non default session after reset
            ' to inform the UDS API, it is possible to override the current session information:

            ' Initialize new session info
            new_sessioninfo.can_msg_type = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD
            new_sessioninfo.session_type = &H5
            new_sessioninfo.timeout_p2can_server_max = 1
            new_sessioninfo.timeout_enhanced_p2can_server_max = 2
            new_sessioninfo.s3_client_ms = 8
            new_sessioninfo.nai = config_physical.nai

            ' Set new session info
            Dim session_size As Integer = Marshal.SizeOf(new_sessioninfo)
            Dim session_ptr As IntPtr = Marshal.AllocHGlobal(session_size)
            Marshal.StructureToPtr(new_sessioninfo, session_ptr, False)
            status = UDSApi.SetValue_2013(tp_handle, uds_parameter.PUDS_PARAMETER_SESSION_INFO, session_ptr, CType(session_size, UInt32))
            Console.WriteLine("Set new session info: {0}", STATUS_OK_KO(status))
            Marshal.FreeHGlobal(session_ptr)

            ' Get session info parameter and check if the new value is added
            read_sessioninfo = New uds_sessioninfo()
            read_sessioninfo.nai = config_physical.nai
            status = UDSApi.GetSessionInformation_2013(tp_handle, read_sessioninfo)
            Console.WriteLine("Get session info: {0}", STATUS_OK_KO(status))
            Console.WriteLine("Check added session info: {0}", OK_KO(is_same_uds_sessioninfo(read_sessioninfo, new_sessioninfo)))
        End If

        ' Free message structures
        status = UDSApi.MsgFree_2013(msg_request)
        Console.WriteLine("Free request message: {0}", STATUS_OK_KO(status))
        status = UDSApi.MsgFree_2013(request_confirmation)
        Console.WriteLine("Free request confirmation: {0}", STATUS_OK_KO(status))
        status = UDSApi.MsgFree_2013(response)
        Console.WriteLine("Free response message: {0}", STATUS_OK_KO(status))

        ' Close client
        status = UDSApi.Uninitialize_2013(tp_handle)
        Console.WriteLine("Uninitialize channel: {0}", STATUS_OK_KO(status))

        ' Exit
        Console.WriteLine("Press any key to continue...")
        Console.In.Read()
    End Sub
End Module
