﻿
Imports System
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Threading

Imports Peak.Can.Basic
Imports Peak.Can.IsoTp
Imports Peak.Can.Uds

Module Module1

    Function OK_KO(ByVal test As Boolean) As String
        If test Then Return "OK"
        Return "KO"
    End Function

    Function STATUS_OK_KO(ByVal test As uds_status) As String
        Return OK_KO(UDSApi.StatusIsOk_2013(test))
    End Function


    ''' <summary>Entry point of the program, start a UDS channel, ask ECureset service in UUDT mode (using 0x123 and 0x124 can id)</summary>
    Sub Main(ByVal args As String())
        Const BUFFER_SIZE As Integer = 256
        Dim buffer As StringBuilder = New StringBuilder(BUFFER_SIZE)
        Dim status As uds_status
        Dim tp_handle As cantp_handle
        Dim config_physical As uds_msgconfig = New uds_msgconfig()
        Dim msg_request As uds_msg = New uds_msg()
        Dim request_confirmation As uds_msg = New uds_msg()
        Dim response As uds_msg = New uds_msg()
        Dim timeout_request As UInteger
        Dim timeout_response As UInteger
        Dim do_read As Boolean

        ' Initialize variables
        tp_handle = cantp_handle.PCANTP_HANDLE_USBBUS1 ' TODO: modify the value according to your available PCAN devices.

        ' Print version informations
        status = UDSApi.GetValue_2013(cantp_handle.PCANTP_HANDLE_NONEBUS, uds_parameter.PUDS_PARAMETER_API_VERSION, buffer, BUFFER_SIZE)
        Console.WriteLine("PCAN-UDS API Version - {0}: {1}", buffer, STATUS_OK_KO(status))

        ' Initialize channel
        status = UDSApi.Initialize_2013(tp_handle, cantp_baudrate.PCANTP_BAUDRATE_500K)
        Console.WriteLine("Initialize channel: {0}", STATUS_OK_KO(status))
        'Get timeout values
        status = UDSApi.GetValue_2013(tp_handle, uds_parameter.PUDS_PARAMETER_TIMEOUT_REQUEST, timeout_request, CType(Marshal.SizeOf(timeout_request), UInt32))
        Console.WriteLine("Get request timeout value ({0}ms): {1}", timeout_request, STATUS_OK_KO(status))
        status = UDSApi.GetValue_2013(tp_handle, uds_parameter.PUDS_PARAMETER_TIMEOUT_RESPONSE, timeout_response, CType(Marshal.SizeOf(timeout_response), UInt32))
        Console.WriteLine("Get response timeout value ({0}ms): {1}", timeout_response, STATUS_OK_KO(status))

        ' Add filter on 0x123 and 0x124 can id
        status = UDSApi.AddCanIdFilter_2013(tp_handle, &H123)
        Console.WriteLine("Add can id filter (0x123): {0}", STATUS_OK_KO(status))
        status = UDSApi.AddCanIdFilter_2013(tp_handle, &H124)
        Console.WriteLine("Add can id filter (0x124): {0}", STATUS_OK_KO(status))

        ' Initialize the request configuration: UUDT message using 0x123 can id.
        config_physical.can_id = &H123
        config_physical.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD
        config_physical.nai.protocol = uds_msgprotocol.PUDS_MSGPROTOCOL_ISO_15765_2_11B_NORMAL
        config_physical.nai.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL
        config_physical.type = uds_msgtype.PUDS_MSGTYPE_UUDT

        ' Execute ECUReset
        status = UDSApi.SvcECUReset_2013(tp_handle, config_physical, msg_request, UDSApi.uds_svc_param_er.PUDS_SVC_PARAM_ER_HR)
        Console.WriteLine("Execute ECUReset service: {0}", STATUS_OK_KO(status))

        ' Wait request confirmation (loopback)
        status = UDSApi.WaitForSingleMessage_2013(tp_handle, msg_request, True, timeout_request, UDSApi.PUDS_P2CAN_ENHANCED_SERVER_MAX_DEFAULT, request_confirmation)
        Console.WriteLine("Wait request confirmation: {0}", STATUS_OK_KO(status))

        ' Read the first available UUDT message (server should reply with can id 0x124)
        Do
            status = UDSApi.Read_2013(tp_handle, response)
            do_read = UDSApi.StatusIsOk_2013(status, uds_status.PUDS_STATUS_NO_MESSAGE, False)
        Loop While (do_read)

        If (UDSApi.StatusIsOk_2013(status, uds_status.PUDS_STATUS_OK, False)) Then
            Dim Val As Byte
            Console.Write("Read response can ID=0x{0:X4} [", response.msg.can_info.can_id)
            For i As Integer = 0 To response.msg.Msgdata_any_Copy.length - 1
                CanTpApi.getData_2016(response.msg, i, Val)
                Console.Write(" 0x{0:X2}", Val)
            Next i
            Console.WriteLine(" ]")

        Else
            Console.WriteLine("Failed to read message: {0}", STATUS_OK_KO(status))
        End If

        ' Free message structures
        status = UDSApi.MsgFree_2013(msg_request)
        Console.WriteLine("Free request message: {0}", STATUS_OK_KO(status))
        status = UDSApi.MsgFree_2013(request_confirmation)
        Console.WriteLine("Free request confirmation: {0}", STATUS_OK_KO(status))
        status = UDSApi.MsgFree_2013(response)
        Console.WriteLine("Free response message: {0}", STATUS_OK_KO(status))

        ' Close client
        status = UDSApi.Uninitialize_2013(tp_handle)
        Console.WriteLine("Uninitialize channel: {0}", STATUS_OK_KO(status))

        ' Exit
        Console.WriteLine("Press any key to continue...")
        Console.In.Read()
    End Sub

End Module
