﻿Imports System
Imports System.Runtime.InteropServices
Imports System.Threading
Imports System.Text

Imports Peak.Can.Basic
Imports Peak.Can.IsoTp
Imports Peak.Can.Uds
Imports cantp_timestamp = System.UInt64


Module Module1
    ' Define Bitrate: SAE J2284-4: High-Speed CAN (HSC) for Vehicle Applications at 500 kbps with CAN FD Data at 2 Mbps
    Const PCAN_BITRATE_SAE_J2284_4 As String = "f_clock=80000000,nom_brp=2,nom_tseg1=63,nom_tseg2=16,nom_sjw=16,data_brp=2,data_tseg1=15,data_tseg2=4,data_sjw=4"

    ''' <summary>
    ''' Entry point of the program, start a small CAN UDS / ISOTP read-write example
    ''' This example initialise two UDS channel with a specific mapping.
    ''' Then it inits an ISOTP mapping and write an ISOTP message.
    ''' In this case, PCAN-UDS should not receive the message, we need PCAN-ISOTP to read it.
    ''' </summary>
    ''' <returns>By convention, return success.</returns>
    Function Main(ByVal args As String()) As Integer
        Const BUFFER_SIZE As Integer = 256
        Const MSG As String = "PEAK"
        Const MSG_SIZE As UInt32 = 4
        Dim Buffer As StringBuilder = New StringBuilder(BUFFER_SIZE)
        Dim status As Integer
        Dim transmitter_handle As cantp_handle
        Dim receiver_handle As cantp_handle
        Dim tx_msg As cantp_msg = New cantp_msg()
        Dim uds_rx_msg As uds_msg = New uds_msg()
        Dim rx_msg As cantp_msg = New cantp_msg()
        Dim source_mapping As uds_mapping = New uds_mapping()
        Dim mapping As cantp_mapping = New cantp_mapping()
        Dim reverse_mapping As cantp_mapping = New cantp_mapping()
        Dim response_mapping As uds_mapping = New uds_mapping()
        Dim timestamp_buffer As cantp_timestamp = New cantp_timestamp()
        Dim wait_result As Boolean
        Dim can_msgtype As cantp_can_msgtype

        ' Initialize variables
        transmitter_handle = cantp_handle.PCANTP_HANDLE_USBBUS1 ' TODO: modify the value according to your available PCAN devices.
        receiver_handle = cantp_handle.PCANTP_HANDLE_USBBUS2 ' TODO: modify the value according to your available PCAN devices.
        can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_STANDARD
        ' To use CAN FD with bitrate switch uncomment:
        ' can_msgtype = can_msgtype Or cantp_can_msgtype.PCANTP_CAN_MSGTYPE_FD Or cantp_can_msgtype.PCANTP_CAN_MSGTYPE_BRS

        ' Print version informations
        status = CInt(UDSApi.GetValue_2013(cantp_handle.PCANTP_HANDLE_NONEBUS, uds_parameter.PUDS_PARAMETER_API_VERSION, Buffer, BUFFER_SIZE))
        Console.WriteLine("PCAN-UDS API Version: {0} ({1})", Buffer, STATUS_OK_KO(status))

        ' Initialize transmitter and receiver
        status = CInt(UDSApi.InitializeFD_2013(transmitter_handle, PCAN_BITRATE_SAE_J2284_4))
        Console.WriteLine("Initialize transmitter: {0}", STATUS_OK_KO(status))
        status = CInt(UDSApi.InitializeFD_2013(receiver_handle, PCAN_BITRATE_SAE_J2284_4))
        Console.WriteLine("Initialize receiver: {0}", STATUS_OK_KO(status))

        ' Create a receive event on receiver
        Dim receive_event As System.Threading.AutoResetEvent = New System.Threading.AutoResetEvent(False)
        If (IntPtr.Size = 4) Then
            Dim tmp_buffer As UInt32 = Convert.ToUInt32(receive_event.SafeWaitHandle.DangerousGetHandle().ToInt32())
            status = CInt(UDSApi.SetValue_2013(receiver_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, tmp_buffer, CType(System.Runtime.InteropServices.Marshal.SizeOf(tmp_buffer), UInt32)))
        ElseIf (IntPtr.Size = 8) Then
            Dim tmp_buffer As Int64 = receive_event.SafeWaitHandle.DangerousGetHandle().ToInt64()
            Dim reveice_event_byte_array As Byte() = BitConverter.GetBytes(tmp_buffer)
            status = CInt(UDSApi.SetValue_2013(receiver_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, reveice_event_byte_array, CType(System.Runtime.InteropServices.Marshal.SizeOf(tmp_buffer), UInt64)))
        End If
        Console.WriteLine("Set receive event parameter: {0}", STATUS_OK_KO(status))

        ' Initialize source mapping
        source_mapping.can_id = &H30
        source_mapping.can_id_flow_ctrl = source_mapping.can_id + 1
        source_mapping.can_msgtype = can_msgtype
        source_mapping.can_tx_dlc = 8
        source_mapping.nai.protocol = uds_msgprotocol.PUDS_MSGPROTOCOL_ISO_15765_2_29B_NORMAL
        source_mapping.nai.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL
        source_mapping.nai.source_addr = &H10
        source_mapping.nai.target_addr = &H20

        ' Initialize response mapping
        response_mapping = source_mapping
        response_mapping.can_id = source_mapping.can_id_flow_ctrl
        response_mapping.can_id_flow_ctrl = source_mapping.can_id
        response_mapping.nai.source_addr = source_mapping.nai.target_addr
        response_mapping.nai.target_addr = source_mapping.nai.source_addr

        ' Add UDS mappings on transmitter
        status = CInt(UDSApi.AddMapping_2013(transmitter_handle, source_mapping))
        Console.WriteLine("Add source mapping on transmitter: {0}", STATUS_OK_KO(status))
        status = CInt(UDSApi.AddMapping_2013(transmitter_handle, response_mapping))
        Console.WriteLine("Add response mapping on transmitter: {0}", STATUS_OK_KO(status))

        ' Add UDS mappings on and receiver
        status = CInt(UDSApi.AddMapping_2013(receiver_handle, source_mapping))
        Console.WriteLine("Add source mapping on receiver: {0}", STATUS_OK_KO(status))
        status = CInt(UDSApi.AddMapping_2013(receiver_handle, response_mapping))
        Console.WriteLine("Add response mapping on receiver: {0}", STATUS_OK_KO(status))

        ' Create a simple isotp physical mapping:
        '    - Source 0xF1 (transmitter), target 0x01 (receiver), CAN id 0xA1, CAN ID flow control 0xA2
        '    - Diagnostic message in a classic format
        mapping.can_id = &HA1
        mapping.can_id_flow_ctrl = &HA2
        mapping.can_msgtype = can_msgtype
        mapping.can_tx_dlc = &H0
        mapping.netaddrinfo.extension_addr = &H0
        mapping.netaddrinfo.format = cantp_isotp_format.PCANTP_ISOTP_FORMAT_NORMAL
        mapping.netaddrinfo.msgtype = cantp_isotp_msgtype.PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC
        mapping.netaddrinfo.source_addr = &HF1
        mapping.netaddrinfo.target_addr = &H1
        mapping.netaddrinfo.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL

        ' Create the associated isotp reversed mapping:
        reverse_mapping = mapping
        reverse_mapping.can_id = mapping.can_id_flow_ctrl
        reverse_mapping.can_id_flow_ctrl = mapping.can_id
        reverse_mapping.netaddrinfo.source_addr = mapping.netaddrinfo.target_addr
        reverse_mapping.netaddrinfo.target_addr = mapping.netaddrinfo.source_addr

        ' Add ISOTP mappings on channels
        status = CInt(CanTpApi.AddMapping_2016(transmitter_handle, mapping))
        Console.WriteLine("Add a simple isotp mapping on transmitter: {0}", STATUS_OK_KO(status))
        status = CInt(CanTpApi.AddMapping_2016(transmitter_handle, reverse_mapping))
        Console.WriteLine("Add the reverse isotp mapping on transmitter: {0}", STATUS_OK_KO(status))
        status = CInt(CanTpApi.AddMapping_2016(receiver_handle, mapping))
        Console.WriteLine("Add a simple isotp mapping on receiver: {0}", STATUS_OK_KO(status))
        status = CInt(CanTpApi.AddMapping_2016(receiver_handle, reverse_mapping))
        Console.WriteLine("Add the reverse isotp mapping on receiver: {0}", STATUS_OK_KO(status))

        ' Initialize ISOTP Tx message containing "PEAK"
        status = CInt(CanTpApi.MsgDataAlloc_2016(tx_msg, cantp_msgtype.PCANTP_MSGTYPE_ISOTP))
        Console.WriteLine("Allocate tx ISOTP message: {0}", STATUS_OK_KO(status))
        Dim msg_array As Byte() = Encoding.ASCII.GetBytes(MSG)
        status = CInt(CanTpApi.MsgDataInit_2016(tx_msg, mapping.can_id, mapping.can_msgtype, MSG_SIZE, msg_array, mapping.netaddrinfo))
        Console.WriteLine("Initialize tx message: {0}", STATUS_OK_KO(status))

        ' Send "PEAK" ISOTP message
        status = CInt(CanTpApi.Write_2016(transmitter_handle, tx_msg))
        Console.WriteLine("Write ""PEAK"": {0}", STATUS_OK_KO(status))

        ' Wait a receive event on uds message (should not work because we sent a ISOTP message)
        wait_result = receive_event.WaitOne(3000)
        Console.WriteLine("Wait a receive event on UDS message (should not work because we sent an ISOTP message): {0}", OK_KO(wait_result))

        ' We should receive a ISOTP message instead
        status = CInt(CanTpApi.Read_2016(receiver_handle, rx_msg, timestamp_buffer, cantp_msgtype.PCANTP_MSGTYPE_NONE))
        Console.WriteLine("Read ISOTP message on receiver: {0}", STATUS_OK_KO(status))

        ' Check message (should contains "PEAK")
        Dim msgok As Boolean = False
        Dim rx_byte_array As Byte() = New Byte(MSG_SIZE - 1) {}
        If (UDSApi.StatusIsOk_2013(CType(status, uds_status)) And (rx_msg.Msgdata_any_Copy.length = MSG_SIZE)) Then
            msgok = CanTpApi.getData_2016(rx_msg, 0, rx_byte_array, MSG_SIZE)
            If msgok Then
                Dim i As Integer = 0
                While msgok AndAlso i < MSG_SIZE
                    If Chr(rx_byte_array(i)) = MSG(i) Then
                        msgok = True
                    Else
                        msgok = False
                    End If
                    i += 1
                End While
            End If
        End If
        If msgok Then
            Console.WriteLine("Message contains ""{0}{1}{2}{3}"": OK", Microsoft.VisualBasic.ChrW(rx_byte_array(0)), Microsoft.VisualBasic.ChrW(rx_byte_array(1)), Microsoft.VisualBasic.ChrW(rx_byte_array(2)), Microsoft.VisualBasic.ChrW(rx_byte_array(3)))
        Else
            Console.WriteLine("Message is corrupted: KO")
        End If

        ' Close receive event
        If IntPtr.Size = 4 Then
            Dim tmp_buffer As UInt32 = 0
            status = CInt(UDSApi.SetValue_2013(receiver_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, tmp_buffer, CType(System.Runtime.InteropServices.Marshal.SizeOf(tmp_buffer), UInt32)))
        ElseIf IntPtr.Size = 8 Then
            Dim tmp_buffer As Int64 = 0
            Dim byte_array As Byte() = BitConverter.GetBytes(tmp_buffer)
            status = CInt(UDSApi.SetValue_2013(receiver_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, byte_array, CType(System.Runtime.InteropServices.Marshal.SizeOf(tmp_buffer), UInt64)))
        End If
        Console.WriteLine("Stop receive event receiver: {0}", STATUS_OK_KO(status))
        receive_event.Close()
        Console.WriteLine("Close receive event: {0}", STATUS_OK_KO(status))

        ' Free messages
        status = CInt(CanTpApi.MsgDataFree_2016(tx_msg))
        Console.WriteLine("Free TX message: {0}", STATUS_OK_KO(status))
        status = CInt(CanTpApi.MsgDataFree_2016(rx_msg))
        Console.WriteLine("Free RX message: {0}", STATUS_OK_KO(status))
        status = CInt(UDSApi.MsgFree_2013(uds_rx_msg))
        Console.WriteLine("Free UDS/RX message: {0}", STATUS_OK_KO(status))

        ' Close transmitter and receiver
        status = CInt(UDSApi.Uninitialize_2013(transmitter_handle))
        Console.WriteLine("Uninitialize transmitter: {0}", STATUS_OK_KO(status))
        status = CInt(UDSApi.Uninitialize_2013(receiver_handle))
        Console.WriteLine("Uninitialize receiver: {0}", STATUS_OK_KO(status))

        ' Exit
        Console.WriteLine("Press any key to continue...")
        Console.In.Read()
        Return 0
    End Function

    Function OK_KO(ByVal test As Boolean) As String
        If test Then Return "OK"
        Return "KO"
    End Function

    Function STATUS_OK_KO(ByVal test As Integer) As String
        Return OK_KO(UDSApi.StatusIsOk_2013(CType(test, uds_status)))
    End Function
End Module
