﻿Imports System
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Threading

Imports Peak.Can.Basic
Imports Peak.Can.IsoTp
Imports Peak.Can.Uds


Module Module1

    Const PCAN_BITRATE As String = "f_clock=40000000,nom_brp=2,nom_tseg1=63,nom_tseg2=16,nom_sjw=16,data_brp=2,data_tseg1=7,data_tseg2=2,data_sjw=2"

    Function OK_KO(ByVal test As Boolean) As String
        If test Then Return "OK"
        Return "KO"
    End Function

    Function STATUS_OK_KO(ByVal test As uds_status) As String
        Return OK_KO(UDSApi.StatusIsOk_2013(test))
    End Function

    ''' <summary>
    '''  Entry point of the program, start a small server wich only support ReadDataByPeriodicIdentifier service.
    '''  This example use a specific addressing. It receives request from test equipement (0xF1 to 0xC1) in 29b fixed
    '''  normal addressing and sends responses for each periodic data identifier with 0x1F22C1F1 can identifier (UUDT).
    ''' </summary>
    ''' <returns>By convention, return success.</returns>
    Sub Main(ByVal args As String())
        Dim status As uds_status
        Dim server_handle As cantp_handle
        Dim server_address As UInt32
        Dim service_response_config As uds_msgconfig = New uds_msgconfig()
        Dim stopit As Boolean
        Dim wait_result As Boolean
        Dim read_status As uds_status
        Dim request_msg As uds_msg = New uds_msg()
        Dim service_response_msg As uds_msg = New uds_msg()
        Dim periodic_response As uds_msg
        Dim periodic_msg_config As uds_msgconfig = New uds_msgconfig()
        Dim padding_value As UInt32
        Dim can_tx_dl As UInt32
        Dim periodic_data_identifier As Byte
        Dim timeout_value As UInt32
        Dim periodic_data_identifier_length As UInt32
        Dim i As UInt32

        ' Initialize variables
        server_handle = cantp_handle.PCANTP_HANDLE_USBBUS2 ' TODO: modify the value according to your available PCAN devices.
        server_address = &HC1

        ' Initialize server
        status = UDSApi.InitializeFD_2013(server_handle, PCAN_BITRATE)
        Console.WriteLine("Initialize channel: {0}", STATUS_OK_KO(status))

        ' Set server address parameter
        status = UDSApi.SetValue_2013(server_handle, uds_parameter.PUDS_PARAMETER_SERVER_ADDRESS, server_address, CType(Marshal.SizeOf(server_address), UInt32))
        Console.WriteLine("Set server address: {0}", STATUS_OK_KO(status))

        ' Set a padding value
        padding_value = &HFF
        status = UDSApi.SetValue_2013(server_handle, uds_parameter.PUDS_PARAMETER_CAN_PADDING_VALUE, padding_value, CType(Marshal.SizeOf(padding_value), UInt32))
        Console.WriteLine("Set padding value: {0}", STATUS_OK_KO(status))

        ' Define CAN_TX_DL=15
        can_tx_dl = 15
        status = UDSApi.SetValue_2013(server_handle, uds_parameter.PUDS_PARAMETER_CAN_TX_DL, can_tx_dl, CType(Marshal.SizeOf(can_tx_dl), UInt32))
        Console.WriteLine("Set CAN TX DL: {0}", STATUS_OK_KO(status))

        ' Set UDS timeouts
        timeout_value = 5000
        status = UDSApi.SetValue_2013(server_handle, uds_parameter.PUDS_PARAMETER_TIMEOUT_REQUEST, timeout_value, CType(Marshal.SizeOf(timeout_value), UInt32))
        Console.WriteLine("Set request timeout(ms): {0}", STATUS_OK_KO(status))
        status = UDSApi.SetValue_2013(server_handle, uds_parameter.PUDS_PARAMETER_TIMEOUT_RESPONSE, timeout_value, CType(Marshal.SizeOf(timeout_value), UInt32))
        Console.WriteLine("Set response timeout(ms): {0}", STATUS_OK_KO(status))

        ' Set a receive event
        Dim receive_event As System.Threading.AutoResetEvent = New System.Threading.AutoResetEvent(False)
        If IntPtr.Size = 4 Then
            Dim tmp_buffer As UInt32 = Convert.ToUInt32(receive_event.SafeWaitHandle.DangerousGetHandle().ToInt32())
            status = UDSApi.SetValue_2013(server_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, tmp_buffer, CType(Marshal.SizeOf(tmp_buffer), UInt32))
        ElseIf IntPtr.Size = 8 Then
            Dim tmp_buffer As Int64 = receive_event.SafeWaitHandle.DangerousGetHandle().ToInt64()
            Dim byte_array As Byte() = BitConverter.GetBytes(tmp_buffer)
            status = UDSApi.SetValue_2013(server_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, byte_array, CType(Marshal.SizeOf(tmp_buffer), UInt32))
        End If
        Console.WriteLine("Set receive event parameter: {0}", STATUS_OK_KO(status))

        ' Initialize service response configuration
        service_response_config.can_id = &HFFFFFFFFUI
        service_response_config.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_EXTENDED Or cantp_can_msgtype.PCANTP_CAN_MSGTYPE_FD Or cantp_can_msgtype.PCANTP_CAN_MSGTYPE_BRS
        service_response_config.nai.protocol = uds_msgprotocol.PUDS_MSGPROTOCOL_ISO_15765_2_29B_FIXED_NORMAL
        service_response_config.nai.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL
        service_response_config.type = uds_msgtype.PUDS_MSGTYPE_USDT
        service_response_config.nai.source_addr = CType(server_address, UInt16)
        service_response_config.nai.target_addr = CType(uds_address.PUDS_ADDRESS_ISO_15765_4_ADDR_TEST_EQUIPMENT, UInt16)
        service_response_config.nai.extension_addr = 0

        ' Initialize responses configuration (for each periodic data identifier contained in the request)
        periodic_msg_config.can_id = &H1F22C1F1
        periodic_msg_config.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_EXTENDED Or cantp_can_msgtype.PCANTP_CAN_MSGTYPE_FD Or cantp_can_msgtype.PCANTP_CAN_MSGTYPE_BRS
        periodic_msg_config.nai.protocol = uds_msgprotocol.PUDS_MSGPROTOCOL_ISO_15765_2_29B_NORMAL
        periodic_msg_config.nai.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL
        periodic_msg_config.type = uds_msgtype.PUDS_MSGTYPE_UUDT
        periodic_msg_config.nai.source_addr = CType(server_address, UInt16)
        periodic_msg_config.nai.target_addr = CType(uds_address.PUDS_ADDRESS_ISO_15765_4_ADDR_TEST_EQUIPMENT, UInt16)
        periodic_msg_config.nai.extension_addr = 0

        ' Add a filter for 0x1F22C1F1 can id (in order to receive UUDT loopback messages)
        status = UDSApi.AddCanIdFilter_2013(server_handle, periodic_msg_config.can_id)
        Console.WriteLine("Add can identifier filter: {0}", STATUS_OK_KO(status))

        ' Read while user do not press Q
        Console.WriteLine("Start listening, press Q to quit.")
        stopit = False
        Do

            ' Wait a receive event on receiver
            '	note: timeout is used to check keyboard hit.
            wait_result = receive_event.WaitOne(1000)

            ' If we get a receive event
            If (wait_result) Then
                Do

                    ' Read first available message (no filtering based on message's type is set):
                    read_status = UDSApi.Read_2013(server_handle, request_msg)
                    Console.WriteLine("Try to read a message: {0}", STATUS_OK_KO(read_status))
                    If UDSApi.StatusIsOk_2013(read_status) Then

                        ' We receive a request, check its length and if it is not a loopback message
                        If (request_msg.msg.Msgdata_any_Copy.length >= 1 And (request_msg.msg.Msgdata_any_Copy.flags And cantp_msgflag.PCANTP_MSGFLAG_LOOPBACK) = 0) Then

                            Dim service_id As Byte
                            UDSApi.GetDataServiceId_2013(request_msg, service_id)

                            ' This is a valid request, switch services
                            Select Case service_id
                                Case CType(uds_service.PUDS_SERVICE_SI_ReadDataByPeriodicIdentifier, Byte)

                                    ' Allocates service response message
                                    status = UDSApi.MsgAlloc_2013(service_response_msg, service_response_config, 1)
                                    If (UDSApi.StatusIsOk_2013(status)) Then
                                        UDSApi.SetDataServiceId_2013(service_response_msg, CType(uds_service.PUDS_SERVICE_SI_ReadDataByPeriodicIdentifier + UDSApi.PUDS_SI_POSITIVE_RESPONSE, Byte))
                                    End If
                                    Console.WriteLine("Prepare response message for ReadDataByPeriodicIdentifier service: {0}", STATUS_OK_KO(status))

                                    ' Write service response message
                                    status = UDSApi.Write_2013(server_handle, service_response_msg)
                                    Console.WriteLine("Write response message for ReadDataByPeriodicIdentifier service: {0}", STATUS_OK_KO(status))

                                    ' Free response message (and clean memory in order to reallocate later)
                                    status = UDSApi.MsgFree_2013(service_response_msg)
                                    Console.WriteLine("Free response message: {0}", STATUS_OK_KO(status))

                                    ' Sends a message for each data identifier with a specific addressing.
                                    periodic_data_identifier_length = request_msg.msg.Msgdata_any_Copy.length - 2
                                    For i = 0 To periodic_data_identifier_length - 1
                                        ' Allocates and prepares message with dummy data
                                        periodic_response = New uds_msg()
                                        status = UDSApi.MsgAlloc_2013(periodic_response, periodic_msg_config, 5)
                                        If (UDSApi.StatusIsOk_2013(status)) Then
                                            UDSApi.GetDataParameter_2013(request_msg, i + 1, periodic_data_identifier)
                                            CanTpApi.setData_2016(periodic_response.msg, 0, periodic_data_identifier)
                                            CanTpApi.setData_2016(periodic_response.msg, 1, &H12)
                                            CanTpApi.setData_2016(periodic_response.msg, 2, &H34)
                                            CanTpApi.setData_2016(periodic_response.msg, 3, &H56)
                                            CanTpApi.setData_2016(periodic_response.msg, 4, &H78)

                                            Console.WriteLine("Allocates message for 0x{0:x2} periodic data identifier: {1}", periodic_data_identifier, STATUS_OK_KO(status))
                                            status = UDSApi.Write_2013(server_handle, periodic_response)
                                            Console.WriteLine("Write message for 0x{0:x2} periodic data identifier: {1}", periodic_data_identifier, STATUS_OK_KO(status))
                                            status = UDSApi.MsgFree_2013(periodic_response)
                                            Console.WriteLine("Free message for 0x{0:x2} periodic data identifier: {1}", periodic_data_identifier, STATUS_OK_KO(status))
                                        End If
                                    Next
                                Case Else
                                    Console.WriteLine("Unknown service (0x{0:x2})", service_id)
                            End Select
                        End If
                    End If

                    ' Free request message (in order to reallocate later)
                    status = UDSApi.MsgFree_2013(request_msg)
                    Console.WriteLine("Free request message: {0}", STATUS_OK_KO(status))
                Loop While Not (UDSApi.StatusIsOk_2013(read_status, uds_status.PUDS_STATUS_NO_MESSAGE, False))
            End If

            ' Quit when user press Q
            If Console.KeyAvailable Then
                Dim keyboard_res As Char = Console.ReadKey().KeyChar

                If keyboard_res = "Q"c OrElse keyboard_res = "q"c Then
                    stopit = True
                End If
            End If
        Loop While Not stopit

        ' Close receive event
        If IntPtr.Size = 4 Then
            Dim tmp_buffer As UInt32 = 0
            status = UDSApi.SetValue_2013(server_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, tmp_buffer, CType(Marshal.SizeOf(tmp_buffer), UInt32))

        ElseIf IntPtr.Size = 8 Then
            Dim tmp_buffer As Int64 = 0
            Dim byte_array As Byte() = BitConverter.GetBytes(tmp_buffer)
            status = UDSApi.SetValue_2013(server_handle, uds_parameter.PUDS_PARAMETER_RECEIVE_EVENT, byte_array, CType(Marshal.SizeOf(tmp_buffer), UInt32))
        End If
        Console.WriteLine("Stop receive event: {0}", STATUS_OK_KO(status))
        receive_event.Close()
        Console.WriteLine("Close receive event: {0}", STATUS_OK_KO(status))

        ' Close server
        status = UDSApi.Uninitialize_2013(server_handle)
        Console.WriteLine("Uninitialize channel: {0}", STATUS_OK_KO(status))

        ' Exit
        Console.WriteLine("Press any key to continue...")
        Console.In.Read()
    End Sub
End Module
