﻿Imports System
Imports System.Runtime.InteropServices
Imports System.Threading

Imports Peak.Can.Basic
Imports Peak.Can.IsoTp
Imports Peak.Can.Uds


Module Module1
    Const PCAN_BITRATE As String = "f_clock=40000000,nom_brp=2,nom_tseg1=63,nom_tseg2=16,nom_sjw=16,data_brp=2,data_tseg1=7,data_tseg2=2,data_sjw=2"
    Const RESPONSES_TIMEOUT_MS As Long = 5000

    Function OK_KO(ByVal test As Boolean) As String
        If test Then Return "OK"
        Return "KO"
    End Function

    Function STATUS_OK_KO(ByVal test As uds_status) As String
        Return OK_KO(UDSApi.StatusIsOk_2013(test))
    End Function

    ''' <summary>
    '''  Entry point of the program, start a UDS channel, ask ReadDataByPeriodicIdentifier service.
    '''  It sends a request from 0xF1 to 0xC1 address in 29b fixed with normal addressing. Then read
    '''  responses from 0x1F22C1F1 can identifier (UUDT).
    ''' </summary>
    ''' <returns>By convention, return success.</returns>
    Sub Main(ByVal args As String())
        Dim status As uds_status
        Dim client_handle As cantp_handle
        Dim request_config As uds_msgconfig
        Dim msg_request As uds_msg
        Dim request_confirmation As uds_msg
        Dim service_response As uds_msg
        Dim can_tx_dl As UInt32
        Dim timeout_value As UInt32
        Dim periodic_response As uds_msg
        Dim response_count As Byte
        Dim start_reading As Long
        Dim i As UInt32

        ' Initialize variables
        client_handle = cantp_handle.PCANTP_HANDLE_USBBUS1 ' TODO: modify the value according to your available PCAN devices.
        request_config = New uds_msgconfig()
        msg_request = New uds_msg()
        request_confirmation = New uds_msg()
        service_response = New uds_msg()
        periodic_response = New uds_msg()

        ' Initialize client
        status = UDSApi.InitializeFD_2013(client_handle, PCAN_BITRATE)
        Console.WriteLine("Initialize channel: {0}", STATUS_OK_KO(status))

        ' Define CAN_TX_DL
        can_tx_dl = 15
        status = UDSApi.SetValue_2013(client_handle, uds_parameter.PUDS_PARAMETER_CAN_TX_DL, can_tx_dl, CType(Marshal.SizeOf(can_tx_dl), UInt32))
        Console.WriteLine("Set CAN TX DL: {0}", STATUS_OK_KO(status))

        ' Check CAN_TX_DL
        can_tx_dl = 0
        status = UDSApi.GetValue_2013(client_handle, uds_parameter.PUDS_PARAMETER_CAN_TX_DL, can_tx_dl, CType(Marshal.SizeOf(can_tx_dl), UInt32))
        Console.WriteLine("Check new CAN TX DL value({0}): {1}", can_tx_dl, STATUS_OK_KO(status))

        ' Set UDS timeouts
        timeout_value = 5000
        status = UDSApi.SetValue_2013(client_handle, uds_parameter.PUDS_PARAMETER_TIMEOUT_REQUEST, timeout_value, CType(Marshal.SizeOf(timeout_value), UInt32))
        Console.WriteLine("Set request timeout(ms): {0}", STATUS_OK_KO(status))
        status = UDSApi.SetValue_2013(client_handle, uds_parameter.PUDS_PARAMETER_TIMEOUT_RESPONSE, timeout_value, CType(Marshal.SizeOf(timeout_value), UInt32))
        Console.WriteLine("Set response timeout(ms): {0}", STATUS_OK_KO(status))

        ' Check timeouts
        timeout_value = 0
        status = UDSApi.GetValue_2013(client_handle, uds_parameter.PUDS_PARAMETER_TIMEOUT_REQUEST, timeout_value, CType(Marshal.SizeOf(timeout_value), UInt32))
        Console.WriteLine("Get new request timeout({0}ms): {1}", timeout_value, STATUS_OK_KO(status))
        timeout_value = 0
        status = UDSApi.GetValue_2013(client_handle, uds_parameter.PUDS_PARAMETER_TIMEOUT_RESPONSE, timeout_value, CType(Marshal.SizeOf(timeout_value), UInt32))
        Console.WriteLine("Get new response timeout({0}ms): {1}", timeout_value, STATUS_OK_KO(status))

        ' Initialize the request configuration
        request_config.can_id = &HFFFFFFFFUI
        request_config.can_msgtype = cantp_can_msgtype.PCANTP_CAN_MSGTYPE_EXTENDED Or cantp_can_msgtype.PCANTP_CAN_MSGTYPE_FD Or cantp_can_msgtype.PCANTP_CAN_MSGTYPE_BRS
        request_config.nai.protocol = uds_msgprotocol.PUDS_MSGPROTOCOL_ISO_15765_2_29B_FIXED_NORMAL
        request_config.nai.target_type = cantp_isotp_addressing.PCANTP_ISOTP_ADDRESSING_PHYSICAL
        request_config.type = uds_msgtype.PUDS_MSGTYPE_USDT
        request_config.nai.source_addr = CType(uds_address.PUDS_ADDRESS_ISO_15765_4_ADDR_TEST_EQUIPMENT, UInt16)
        request_config.nai.target_addr = &HC1
        request_config.nai.extension_addr = 0

        ' Add a filter for 0x1F22C1F1 can id (in order to receive UUDT messages)
        status = UDSApi.AddCanIdFilter_2013(client_handle, &H1F22C1F1)
        Console.WriteLine("Add can identifier filter: {0}", STATUS_OK_KO(status))

        ' Execute ReadDataByPeriodicIdentifier and wait service response
        Dim periodic_data_identifier() As Byte = {&H12, &H34, &H56, &H78}
        status = UDSApi.SvcReadDataByPeriodicIdentifier_2013(client_handle, request_config, msg_request, UDSApi.uds_svc_param_rdbpi.PUDS_SVC_PARAM_RDBPI_SAMR, periodic_data_identifier, 4)
        Console.WriteLine("Execute ReadDataByPeriodicIdentifier service: {0}", STATUS_OK_KO(status))
        status = UDSApi.WaitForService_2013(client_handle, msg_request, service_response, request_confirmation)
        Console.WriteLine("Wait for service (confirmation and response): {0}", STATUS_OK_KO(status))

        ' Read responses for each given periodic data identifier
        response_count = 0
        start_reading = DateTime.UtcNow.Ticks / TimeSpan.TicksPerMillisecond
        Do
            status = UDSApi.Read_2013(client_handle, periodic_response)
            If UDSApi.StatusIsOk_2013(status, uds_status.PUDS_STATUS_OK, False) And periodic_response.msg.Msgdata_any_Copy.length > 0 Then
                response_count += 1
                Dim msg_data_buffer As Byte = 0
                CanTpApi.getData_2016(periodic_response.msg, 0, msg_data_buffer)
                Console.Write("Read response for 0x{0:x2} periodic data identifier: [", msg_data_buffer)
                For i = 0 To periodic_response.msg.Msgdata_any_Copy.length - 1
                    CanTpApi.getData_2016(periodic_response.msg, i, msg_data_buffer)
                    Console.Write(" 0x{0:x2}", msg_data_buffer)
                Next
                Console.WriteLine(" ]")
                status = UDSApi.MsgFree_2013(periodic_response)
                Console.WriteLine("Free response buffer: {0}", STATUS_OK_KO(status))
            End If

            ' Wait for 4 responses or timeout
        Loop While response_count < 4 And (DateTime.UtcNow.Ticks / TimeSpan.TicksPerMillisecond) - start_reading < RESPONSES_TIMEOUT_MS

        ' Free message structures
        status = UDSApi.MsgFree_2013(msg_request)
        Console.WriteLine("Free request message: {0}", STATUS_OK_KO(status))
        status = UDSApi.MsgFree_2013(request_confirmation)
        Console.WriteLine("Free request confirmation: {0}", STATUS_OK_KO(status))
        status = UDSApi.MsgFree_2013(service_response)
        Console.WriteLine("Free service response: {0}", STATUS_OK_KO(status))

        ' Close client
        status = UDSApi.Uninitialize_2013(client_handle)
        Console.WriteLine("Uninitialize channel: {0}", STATUS_OK_KO(status))

        ' Exit
        Console.WriteLine("Press any key to continue...")
        Console.In.Read()
    End Sub
End Module
