﻿Imports System
Imports System.Linq
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.IO
Imports System.Runtime.InteropServices
Imports System.Text
Imports System.Windows.Forms
Imports PcanUdsSampleVisualBasic.Peak.Can.Uds
Imports TPUDSCANHandle = System.UInt16
Imports System.Globalization
Imports PcanUdsSampleVisualBasic.Peak.Can.Uds.UDSApi
Imports PcanUdsSampleVisualBasic
Imports Microsoft.VisualBasic

Partial Friend Class FormMain
    Inherits Form

    Private Const ByteValuesBufferInputText As String = "(8 bit values in hex separeted with commas, e.g. 00, 6, F7)"
    Private Const ShortValuesBufferInputText As String = "(16 bit values in hex separeted with commas, e.g. 00, 6, F7, F1D8)"
    Private ReadOnly mApiUser As ApiUser
    Private mMappings As List(Of MappingInformation)
    Private mSelectedHardwareIsNonPlugAndPlay As Boolean
    Private mServiceHandler As BackgroundWorker
    Private mRecevieUUDTWorker As BackgroundWorker
    Private ReadOnly DefaultMappings As MappingInformation()
    Private mResponsesReceived As List(Of ResponseInformation)
    Private mMappingIsUUDT As Boolean

    Public Sub New()

        mApiUser = New ApiUser
        mMappings = New List(Of MappingInformation)

        mResponsesReceived = New List(Of ResponseInformation)

        mServiceHandler = New BackgroundWorker
        AddHandler mServiceHandler.DoWork, AddressOf SendServiceAndWaitForResponse
        AddHandler mServiceHandler.RunWorkerCompleted, AddressOf HandleResponse
        mServiceHandler.WorkerSupportsCancellation = True
        mRecevieUUDTWorker = New BackgroundWorker
        AddHandler mRecevieUUDTWorker.DoWork, AddressOf ReceiveUUDT
        AddHandler mRecevieUUDTWorker.RunWorkerCompleted, AddressOf EndReceiveUUDT
        mRecevieUUDTWorker.WorkerSupportsCancellation = True
        DefaultMappings = New MappingInformation(13) {}
        InitializeComponent()
        FillConnectionUi()
        FillDefaultMappings()

        For Each parameter As TPUDSParameter In [Enum].GetValues(GetType(TPUDSParameter))
            If parameter = TPUDSParameter.PUDS_PARAM_SERVER_ADDRESS OrElse parameter = TPUDSParameter.PUDS_PARAM_SESSION_INFO OrElse parameter = TPUDSParameter.PUDS_PARAM_MAPPING_ADD OrElse parameter = TPUDSParameter.PUDS_PARAM_MAPPING_REMOVE Then Continue For
            Dim temp As ComboBoxItem = New ComboBoxItem([Enum].GetName(GetType(TPUDSParameter), parameter), parameter)
            comboBoxParameter.Items.Add(temp)
        Next

        comboBoxParameter.SelectedIndex = 0
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("TesterPresent (0x3E)", TPUDSService.PUDS_SI_TesterPresent))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("DiagnosticSessionControl (0x10)", TPUDSService.PUDS_SI_DiagnosticSessionControl))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("ReadDataByIdentifier (0x22)", TPUDSService.PUDS_SI_ReadDataByIdentifier))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("ClearDiagnosticInformation (0x14)", TPUDSService.PUDS_SI_ClearDiagnosticInformation))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("ReadDTCInformation (0x19)", TPUDSService.PUDS_SI_ReadDTCInformation))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("ControlDtcSetting (0x85)", TPUDSService.PUDS_SI_ControlDTCSetting))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("CommunicationControl (0x28)", TPUDSService.PUDS_SI_CommunicationControl))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("SecurityAccess (0x27)", TPUDSService.PUDS_SI_SecurityAccess))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("RequestDownload (0x34)", TPUDSService.PUDS_SI_RequestDownload))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("TransferData (0x36)", TPUDSService.PUDS_SI_TransferData))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("RequestTransferExit (0x37)", TPUDSService.PUDS_SI_RequestTransferExit))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("RoutineControl (0x31)", TPUDSService.PUDS_SI_RoutineControl))
        comboBoxServiceToSend.Items.Add(New ComboBoxItem("ECUReset (0x11)", TPUDSService.PUDS_SI_ECUReset))
        comboBoxServiceToSend.SelectedIndex = 0
        UpdateUi()
    End Sub

    Private Sub FormMain_FormClosing(ByVal sender As Object, ByVal e As FormClosingEventArgs) Handles MyBase.FormClosing
        If mRecevieUUDTWorker.IsBusy Then mRecevieUUDTWorker.CancelAsync()
        If mApiUser.IsConnected Then mApiUser.Uninitialize()
    End Sub

    Private Sub FillConnectionUi()
        For Each baudrate As TPUDSBaudrate In [Enum].GetValues(GetType(TPUDSBaudrate))
            comboBoxBaudrate.Items.Add(New ComboBoxItem(GetBitrateString(baudrate), baudrate))
        Next

        comboBoxBaudrate.SelectedIndex = 2

        For Each hwType As TPUDSHWType In [Enum].GetValues(GetType(TPUDSHWType))
            comboBoxHwType.Items.Add(New ComboBoxItem([Enum].GetName(GetType(TPUDSHWType), hwType), hwType))
        Next

        comboBoxIoPort.Items.Add(New ComboBoxItem("0100", &H100UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0120", &H120UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0140", &H140UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0200", &H200UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0220", &H220UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0240", &H240UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0260", &H260UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0278", &H278UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0280", &H280UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("02A0", &H2A0UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("02C0", &H2C0UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("02E0", &H2E0UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("02E8", &H2E8UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("02F8", &H2F8UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0300", &H300UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0320", &H320UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0340", &H340UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0360", &H360UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0378", &H378UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("0380", &H380UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("03BC", &H3BCUI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("03E0", &H3E0UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("03E8", &H3E8UI))
        comboBoxIoPort.Items.Add(New ComboBoxItem("03F8", &H3F8UI))
        comboBoxInterrupt.Items.Add(New ComboBoxItem("3", CUShort(3)))
        comboBoxInterrupt.Items.Add(New ComboBoxItem("4", CUShort(4)))
        comboBoxInterrupt.Items.Add(New ComboBoxItem("5", CUShort(5)))
        comboBoxInterrupt.Items.Add(New ComboBoxItem("7", CUShort(7)))
        comboBoxInterrupt.Items.Add(New ComboBoxItem("9", CUShort(9)))
        comboBoxInterrupt.Items.Add(New ComboBoxItem("10", CUShort(10)))
        comboBoxInterrupt.Items.Add(New ComboBoxItem("11", CUShort(11)))
        comboBoxInterrupt.Items.Add(New ComboBoxItem("12", CUShort(12)))
        comboBoxInterrupt.Items.Add(New ComboBoxItem("15", CUShort(15)))
        ButtonHwRefresh_Click(Nothing, EventArgs.Empty)
    End Sub

    Private Sub FillDefaultMappings()
        'this first five entrys can not be removed or added as the fixed CAN IDs do not use mapping, they are only represented as MappingInformation to simplify data handling
        'Physical 29bit CAN id requests with FIXED NORMAL addressing (Source and Target contained in CAN ID)
        DefaultMappings(0) = New MappingInformation(TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B)
        'Functional 29bit CAN id requests with FIXED NORMAL addressing (Source and Target contained in CAN ID)
        DefaultMappings(1) = New MappingInformation(TPUDSAddressingType.PUDS_ADDRESSING_FUNCTIONAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B)
        'Physical 29bit CAN id requests with MIXED addressing (Source and Target contained in CAN ID)
        DefaultMappings(2) = New MappingInformation(TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_REMOTE)
        'Functional 29bit CAN id requests with MIXED addressing (Source and Target contained in CAN ID)
        DefaultMappings(3) = New MappingInformation(TPUDSAddressingType.PUDS_ADDRESSING_FUNCTIONAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_REMOTE)
        '29bit CAN id requests with ENHANCED addressing (Source and Target contained in CAN ID)
        DefaultMappings(4) = New MappingInformation(TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_3_29B)
        'Functional request using 11 bits CAN identifier and normal addressing, from External Test Equipment address to OBD functional address
        DefaultMappings(5) = New MappingInformation(TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_FUNCTIONAL_REQUEST, 0, TPUDSAddress.PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT, TPUDSAddress.PUDS_ISO_15765_4_ADDR_OBD_FUNCTIONAL, 0, TPUDSAddressingType.PUDS_ADDRESSING_FUNCTIONAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B)
        'Physical requests and responses using 11 bits CAN identifier and normal addressing, between the External Test Equipment address and standard ECU #1 address
        DefaultMappings(6) = New MappingInformation(TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_REQUEST_1, TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_RESPONSE_1, TPUDSAddress.PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT, TPUDSAddress.PUDS_ISO_15765_4_ADDR_ECU_1, 0, TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B, True)
        'Physical requests and responses using 11 bits CAN identifier and normal addressing, between the External Test Equipment address and standard ECU #2 address
        DefaultMappings(7) = New MappingInformation(TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_REQUEST_2, TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_RESPONSE_2, TPUDSAddress.PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT, TPUDSAddress.PUDS_ISO_15765_4_ADDR_ECU_2, 0, TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B, True)
        'Physical requests and responses using 11 bits CAN identifier and normal addressing, between the External Test Equipment address and standard ECU #3 address
        DefaultMappings(8) = New MappingInformation(TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_REQUEST_3, TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_RESPONSE_3, TPUDSAddress.PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT, TPUDSAddress.PUDS_ISO_15765_4_ADDR_ECU_3, 0, TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B, True)
        'Physical requests and responses using 11 bits CAN identifier and normal addressing, between the External Test Equipment address and standard ECU #4 address
        DefaultMappings(9) = New MappingInformation(TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_REQUEST_4, TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_RESPONSE_4, TPUDSAddress.PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT, TPUDSAddress.PUDS_ISO_15765_4_ADDR_ECU_4, 0, TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B, True)
        'Physical requests and responses using 11 bits CAN identifier and normal addressing, between the External Test Equipment address and standard ECU #5 address
        DefaultMappings(10) = New MappingInformation(TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_REQUEST_5, TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_RESPONSE_5, TPUDSAddress.PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT, TPUDSAddress.PUDS_ISO_15765_4_ADDR_ECU_5, 0, TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B, True)
        'Physical requests and responses using 11 bits CAN identifier and normal addressing, between the External Test Equipment address and standard ECU #6 address
        DefaultMappings(11) = New MappingInformation(TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_REQUEST_6, TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_RESPONSE_6, TPUDSAddress.PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT, TPUDSAddress.PUDS_ISO_15765_4_ADDR_ECU_6, 0, TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B, True)
        'Physical requests and responses using 11 bits CAN identifier and normal addressing, between the External Test Equipment address and standard ECU #7 address
        DefaultMappings(12) = New MappingInformation(TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_REQUEST_7, TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_RESPONSE_7, TPUDSAddress.PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT, TPUDSAddress.PUDS_ISO_15765_4_ADDR_ECU_7, 0, TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B, True)
        'Physical requests and responses using 11 bits CAN identifier and normal addressing, between the External Test Equipment address and standard ECU #8 address
        DefaultMappings(13) = New MappingInformation(TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_REQUEST_8, TPUDSCanId.PUDS_ISO_15765_4_CAN_ID_PHYSICAL_RESPONSE_8, TPUDSAddress.PUDS_ISO_15765_4_ADDR_TEST_EQUIPMENT, TPUDSAddress.PUDS_ISO_15765_4_ADDR_ECU_8, 0, TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B, True)
    End Sub

    Private Sub UpdateUi()
        buttonHwInitialize.Enabled = Not mApiUser.IsConnected
        buttonHwRelease.Enabled = mApiUser.IsConnected
        buttonHwRefresh.Enabled = Not mApiUser.IsConnected
        buttonHwReset.Enabled = mApiUser.IsConnected
        comboBoxChannel.Enabled = Not mApiUser.IsConnected
        comboBoxBaudrate.Enabled = Not mApiUser.IsConnected

        If mSelectedHardwareIsNonPlugAndPlay Then
            comboBoxHwType.Enabled = Not mApiUser.IsConnected
            comboBoxIoPort.Enabled = Not mApiUser.IsConnected
            comboBoxInterrupt.Enabled = Not mApiUser.IsConnected
        End If

        buttonInformationStatus.Enabled = mApiUser.IsConnected
        buttonChannelNodeGet.Enabled = mApiUser.IsConnected
        buttonChannelNodeSet.Enabled = mApiUser.IsConnected
        buttonMappingAdd.Enabled = mApiUser.IsConnected
        buttonMappingSave.Enabled = mApiUser.IsConnected
        buttonMappingLoad.Enabled = mApiUser.IsConnected
        buttonMappingFillExample.Enabled = mApiUser.IsConnected
        groupBoxSend.Enabled = mApiUser.IsConnected
        listViewResponse.Enabled = mApiUser.IsConnected
        buttonSend.Enabled = Not mApiUser.IsCommunicating
        ComboBoxParameter_SelectedIndexChanged(Nothing, EventArgs.Empty)
    End Sub

    Private Sub ComboBoxChannel_SelectedIndexChanged(sender As Object, e As EventArgs) Handles comboBoxChannel.SelectedIndexChanged
        mSelectedHardwareIsNonPlugAndPlay = CUShort(TryCast(comboBoxChannel.SelectedItem, ComboBoxItem).Data) <= PUDS_DNGBUS1
        comboBoxHwType.Enabled = mSelectedHardwareIsNonPlugAndPlay
        comboBoxIoPort.Enabled = mSelectedHardwareIsNonPlugAndPlay
        comboBoxInterrupt.Enabled = mSelectedHardwareIsNonPlugAndPlay

        If mSelectedHardwareIsNonPlugAndPlay Then
            comboBoxHwType.SelectedIndex = 0
            comboBoxIoPort.SelectedIndex = 0
            comboBoxInterrupt.SelectedIndex = 0
        Else
            comboBoxHwType.SelectedItem = Nothing
            comboBoxIoPort.SelectedItem = Nothing
            comboBoxInterrupt.SelectedItem = Nothing
        End If
    End Sub

    Private Sub ButtonHwRefresh_Click(sender As Object, e As EventArgs) Handles buttonHwRefresh.Click
        Dim availableChannels As List(Of TPUDSCANHandle) = mApiUser.GetAvailableChannels
        Dim selectedHandle As TPUDSCANHandle

        If TypeOf comboBoxChannel.SelectedItem Is ComboBoxItem Then
            selectedHandle = CUShort(TryCast(comboBoxChannel.SelectedItem, ComboBoxItem).Data)
        Else
            selectedHandle = 0
        End If

        comboBoxChannel.Items.Clear()

        For Each channel In availableChannels
            comboBoxChannel.Items.Add(New ComboBoxItem(GetHardwareChannelName(channel), channel))
            If selectedHandle = channel Then comboBoxChannel.SelectedIndex = comboBoxChannel.Items.Count - 1
        Next

        If selectedHandle = 0 OrElse comboBoxChannel.SelectedItem Is Nothing Then comboBoxChannel.SelectedIndex = comboBoxChannel.Items.Count - 1
    End Sub

    Private Sub buttonReset_Click(sender As Object, e As EventArgs) Handles buttonHwReset.Click
        mApiUser.ResetHardware()
        mResponsesReceived.Clear()
        listViewResponse.Items.Clear()
    End Sub

    Private Sub ButtonHwInitialize_Click(sender As Object, e As EventArgs) Handles buttonHwInitialize.Click
        Dim selectedHandle As TPUDSCANHandle = TryCast(comboBoxChannel.SelectedItem, ComboBoxItem).Data
        Dim selectedBaudrate As TPUDSBaudrate = TryCast(comboBoxBaudrate.SelectedItem, ComboBoxItem).Data

        If mSelectedHardwareIsNonPlugAndPlay Then
            Dim selectedHwType As TPUDSHWType = TryCast(comboBoxHwType.SelectedItem, ComboBoxItem).Data
            Dim selectedIoPort As UInteger = TryCast(comboBoxIoPort.SelectedItem, ComboBoxItem).Data
            Dim selectedInterrupt As TPUDSCANHandle = TryCast(comboBoxInterrupt.SelectedItem, ComboBoxItem).Data
            mApiUser.ConnectNonPlugAndPlay(selectedHandle, selectedBaudrate, selectedHwType, selectedIoPort, selectedInterrupt)
        Else
            mApiUser.Connect(selectedHandle, selectedBaudrate)
        End If

        If mApiUser.IsConnected Then
            numericUpDownLocalNodeAdress.Value = mApiUser.LocalNodeAddress
            mMappings = New List(Of MappingInformation)
            mMappings.AddRange(DefaultMappings)
            UpdateMappingsInUi()
        End If

        listViewResponse.Items.Clear()
        mResponsesReceived.Clear()
        UpdateUi()
    End Sub

    Private Sub ButtonHwRelease_Click(sender As Object, e As EventArgs) Handles buttonHwRelease.Click
        mApiUser.Uninitialize()
        UpdateUi()
    End Sub

    Private Sub NumericUpDownLocalNodeAdress_ValueChanged(sender As Object, e As EventArgs) Handles numericUpDownLocalNodeAdress.ValueChanged
        If numericUpDownLocalNodeAdress.Value >= 256 Then checkBoxEnhancedLocalAddress.Checked = True
    End Sub

    Private Sub ButtonChannelNodeSet_Click(sender As Object, e As EventArgs) Handles buttonChannelNodeSet.Click
        If mApiUser.SetLocalAddress(numericUpDownLocalNodeAdress.Value, checkBoxEnhancedLocalAddress.Checked) Then
            numericUpDownLocalNodeAdress.Value = mApiUser.LocalNodeAddress
            textBoxSourceAddress.Text = mApiUser.LocalNodeAddress.ToString("X2")
            AddToListBox("Local address set")
            If mApiUser.IsConnected Then EnableSendGroupbox()
        Else
            AddToListBox("Failed to set local address")
        End If
    End Sub

    Private Sub ButtonChannelNodeGet_Click(sender As Object, e As EventArgs) Handles buttonChannelNodeGet.Click
        Dim localNode As UInteger = Nothing

        If mApiUser.GetLocalAddress(localNode) Then
            If mApiUser.LocalAddressIsExtended Then checkBoxEnhancedLocalAddress.Checked = True
            numericUpDownLocalNodeAdress.Value = localNode
            AddToListBox("Fetched local address")
        Else
            AddToListBox("Failed to fetched local address")
        End If
    End Sub

    Private Sub ComboBoxParameter_SelectedIndexChanged(sender As Object, e As EventArgs) Handles comboBoxParameter.SelectedIndexChanged
        Dim item As ComboBoxItem = TryCast(comboBoxParameter.SelectedItem, ComboBoxItem)
        If item Is Nothing Then
            buttonSetParameter.Enabled = False
            buttonGetParameter.Enabled = False
            numericUpDownParamValue.Enabled = False
            radioButtonParameterActive.Enabled = False
            radioButtonParameterInactive.Enabled = False
        End If

        Dim parameter As TPUDSParameter = item.Data

        If mApiUser.IsConnected Then
            buttonGetParameter.Enabled = True

            If parameter <> TPUDSParameter.PUDS_PARAM_SESSION_INFO AndAlso parameter <> TPUDSParameter.PUDS_PARAM_API_VERSION AndAlso parameter <> TPUDSParameter.PUDS_PARAM_RECEIVE_EVENT AndAlso parameter <> TPUDSParameter.PUDS_PARAM_CHANNEL_CONDITION Then
                buttonSetParameter.Enabled = True

                If parameter = TPUDSParameter.PUDS_PARAM_SERVER_FILTER Then
                    labelActivation.Text = "Operation"
                    radioButtonParameterActive.Text = "Add"
                    radioButtonParameterInactive.Text = "Remove"
                Else
                    labelActivation.Text = "Activation"
                    radioButtonParameterActive.Text = "Active"
                    radioButtonParameterInactive.Text = "Inactive"
                End If

                radioButtonParameterActive.Enabled = parameter = TPUDSParameter.PUDS_PARAM_SERVER_FILTER OrElse parameter = TPUDSParameter.PUDS_PARAM_DEBUG OrElse parameter = TPUDSParameter.PUDS_PARAM_CAN_DATA_PADDING
                radioButtonParameterInactive.Enabled = parameter = TPUDSParameter.PUDS_PARAM_SERVER_FILTER OrElse parameter = TPUDSParameter.PUDS_PARAM_DEBUG OrElse parameter = TPUDSParameter.PUDS_PARAM_CAN_DATA_PADDING
                numericUpDownParamValue.Enabled = parameter <> TPUDSParameter.PUDS_PARAM_DEBUG AndAlso parameter <> TPUDSParameter.PUDS_PARAM_CAN_DATA_PADDING
                AdjustParameterValueRange(parameter)
            Else
                buttonSetParameter.Enabled = False
                radioButtonParameterActive.Enabled = False
                radioButtonParameterInactive.Enabled = False
                numericUpDownParamValue.Enabled = False
            End If
        Else
            buttonSetParameter.Enabled = parameter = TPUDSParameter.PUDS_PARAM_WFT_MAX
            buttonGetParameter.Enabled = parameter = TPUDSParameter.PUDS_PARAM_API_VERSION OrElse parameter = TPUDSParameter.PUDS_PARAM_CHANNEL_CONDITION OrElse parameter = TPUDSParameter.PUDS_PARAM_WFT_MAX
            numericUpDownParamValue.Enabled = parameter = TPUDSParameter.PUDS_PARAM_WFT_MAX
            If parameter = TPUDSParameter.PUDS_PARAM_WFT_MAX Then AdjustParameterValueRange(TPUDSParameter.PUDS_PARAM_WFT_MAX)
        End If
    End Sub

    Private Sub AdjustParameterValueRange(parameter As TPUDSParameter)
        Select Case parameter
            Case TPUDSParameter.PUDS_PARAM_TIMEOUT_REQUEST, TPUDSParameter.PUDS_PARAM_TIMEOUT_RESPONSE, TPUDSParameter.PUDS_PARAM_WFT_MAX
                numericUpDownParamValue.Maximum = 4294967295
            Case TPUDSParameter.PUDS_PARAM_BLOCK_SIZE, TPUDSParameter.PUDS_PARAM_PADDING_VALUE, TPUDSParameter.PUDS_PARAM_SERVER_FILTER
                numericUpDownParamValue.Maximum = 255
            Case TPUDSParameter.PUDS_PARAM_SEPERATION_TIME
                numericUpDownParamValue.Maximum = 127
        End Select
    End Sub

    Private Function GetParameterValueFromUi(ByVal parameter As TPUDSParameter) As UInteger
        Select Case parameter
            Case TPUDSParameter.PUDS_PARAM_SERVER_FILTER, TPUDSParameter.PUDS_PARAM_TIMEOUT_REQUEST, TPUDSParameter.PUDS_PARAM_TIMEOUT_RESPONSE, TPUDSParameter.PUDS_PARAM_BLOCK_SIZE, TPUDSParameter.PUDS_PARAM_SEPERATION_TIME, TPUDSParameter.PUDS_PARAM_WFT_MAX, TPUDSParameter.PUDS_PARAM_PADDING_VALUE
                Return numericUpDownParamValue.Value
            Case TPUDSParameter.PUDS_PARAM_DEBUG, TPUDSParameter.PUDS_PARAM_CAN_DATA_PADDING

                If radioButtonParameterActive.Checked Then
                    Return 1
                Else
                    Return 0
                End If

            Case Else
                Return 0
        End Select
    End Function

    Private Sub ButtonSetParameter_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonSetParameter.Click
        Dim parameter As TPUDSParameter = TryCast(comboBoxParameter.SelectedItem, ComboBoxItem).Data
        Dim value = GetParameterValueFromUi(parameter)

        If parameter = TPUDSParameter.PUDS_PARAM_SERVER_FILTER Then

            If radioButtonParameterActive.Checked Then
                mApiUser.AddAddressToFilter(value)
            Else
                mApiUser.RemoveAddressFromFilter(value)
            End If
        End If

        If mApiUser.SetParameter(parameter, value) Then AddToListBox(BuildParameterSetLine(parameter, value))
    End Sub

    Private Sub ButtonGetParameter_Click(sender As Object, e As EventArgs) Handles buttonGetParameter.Click
        Dim parameter As TPUDSParameter = TryCast(comboBoxParameter.SelectedItem, ComboBoxItem).Data
        Dim value As UInteger = Nothing

        If IsUIntParameter(parameter) Then
            If mApiUser.GetUIntParameter(parameter, value) Then AddToListBox(BuildUIntParameterLine(parameter, value))
        Else
            If mApiUser.GetStringParameter(parameter, value) Then AddToListBox(BuildStringParameterLine(parameter, value))
        End If
    End Sub

    Private Function IsUIntParameter(ByVal parameter As TPUDSParameter) As Boolean
        Return parameter <> TPUDSParameter.PUDS_PARAM_API_VERSION
    End Function

    Private Sub ButtonInformationVersion_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonInformationVersion.Click
        Dim version As String = Nothing
        If mApiUser.GetStringParameter(TPUDSParameter.PUDS_PARAM_API_VERSION, version) Then AddToListBox("Api-Version: " & version)
    End Sub

    Private Sub ButtonInformationClear_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonInformationClear.Click
        listBoxParameterInformation.Items.Clear()
    End Sub

    Private Sub ButtonInformationStatus_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonInformationStatus.Click
        Dim status As String = Nothing

        If mApiUser.GetHardwareStatus(status) Then
            AddToListBox(status)
        Else
            AddToListBox("Could not fetch status of device")
        End If
    End Sub

    Private Function BuildParameterSetLine(ByVal parameter As TPUDSParameter, ByVal value As UInteger) As String
        If parameter = TPUDSParameter.PUDS_PARAM_PADDING_VALUE Then
            Return [Enum].GetName(GetType(TPUDSParameter), parameter) & " set to " & value.ToString("X") & "h"
        Else
            Return [Enum].GetName(GetType(TPUDSParameter), parameter) & " set to " & value
        End If
    End Function

    Private Function BuildStringParameterLine(ByVal parameter As TPUDSParameter, ByVal value As String) As String
        If parameter = TPUDSParameter.PUDS_PARAM_API_VERSION Then Return "Api Version: " & value
        Return "unknown parameter"
    End Function

    Private Function BuildUIntParameterLine(ByVal parameter As TPUDSParameter, ByVal value As UInteger) As String
        Dim parameterLine As String

        Select Case parameter
            Case TPUDSParameter.PUDS_PARAM_SERVER_FILTER
                parameterLine = "Server filter: " & value.ToString("X")
            Case TPUDSParameter.PUDS_PARAM_TIMEOUT_REQUEST
                parameterLine = "Request timeout: " & value
            Case TPUDSParameter.PUDS_PARAM_TIMEOUT_RESPONSE
                parameterLine = "Response timeout: " & value
            Case TPUDSParameter.PUDS_PARAM_RECEIVE_EVENT

                If value <> 0 Then
                    parameterLine = String.Format("Handle of receive event: 0x{0:X8}" & value)
                Else
                    parameterLine = "no receive event set"
                End If

            Case TPUDSParameter.PUDS_PARAM_BLOCK_SIZE

                If value = 0 Then
                    parameterLine = "block size is unlimited"
                Else
                    parameterLine = "block size is limited to " & value & " consecutive frames"
                End If

            Case TPUDSParameter.PUDS_PARAM_SEPERATION_TIME

                If value = 0 Then
                    parameterLine = "No seperation time is given for the consecutive frames."
                Else
                    parameterLine = "A minimum of " & value & "ms is waited between two consecutive frames."
                End If

            Case TPUDSParameter.PUDS_PARAM_DEBUG

                If value = PUDS_DEBUG_NONE Then
                    parameterLine = "Debugging is disabled"
                ElseIf value = PUDS_DEBUG_CAN Then
                    parameterLine = "Debugging is enabled"
                Else
                    parameterLine = "No debugging value returned"
                End If

            Case TPUDSParameter.PUDS_PARAM_CHANNEL_CONDITION
                parameterLine = BuildChannelConditionLine(value)
            Case TPUDSParameter.PUDS_PARAM_WFT_MAX
                parameterLine = "Maximum number of Wait FlowControl: " & value
            Case TPUDSParameter.PUDS_PARAM_CAN_DATA_PADDING

                If value = PUDS_CAN_DATA_PADDING_NONE Then
                    parameterLine = "Data padding is disabled"
                ElseIf value = PUDS_CAN_DATA_PADDING_ON Then
                    parameterLine = "Data padding is enabled"
                Else
                    parameterLine = "No padding value returned"
                End If

            Case TPUDSParameter.PUDS_PARAM_PADDING_VALUE
                parameterLine = String.Format("Padded bytes are filled with value: {0,2:X}h", value)
            Case Else
                parameterLine = "unknown parameter"
        End Select

        Return parameterLine
    End Function

    Private Function BuildChannelConditionLine(ByVal value As UInteger) As String
        If value = PUDS_CHANNEL_AVAILABLE Then
            Return "Channel condition is: PUDS_CHANNEL_AVAILABLE"
        ElseIf value = PUDS_CHANNEL_OCCUPIED Then
            Return "Channel condition is: PUDS_CHANNEL_OCCUPIED"
        ElseIf value = PUDS_CHANNEL_UNAVAILABLE Then
            Return "Channel condition is: PUDS_CHANNEL_UNAVAILABLE"
        End If

        Return "no channel condition value"
    End Function

    Private Sub AddToListBox(ByVal line As String)
        listBoxParameterInformation.Items.Add(line)
        listBoxParameterInformation.SelectedIndex = listBoxParameterInformation.Items.Count - 1
    End Sub

    Private Sub UpdateMappingsInUi()
        Dim comboboxSelected As MappingInformation = Nothing
        Dim listviewSelected As MappingInformation = Nothing
        If comboBoxMappings.SelectedItem IsNot Nothing Then comboboxSelected = CType(TryCast(comboBoxMappings.SelectedItem, ComboBoxItem).Data, MappingInformation)
        If listViewMappings.SelectedItems.Count > 0 Then listviewSelected = CType(listViewMappings.SelectedItems(0).Tag, MappingInformation)
        comboBoxMappings.Items.Clear()
        listViewMappings.Items.Clear()

        For Each mapping In mMappings
            Dim item = New ListViewItem
            item.Tag = mapping
            item.Text = mapping.CanIdString
            item.SubItems.Add(mapping.ResponseCanIdString)
            item.SubItems.Add(mapping.TargetTypeString)
            item.SubItems.Add(mapping.ProtocolString)
            item.SubItems.Add(mapping.SourceAddressString)
            item.SubItems.Add(mapping.TargetAddressString)
            item.SubItems.Add(mapping.RemoteAddressString)
            item.SubItems.Add(mapping.IsTwoWayString)
            listViewMappings.Items.Add(item)
            If mapping.Equals(listviewSelected) Then item.Selected = True
            comboBoxMappings.Items.Add(New ComboBoxItem(mapping.Name, mapping))

            If mapping.IsTwoWay Then
                Dim backwardsMapping = mapping.Backwards
                comboBoxMappings.Items.Add(New ComboBoxItem(backwardsMapping.Name, backwardsMapping))
            End If

            If mapping.Equals(comboboxSelected) Then comboBoxMappings.SelectedIndex = comboBoxMappings.Items.Count - 1
        Next

        If comboBoxMappings.SelectedItem Is Nothing Then comboBoxMappings.SelectedIndex = 0
    End Sub

    Private Sub ListViewMappings_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles listViewMappings.SelectedIndexChanged
        Dim enableRemove = False

        If listViewMappings.SelectedIndices.Count <> 0 Then
            Dim info = CType(listViewMappings.SelectedItems(0).Tag, MappingInformation)
            If Not info.IsFixedCanIdprotocol Then enableRemove = True
        End If

        buttonMappingRemove.Enabled = enableRemove
    End Sub

    Private Sub ButtonMappingAdd_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonMappingAdd.Click
        Dim mapping = New FormMapping(numericUpDownLocalNodeAdress.Value)

        If mapping.ShowDialog = DialogResult.OK Then

            If mApiUser.AddMapping(mapping.MappingInformation) Then
                Dim foundMapping = False

                For i = 0 To mMappings.Count - 1

                    If mMappings(i).Backwards.Equals(mapping.MappingInformation) Then
                        mMappings(i).IsTwoWay = True
                        foundMapping = True
                    End If
                Next

                If Not foundMapping Then mMappings.Add(mapping.MappingInformation)
                UpdateMappingsInUi()
            End If
        End If
    End Sub

    Private Sub ButtonMappingRemove_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonMappingRemove.Click
        Dim mapping = CType(listViewMappings.SelectedItems(0).Tag, MappingInformation)

        If mApiUser.RemoveMapping(mapping) Then

            If mapping.IsTwoWay Then
                If Not mApiUser.RemoveMapping(mapping.Backwards) Then mMappings.Add(mapping.Backwards)
            End If

            mMappings.Remove(mapping)
            UpdateMappingsInUi()
            ListViewMappings_SelectedIndexChanged(Nothing, EventArgs.Empty)
        End If
    End Sub

    Private Sub buttonMappingSave_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonMappingSave.Click
        If mMappings.Count = 0 Then
            MessageBox.Show("Nothing to save!")
            Return
        End If

        Dim lines = New List(Of String)
        lines.Add("CanId;ResponseCanId;TargetType;Protocol;SourceAddress;TargetAddress;RemoteAddress;TwoWay")

        For Each information In mMappings
            If ProtocolIsDetachedFromIdsAndAddresses(information.Protocol) Then Continue For
            Dim line = New StringBuilder
            line.Append(information.CanIdString)
            line.Append(";")
            line.Append(information.ResponseCanIdString)
            line.Append(";")
            line.Append(information.TargetTypeString)
            line.Append(";")
            line.Append(information.ProtocolString)
            line.Append(";")
            line.Append(information.SourceAddressString)
            line.Append(";")
            line.Append(information.TargetAddressString)
            line.Append(";")
            line.Append(information.RemoteAddressString)
            line.Append(";")
            line.Append(information.IsTwoWayString)
            lines.Add(line.ToString)
        Next

        File.WriteAllLines("mapping.csv", lines)
    End Sub

    Private Sub buttonMappingLoad_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonMappingLoad.Click
        Dim lines As String()

        Try
            lines = File.ReadAllLines("mapping.csv")
        Catch __unusedFileNotFoundException1__ As FileNotFoundException
            lines = Nothing
        End Try

        If lines Is Nothing Then
            MessageBox.Show("No saved mappings found (file: mapping.csv).", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return
        End If

        Dim atLeastOneFaultyLine = False
        Dim newMappings = New List(Of MappingInformation)

        For i = 0 To 5 - 1
            newMappings.Add(DefaultMappings(i))
        Next

        For i = 1 To lines.Length - 1
            Dim partsOfMapping = lines(i).Split(";"c).Select(Function(ByVal x)
                                                                 x = x.Trim("h"c)
                                                                 Return x
                                                             End Function).ToArray

            If partsOfMapping.Length <> 8 Then
                atLeastOneFaultyLine = True
                Exit For
            End If

            Dim protocol As TPUDSProtocol
            Dim targetType As TPUDSAddressingType

            If Not [Enum].TryParse(partsOfMapping(3), protocol) OrElse Not [Enum].TryParse(partsOfMapping(2), targetType) Then
                atLeastOneFaultyLine = True
                Exit For
            End If

            If ProtocolIsDetachedFromIdsAndAddresses(protocol) Then
                newMappings.Add(New MappingInformation(targetType, protocol))
                Exit For
            End If

            Dim canId, responseCanId As UInteger
            Dim sourceAddress, targetAddress, remoteAddress As Byte
            Dim isTwoWay As Boolean

            If UInteger.TryParse(partsOfMapping(0), NumberStyles.HexNumber, Nothing, canId) AndAlso Byte.TryParse(partsOfMapping(4), NumberStyles.HexNumber, Nothing, sourceAddress) AndAlso Byte.TryParse(partsOfMapping(5), NumberStyles.HexNumber, Nothing, targetAddress) AndAlso Byte.TryParse(partsOfMapping(6), NumberStyles.HexNumber, Nothing, remoteAddress) Then

                If targetType = TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL AndAlso protocol <> TPUDSProtocol.PUDS_PROTOCOL_NONE Then

                    If UInteger.TryParse(partsOfMapping(1), NumberStyles.HexNumber, Nothing, responseCanId) AndAlso Boolean.TryParse(partsOfMapping(7), isTwoWay) Then
                        newMappings.Add(New MappingInformation(canId, responseCanId, sourceAddress, targetAddress, remoteAddress, targetType, protocol, isTwoWay))
                    Else
                        atLeastOneFaultyLine = True
                        Exit For
                    End If
                Else
                    newMappings.Add(New MappingInformation(canId, 0, sourceAddress, targetAddress, remoteAddress, targetType, protocol))
                End If
            Else
                atLeastOneFaultyLine = True
                Exit For
            End If
        Next

        If atLeastOneFaultyLine Then
            MessageBox.Show("The file ""mapping.csv"" contained faulty at least one faulty entry." & vbCrLf & " Aborted the loading.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning)
            Return
        End If

        Dim atLeastOneFailed = False

        For Each info In mMappings
            If info.IsFixedCanIdprotocol Then Continue For

            If mApiUser.RemoveMapping(info) Then

                If info.IsTwoWay Then
                    If Not mApiUser.RemoveMapping(info.Backwards) Then atLeastOneFailed = True
                End If
            Else
                atLeastOneFailed = True
            End If
        Next

        If atLeastOneFailed Then MessageBox.Show("At least one mapping could not be removed." & vbCrLf & " This may lead to unwanted aftereffects, if this is the case reset the mappings by releasing and intializing the hardware.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning)
        mMappings.Clear()
        mMappings.AddRange(newMappings)
        atLeastOneFailed = False

        For Each info In mMappings
            If info.IsFixedCanIdprotocol Then Continue For

            If mApiUser.AddMapping(info) Then

                If info.IsTwoWay Then
                    If Not mApiUser.AddMapping(info.Backwards) Then atLeastOneFailed = True
                End If
            Else
                atLeastOneFailed = True
            End If
        Next

        If atLeastOneFailed Then MessageBox.Show("At least one mapping could not be added." & vbCrLf & " This may lead to unwanted aftereffects, if this is the case reset the mappings by releasing and intializing the hardware.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning)
        UpdateMappingsInUi()
    End Sub

    Private Sub buttonMappingFillExample_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonMappingFillExample.Click
        Dim info = New MappingInformation(34, 17, 241, 34, 0, TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B, True)

        If Not mMappings.Contains(info) Then
            mApiUser.AddMapping(info)

            If Not mMappings.Contains(info.Backwards) Then
                mApiUser.AddMapping(info.Backwards)
                mMappings.Add(info)
            Else
                Dim index = mMappings.IndexOf(info.Backwards)
                mMappings(index).IsTwoWay = True
            End If
        Else
            Dim index = mMappings.IndexOf(info)

            If Not mMappings(index).IsTwoWay Then
                mApiUser.AddMapping(info.Backwards)
                mMappings(index).IsTwoWay = True
            End If
        End If

        info = New MappingInformation(47, 0, 241, 51, 0, TPUDSAddressingType.PUDS_ADDRESSING_FUNCTIONAL, TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B)

        If Not mMappings.Contains(info) Then
            mApiUser.AddMapping(info)
            mMappings.Add(info)
        End If

        UpdateMappingsInUi()
    End Sub

    Private Sub ComboBoxServiceToSend_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles comboBoxServiceToSend.SelectedIndexChanged
        ShowAndFillServiceInputs()
    End Sub

    Private Sub ShowAndFillServiceInputs()
        Dim service As TPUDSService = TryCast(comboBoxServiceToSend.SelectedItem, ComboBoxItem).Data
        FillEnumInput(service)
        Dim numberInputOne = False, numberInputTwo = False, bufferInputOne = False, bufferInputTwo = False
        Dim numberInputOneMax As UInteger = 0, numberInputTwoMax As UInteger = 0
        labelReadDTCInformation.Visible = False

        Select Case service
            Case TPUDSService.PUDS_SI_SecurityAccess
                labelFirstServiceBuffer.Text = "Buffer"
                bufferInputOne = True
            Case TPUDSService.PUDS_SI_CommunicationControl
                labelSecondServiceNumber.Text = "Communication Type"
                numberInputTwo = True
                numberInputTwoMax = 255
            Case TPUDSService.PUDS_SI_ControlDTCSetting
                labelFirstServiceBuffer.Text = "Buffer"
                bufferInputOne = True
            Case TPUDSService.PUDS_SI_ReadDataByIdentifier
                labelFirstServiceBuffer.Text = "Buffer"
                bufferInputOne = True
            Case TPUDSService.PUDS_SI_ClearDiagnosticInformation
                labelFirstServiceNumber.Text = "Group of DTCs"
                numberInputOne = True
                numberInputOneMax = 4294967295
            Case TPUDSService.PUDS_SI_ReadDTCInformation
                labelFirstServiceNumber.Text = "DTC status mask"
                labelReadDTCInformation.Visible = True
                numberInputOne = True
                numberInputOneMax = 255
            Case TPUDSService.PUDS_SI_RoutineControl
                labelSecondServiceNumber.Text = "Routine Identifier"
                labelFirstServiceBuffer.Text = "Options"
                bufferInputOne = True
                numberInputTwo = True
                numberInputTwoMax = 65535
            Case TPUDSService.PUDS_SI_RequestDownload
                labelFirstServiceNumber.Text = "Compression method"
                labelSecondServiceNumber.Text = "Encryption method"
                labelFirstServiceBuffer.Text = "Memory address"
                labelSecondServiceBuffer.Text = "Memory size"
                numberInputOne = True
                numberInputOneMax = 255
                numberInputTwo = True
                numberInputTwoMax = 255
                bufferInputOne = True
                bufferInputTwo = True
            Case TPUDSService.PUDS_SI_TransferData
                labelFirstServiceBuffer.Text = "Buffer"
                labelFirstServiceNumber.Text = "Block sequence counter"
                numberInputOne = True
                numberInputOneMax = 255
                bufferInputOne = True
            Case TPUDSService.PUDS_SI_RequestTransferExit
                labelFirstServiceBuffer.Text = "Buffer"
                bufferInputOne = True
        End Select

        If service = TPUDSService.PUDS_SI_ReadDataByIdentifier Then
            labelFirstServiceBufferHint.Text = ShortValuesBufferInputText
        Else
            labelFirstServiceBufferHint.Text = ByteValuesBufferInputText
        End If

        labelFirstServiceNumber.Visible = numberInputOne
        numericUpDownFirstServiceNumber.Visible = numberInputOne
        numericUpDownFirstServiceNumber.Maximum = numberInputOneMax
        labelSecondServiceNumber.Visible = numberInputTwo
        numericUpDownSecondServiceNumber.Visible = numberInputTwo
        numericUpDownSecondServiceNumber.Maximum = numberInputTwoMax
        labelFirstServiceBuffer.Visible = bufferInputOne
        labelFirstServiceBufferHint.Visible = bufferInputOne
        textBoxFirstServiceBuffer.Visible = bufferInputOne
        labelSecondServiceBuffer.Visible = bufferInputTwo
        labelSecondServiceBufferHint.Visible = bufferInputTwo
        textBoxSecondServiceBuffer.Visible = bufferInputTwo
        checkBoxSendTesterPresent.Visible = service = TPUDSService.PUDS_SI_DiagnosticSessionControl
        checkBoxSendTesterPresent.Checked = True
        checkBoxSendTesterPresent.Enabled = False
    End Sub

    Private Sub FillEnumInput(ByVal service As TPUDSService)
        If service = TPUDSService.PUDS_SI_TesterPresent OrElse service = TPUDSService.PUDS_SI_ReadDataByIdentifier OrElse service = TPUDSService.PUDS_SI_ClearDiagnosticInformation OrElse service = TPUDSService.PUDS_SI_RequestDownload OrElse service = TPUDSService.PUDS_SI_TransferData OrElse service = TPUDSService.PUDS_SI_RequestTransferExit Then
            labelFirstServiceEnum.Visible = False
            comboBoxFirstServiceEnum.Visible = False
            comboBoxSecondServiceEnum.Visible = False
            labelSecondServiceEnum.Visible = False
            Return
        End If

        labelFirstServiceEnum.Visible = True
        comboBoxFirstServiceEnum.Visible = True
        comboBoxFirstServiceEnum.Items.Clear()

        If service = TPUDSService.PUDS_SI_SecurityAccess Then
            labelFirstServiceEnum.Text = "Security access type"
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_RSD_1", PUDS_SVC_PARAM_SA_RSD_1))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_RSD_3", PUDS_SVC_PARAM_SA_RSD_3))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_RSD_5", PUDS_SVC_PARAM_SA_RSD_5))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_RSD_MIN", PUDS_SVC_PARAM_SA_RSD_MIN))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_RSD_MAX", PUDS_SVC_PARAM_SA_RSD_MAX))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_SK_2", PUDS_SVC_PARAM_SA_SK_2))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_SK_4", PUDS_SVC_PARAM_SA_SK_4))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_SK_6", PUDS_SVC_PARAM_SA_SK_6))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_SK_MIN", PUDS_SVC_PARAM_SA_SK_MIN))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_SA_SK_MAX", PUDS_SVC_PARAM_SA_SK_MAX))
        ElseIf service = TPUDSService.PUDS_SI_ReadDTCInformation Then
            labelFirstServiceEnum.Text = "DTC information type"
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_RDTCI_RNODTCBSM", TPUDSSvcParamRDTCI.PUDS_SVC_PARAM_RDTCI_RNODTCBSM))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_RDTCI_RDTCBSM", TPUDSSvcParamRDTCI.PUDS_SVC_PARAM_RDTCI_RDTCBSM))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_RDTCI_RMMDTCBSM", TPUDSSvcParamRDTCI.PUDS_SVC_PARAM_RDTCI_RMMDTCBSM))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_RDTCI_RNOMMDTCBSM", TPUDSSvcParamRDTCI.PUDS_SVC_PARAM_RDTCI_RNOMMDTCBSM))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_RDTCI_RNOOBDDTCBSM", TPUDSSvcParamRDTCI.PUDS_SVC_PARAM_RDTCI_RNOOBDDTCBSM))
            comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_RDTCI_ROBDDTCBSM", TPUDSSvcParamRDTCI.PUDS_SVC_PARAM_RDTCI_ROBDDTCBSM))
        Else
            Dim enumType As Type

            Select Case service
                Case TPUDSService.PUDS_SI_DiagnosticSessionControl
                    labelFirstServiceEnum.Text = "Session type"
                    enumType = GetType(TPUDSSvcParamDSC)
                Case TPUDSService.PUDS_SI_ControlDTCSetting
                    labelFirstServiceEnum.Text = "DTC setting type"
                    enumType = GetType(TPUDSSvcParamCDTCS)
                Case TPUDSService.PUDS_SI_CommunicationControl
                    labelFirstServiceEnum.Text = "Control type"
                    enumType = GetType(TPUDSSvcParamCC)
                Case TPUDSService.PUDS_SI_RoutineControl
                    labelFirstServiceEnum.Text = "Routine control type"
                    enumType = GetType(TPUDSSvcParamRC)
                Case TPUDSService.PUDS_SI_ECUReset
                    labelFirstServiceEnum.Text = "Reset type"
                    enumType = GetType(TPUDSSvcParamER)
                Case Else
                    Return
            End Select

            For Each value In [Enum].GetValues(enumType)
                comboBoxFirstServiceEnum.Items.Add(New ComboBoxItem([Enum].GetName(enumType, value), value))
            Next
        End If

        comboBoxFirstServiceEnum.SelectedIndex = 0

        If service = TPUDSService.PUDS_SI_RoutineControl Then
            numericUpDownSecondServiceNumber.Maximum = 65535
            labelSecondServiceEnum.Visible = True
            labelSecondServiceEnum.Text = "Routine control"
            comboBoxSecondServiceEnum.Visible = True
            comboBoxSecondServiceEnum.Items.Clear()

            For Each routineControl As TPUDSSvcParamRC_RID In [Enum].GetValues(GetType(TPUDSSvcParamRC_RID))
                comboBoxSecondServiceEnum.Items.Add(New ComboBoxItem([Enum].GetName(GetType(TPUDSSvcParamRC_RID), routineControl), routineControl))
            Next

            comboBoxSecondServiceEnum.Items.Add(New ComboBoxItem("Non predefined value", CUShort(0)))
            comboBoxSecondServiceEnum.SelectedIndex = 0
        ElseIf service = TPUDSService.PUDS_SI_CommunicationControl Then
            numericUpDownSecondServiceNumber.Maximum = 255
            labelSecondServiceEnum.Visible = True
            labelSecondServiceEnum.Text = "Communication Type"
            comboBoxSecondServiceEnum.Visible = True
            comboBoxSecondServiceEnum.Items.Clear()
            comboBoxSecondServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_CC_FLAG_APPL", PUDS_SVC_PARAM_CC_FLAG_APPL))
            comboBoxSecondServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_CC_FLAG_NWM", PUDS_SVC_PARAM_CC_FLAG_NWM))
            comboBoxSecondServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_CC_FLAG_DESCTIRNCN", PUDS_SVC_PARAM_CC_FLAG_DESCTIRNCN))
            comboBoxSecondServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_CC_FLAG_DENWRIRO", PUDS_SVC_PARAM_CC_FLAG_DENWRIRO))
            comboBoxSecondServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_CC_FLAG_DESNIBNN_MIN", PUDS_SVC_PARAM_CC_FLAG_DESNIBNN_MIN))
            comboBoxSecondServiceEnum.Items.Add(New ComboBoxItem("PUDS_SVC_PARAM_CC_FLAG_DESNIBNN_MAX", PUDS_SVC_PARAM_CC_FLAG_DESNIBNN_MAX))
            comboBoxSecondServiceEnum.Items.Add(New ComboBoxItem("Non predefined value", CByte(0)))
            comboBoxSecondServiceEnum.SelectedIndex = 0
        Else
            labelSecondServiceEnum.Visible = False
            comboBoxSecondServiceEnum.Visible = False
        End If
    End Sub

    Private Sub ButtonSend_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonSend.Click
        If mMappingIsUUDT Then
            SendUUDT()
            Return
        End If

        Dim serviceInformation As ServiceInformation = BuildServiceInformationFromUserInput()
        mServiceHandler.RunWorkerAsync(serviceInformation)
        buttonSend.Text = "Waiting.."
        buttonSend.Enabled = False
    End Sub

    Private Sub SendUUDT()
        Dim information = CType(TryCast(comboBoxMappings.SelectedItem, ComboBoxItem).Data, MappingInformation)
        Dim data As Byte() = Nothing

        If ConvertFirstBufferInputToArray(data) Then
            Dim dlc As Integer = numericUpDownFirstServiceNumber.Value

            If data.Length <> dlc Then
                MessageBox.Show("DLC and data input do not match in length", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return
            End If

            mApiUser.SendUUDT(information, dlc, data)
        Else
            MessageBox.Show("Wrong buffer input", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End If
    End Sub

    Private Function BuildServiceInformationFromUserInput() As ServiceInformation
        Dim service As TPUDSService = TryCast(comboBoxServiceToSend.SelectedItem, ComboBoxItem).Data
        Dim netAddrInfo As TPUDSNetAddrInfo = CType(TryCast(comboBoxMappings.SelectedItem, ComboBoxItem).Data, MappingInformation).NetAddressInformation

        If netAddrInfo.PROTOCOL = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B Then
            netAddrInfo.SA = CByte(mApiUser.LocalNodeAddress)
            netAddrInfo.TA = CByte(numericUpDownTargetAddr.Value)
        End If

        Dim parametersOfService As Object() = Nothing
        Dim bufferByteInput As Byte()
        Dim bufferUshortInput As UShort()

        Select Case service
            Case TPUDSService.PUDS_SI_TesterPresent
                parametersOfService = New Object(-1) {}
            Case TPUDSService.PUDS_SI_DiagnosticSessionControl
                parametersOfService = New Object(0) {}
                parametersOfService(0) = TryCast(comboBoxFirstServiceEnum.SelectedItem, ComboBoxItem).Data
            Case TPUDSService.PUDS_SI_ReadDataByIdentifier
                parametersOfService = New Object(0) {}

                If ConvertFirstBufferInputToArray(bufferUshortInput) Then
                    parametersOfService(0) = bufferUshortInput
                Else
                    parametersOfService = Nothing
                End If

            Case TPUDSService.PUDS_SI_ClearDiagnosticInformation
                parametersOfService = New Object(0) {}
                parametersOfService(0) = numericUpDownFirstServiceNumber.Value
            Case TPUDSService.PUDS_SI_ReadDTCInformation
                parametersOfService = New Object(1) {}
                parametersOfService(0) = TryCast(comboBoxFirstServiceEnum.SelectedItem, ComboBoxItem).Data
                parametersOfService(1) = numericUpDownFirstServiceNumber.Value
            Case TPUDSService.PUDS_SI_ControlDTCSetting
                parametersOfService = New Object(1) {}
                parametersOfService(0) = TryCast(comboBoxFirstServiceEnum.SelectedItem, ComboBoxItem).Data

                If ConvertFirstBufferInputToArray(bufferByteInput) Then
                    parametersOfService(1) = bufferByteInput
                Else
                    parametersOfService = Nothing
                End If

            Case TPUDSService.PUDS_SI_CommunicationControl
                parametersOfService = New Object(1) {}
                parametersOfService(0) = TryCast(comboBoxFirstServiceEnum.SelectedItem, ComboBoxItem).Data
                parametersOfService(1) = numericUpDownSecondServiceNumber.Value
            Case TPUDSService.PUDS_SI_SecurityAccess
                parametersOfService = New Object(1) {}
                parametersOfService(0) = TryCast(comboBoxFirstServiceEnum.SelectedItem, ComboBoxItem).Data

                If ConvertFirstBufferInputToArray(bufferByteInput) Then
                    parametersOfService(1) = bufferByteInput
                Else
                    parametersOfService = Nothing
                End If

            Case TPUDSService.PUDS_SI_RequestDownload
                parametersOfService = New Object(3) {}
                parametersOfService(0) = numericUpDownFirstServiceNumber.Value
                parametersOfService(1) = numericUpDownSecondServiceNumber.Value

                If ConvertFirstBufferInputToArray(bufferByteInput) Then
                    parametersOfService(2) = bufferByteInput

                    If ConvertSecondBufferInputToArray(bufferByteInput) Then
                        parametersOfService(3) = bufferByteInput
                    Else
                        parametersOfService = Nothing
                    End If
                Else
                    parametersOfService = Nothing
                End If

            Case TPUDSService.PUDS_SI_TransferData
                parametersOfService = New Object(1) {}
                parametersOfService(0) = numericUpDownFirstServiceNumber.Value

                If ConvertFirstBufferInputToArray(bufferByteInput) Then
                    parametersOfService(1) = bufferByteInput
                Else
                    parametersOfService = Nothing
                End If

            Case TPUDSService.PUDS_SI_RequestTransferExit
                parametersOfService = New Object(0) {}

                If ConvertFirstBufferInputToArray(bufferByteInput) Then
                    parametersOfService(0) = bufferByteInput
                Else
                    parametersOfService = Nothing
                End If

            Case TPUDSService.PUDS_SI_RoutineControl
                parametersOfService = New Object(2) {}
                parametersOfService(0) = TryCast(comboBoxFirstServiceEnum.SelectedItem, ComboBoxItem).Data
                parametersOfService(1) = numericUpDownSecondServiceNumber.Value

                If ConvertFirstBufferInputToArray(bufferByteInput) Then
                    parametersOfService(2) = bufferByteInput
                Else
                    parametersOfService = Nothing
                End If

            Case TPUDSService.PUDS_SI_ECUReset
                parametersOfService = New Object(0) {}
                parametersOfService(0) = TryCast(comboBoxFirstServiceEnum.SelectedItem, ComboBoxItem).Data
        End Select

        If parametersOfService Is Nothing Then Return Nothing
        Return New ServiceInformation(service, parametersOfService, netAddrInfo, Not checkBoxSendTesterPresent.Checked, numericUpDownPriority.Value)
    End Function

    Private Function ConvertFirstBufferInputToArray(<Out> ByRef bufferInput As UShort()) As Boolean
        If textBoxFirstServiceBuffer.Text.Length = 0 Then
            bufferInput = New UShort(-1) {}
            Return True
        End If

        Dim temp = textBoxFirstServiceBuffer.Text.Split(","c)
        bufferInput = New UShort(temp.Length - 1) {}
        Dim result As UShort = Nothing

        For i = 0 To temp.Length - 1

            If TPUDSCANHandle.TryParse(temp(i), NumberStyles.HexNumber, Nothing, result) Then
                bufferInput(i) = result
            Else
                Return False
            End If
        Next

        Return True
    End Function

    Private Function ConvertFirstBufferInputToArray(<Out> ByRef bufferInput As Byte()) As Boolean
        If textBoxFirstServiceBuffer.Text.Length = 0 Then
            bufferInput = New Byte(-1) {}
            Return True
        End If

        Dim temp = textBoxFirstServiceBuffer.Text.Split(","c)
        bufferInput = New Byte(temp.Length - 1) {}
        Dim result As Byte = Nothing

        For i = 0 To temp.Length - 1

            If Byte.TryParse(temp(i), NumberStyles.HexNumber, Nothing, result) Then
                bufferInput(i) = result
            Else
                Return False
            End If
        Next

        Return True
    End Function

    Private Function ConvertSecondBufferInputToArray(<Out> ByRef bufferInput As Byte()) As Boolean
        If textBoxSecondServiceBuffer.Text.Length = 0 Then
            bufferInput = New Byte(-1) {}
            Return True
        End If

        Dim temp = textBoxSecondServiceBuffer.Text.Split(","c)
        bufferInput = New Byte(temp.Length - 1) {}
        Dim result As Byte = Nothing

        For i = 0 To temp.Length - 1

            If Byte.TryParse(temp(i), NumberStyles.HexNumber, Nothing, result) Then
                bufferInput(i) = result
            Else
                Return False
            End If
        Next

        Return True
    End Function

    Private Sub SendServiceAndWaitForResponse(ByVal sender As Object, ByVal e As DoWorkEventArgs)
        If e.Argument Is Nothing Then
            e.Result = -1
        ElseIf Not mApiUser.SendService(CType(e.Argument, ServiceInformation)) Then
            e.Result = -2
        Else

            If mApiUser.WaitForResponse Then
                e.Result = 1
            Else
                e.Result = 0
            End If
        End If
    End Sub

    Private Sub HandleResponse(ByVal sender As Object, ByVal e As RunWorkerCompletedEventArgs)
        Select Case e.Result
            Case -1
                MessageBox.Show("Wrong buffer input was given.", "Error")
            Case -2
                mApiUser.ShowResponseError()
            Case 0
                mApiUser.ShowResponseError()
            Case 1

                If mApiUser.RequestIsFunctional Then
                    ShowResponse(mApiUser.FunctionalResponses, mApiUser.ReceivedFunctionalResponses)
                Else
                    ShowResponse(mApiUser.Response)
                End If
        End Select

        buttonSend.Text = "Send"
        buttonSend.Enabled = True
    End Sub

    Private Sub ShowResponse(ByVal response As TPUDSMsg)
        ShowResponse(New TPUDSMsg() {response}, 1)
    End Sub

    Private Sub ShowResponse(ByVal responses As TPUDSMsg(), ByVal amountOfResponses As UInteger)
        listViewResponse.BeginUpdate()

        For i As Integer = 0 To amountOfResponses - 1
            AddResponseToList(responses(i))
        Next

        listViewResponse.EndUpdate()
    End Sub

    Private Sub AddResponseToList(ByVal response As TPUDSMsg)
        Dim responseInformation = New ResponseInformation(response)

        If Not mResponsesReceived.Contains(responseInformation) Then
            mResponsesReceived.Add(responseInformation)
        Else
            Dim index = mResponsesReceived.IndexOf(responseInformation)
            mResponsesReceived(index).Count += 1
            responseInformation.Count = mResponsesReceived(index).Count
        End If

        Dim itemFound = False

        For Each item As ListViewItem In listViewResponse.Items

            If responseInformation.Equals(item.Tag) Then
                item.SubItems(6).Text = responseInformation.ResultText
                item.SubItems(7).Text = responseInformation.CountText
                item.SubItems(8).Text = responseInformation.LengthText
                item.SubItems(9).Text = responseInformation.DataText
                itemFound = True
                Exit For
            End If
        Next

        If Not itemFound Then
            Dim viewItem = New ListViewItem(responseInformation.SourceText)
            viewItem.SubItems.Add(responseInformation.TargetText)
            viewItem.SubItems.Add(responseInformation.RemoteText)
            viewItem.SubItems.Add(responseInformation.TargetTypeText)
            viewItem.SubItems.Add(responseInformation.ProtocolText)
            viewItem.SubItems.Add(responseInformation.ServiceIdentifierText)
            viewItem.SubItems.Add(responseInformation.ResultText)
            viewItem.SubItems.Add(responseInformation.CountText)
            viewItem.SubItems.Add(responseInformation.LengthText)
            viewItem.SubItems.Add(responseInformation.DataText)
            viewItem.Tag = responseInformation
            listViewResponse.Items.Add(viewItem)
        End If
    End Sub

    Private Sub buttonReceive_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonReceive.Click
        If Not mRecevieUUDTWorker.IsBusy Then
            mRecevieUUDTWorker.RunWorkerAsync(CType(TryCast(comboBoxMappings.SelectedItem, ComboBoxItem).Data, MappingInformation))
            buttonReceive.Text = "Stop"
        Else
            mRecevieUUDTWorker.CancelAsync()
            buttonReceive.Text = "Receive"
        End If
    End Sub

    Private Sub ReceiveUUDT(ByVal sender As Object, ByVal e As DoWorkEventArgs)
        Dim worker = TryCast(sender, BackgroundWorker)
        e.Result = 0

        Do

            If mApiUser.ReceiveUUDT(CType(e.Argument, MappingInformation)) Then
                e.Result = 1
                Exit Do
            ElseIf mApiUser.UUDTError Then
                e.Result = -1
                Exit Do
            End If

            Threading.Thread.Sleep(100)
        Loop While Not worker.CancellationPending
    End Sub

    Private Sub EndReceiveUUDT(ByVal sender As Object, ByVal e As RunWorkerCompletedEventArgs)
        If CInt(e.Result) = 1 Then ShowResponse(mApiUser.UUDTResponse)
        If CInt(e.Result) = -1 Then mApiUser.ShowResponseError(True)
        buttonReceive.Text = "Receive"
    End Sub

    Private Sub comboBoxMappings_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles comboBoxMappings.SelectedIndexChanged
        EnableSendGroupbox()
    End Sub
    Private Sub EnableSendGroupbox()
        Dim information = CType(TryCast(comboBoxMappings.SelectedItem, ComboBoxItem).Data, MappingInformation)

        If Not mServiceHandler.IsBusy Then

            If information.NetAddressInformation.SA <> mApiUser.LocalNodeAddress AndAlso Not information.IsFixedCanIdprotocol Then
                buttonSend.Enabled = False
            Else
                buttonSend.Enabled = mApiUser.IsConnected
            End If
        End If

        If information.IsUUDT Then
            mMappingIsUUDT = True
            buttonReceive.Visible = True

            If information.TargetAddress = mApiUser.LocalNodeAddress OrElse information.SourceAddress = mApiUser.LocalNodeAddress Then
                buttonReceive.Enabled = True
            Else
                buttonReceive.Enabled = False
            End If

            labelPriority.Visible = False
            numericUpDownPriority.Visible = False
            labelService.Visible = False
            comboBoxServiceToSend.Visible = False
            labelFirstServiceEnum.Visible = False
            comboBoxFirstServiceEnum.Visible = False
            labelSecondServiceEnum.Visible = False
            comboBoxSecondServiceEnum.Visible = False
            labelSecondServiceNumber.Visible = False
            numericUpDownSecondServiceNumber.Visible = False
            labelSecondServiceBuffer.Visible = False
            labelFirstServiceBufferHint.Visible = False
            textBoxSecondServiceBuffer.Visible = False
            checkBoxSendTesterPresent.Visible = False
            labelFirstServiceNumber.Text = "DLC"
            labelFirstServiceNumber.Visible = True
            numericUpDownFirstServiceNumber.Visible = True
            numericUpDownFirstServiceNumber.Maximum = 8
            labelFirstServiceBuffer.Text = "Data of message"
            labelFirstServiceBuffer.Visible = True
            labelFirstServiceBufferHint.Visible = True
            textBoxFirstServiceBuffer.Visible = True
            numericUpDownTargetAddr.Value = information.TargetAddress
            numericUpDownRemoteAddr.Value = information.RemoteAddress
            textBoxSourceAddress.Text = information.SourceAddress.ToString("X")
            numericUpDownTargetAddr.Enabled = False
            numericUpDownRemoteAddr.Enabled = False

            If information.SourceAddress <> mApiUser.LocalNodeAddress Then
                textBoxSourceAddress.BackColor = Drawing.Color.Red
            Else
                textBoxSourceAddress.BackColor = Drawing.SystemColors.Control
            End If

            Return
        Else
            mMappingIsUUDT = False
            buttonReceive.Visible = False
            labelService.Visible = True
            comboBoxServiceToSend.Visible = True
            ComboBoxServiceToSend_SelectedIndexChanged(Nothing, EventArgs.Empty)
        End If

        If Not information.IsFixedCanIdprotocol Then
            numericUpDownTargetAddr.Value = information.TargetAddress
            numericUpDownRemoteAddr.Value = information.RemoteAddress
            textBoxSourceAddress.Text = information.SourceAddress.ToString("X")

            If information.SourceAddress <> mApiUser.LocalNodeAddress Then
                textBoxSourceAddress.BackColor = Drawing.Color.Red
            Else
                textBoxSourceAddress.BackColor = Drawing.SystemColors.Control
            End If
        End If

        numericUpDownTargetAddr.Enabled = information.IsFixedCanIdprotocol
        numericUpDownRemoteAddr.Enabled = information.IsFixedCanIdprotocol
        labelPriority.Visible = information.IsFixedCanIdprotocol
        numericUpDownPriority.Visible = information.IsFixedCanIdprotocol
    End Sub

    Private Sub comboBoxFirstServiceEnum_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles comboBoxFirstServiceEnum.SelectedIndexChanged
        If mServiceHandler.IsBusy Then Return
        Dim service As TPUDSService = TryCast(comboBoxServiceToSend.SelectedItem, ComboBoxItem).Data

        If service = TPUDSService.PUDS_SI_DiagnosticSessionControl Then
            Dim sessionType As TPUDSSvcParamDSC = TryCast(comboBoxFirstServiceEnum.SelectedItem, ComboBoxItem).Data
            checkBoxSendTesterPresent.Enabled = sessionType <> TPUDSSvcParamDSC.PUDS_SVC_PARAM_DSC_DS
        End If
    End Sub

    Private Sub ComboBoxSecondServiceEnum_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles comboBoxSecondServiceEnum.SelectedIndexChanged
        Dim service As TPUDSService = TryCast(comboBoxServiceToSend.SelectedItem, ComboBoxItem).Data

        If service = TPUDSService.PUDS_SI_RoutineControl Then
            Dim item = TryCast(comboBoxSecondServiceEnum.SelectedItem, ComboBoxItem)
            If CUShort(item.Data) <> 0 AndAlso numericUpDownSecondServiceNumber.Value <> CUShort(item.Data) Then numericUpDownSecondServiceNumber.Value = CUShort(item.Data)
        ElseIf service = TPUDSService.PUDS_SI_CommunicationControl Then
            Dim item = TryCast(comboBoxSecondServiceEnum.SelectedItem, ComboBoxItem)
            If CByte(item.Data) <> 0 AndAlso numericUpDownSecondServiceNumber.Value <> CByte(item.Data) Then numericUpDownSecondServiceNumber.Value = CByte(item.Data)
        End If
    End Sub

    Private Sub NumericUpDownSecondServiceNumber_ValueChanged(ByVal sender As Object, ByVal e As EventArgs) Handles numericUpDownSecondServiceNumber.ValueChanged
        If mServiceHandler.IsBusy Then Return
        Dim service As TPUDSService = TryCast(comboBoxServiceToSend.SelectedItem, ComboBoxItem).Data

        If service = TPUDSService.PUDS_SI_RoutineControl Then
            Dim valueFound = False

            For Each comboboxItem As ComboBoxItem In comboBoxSecondServiceEnum.Items

                If CUShort(comboboxItem.Data) = numericUpDownSecondServiceNumber.Value Then
                    comboBoxSecondServiceEnum.SelectedItem = comboboxItem
                    valueFound = True
                End If
            Next

            If Not valueFound Then comboBoxSecondServiceEnum.SelectedIndex = comboBoxSecondServiceEnum.Items.Count - 1
            Dim item = TryCast(comboBoxSecondServiceEnum.SelectedItem, ComboBoxItem)
            If CUShort(item.Data) <> 0 Then numericUpDownSecondServiceNumber.Value = CUShort(item.Data)
        ElseIf service = TPUDSService.PUDS_SI_CommunicationControl Then
            Dim valueFound = False

            For Each comboboxItem As ComboBoxItem In comboBoxSecondServiceEnum.Items

                If CByte(comboboxItem.Data) = numericUpDownSecondServiceNumber.Value Then
                    comboBoxSecondServiceEnum.SelectedItem = comboboxItem
                    valueFound = True
                End If
            Next

            If Not valueFound Then comboBoxSecondServiceEnum.SelectedIndex = comboBoxSecondServiceEnum.Items.Count - 1
            Dim item = TryCast(comboBoxSecondServiceEnum.SelectedItem, ComboBoxItem)
            If CByte(item.Data) <> 0 Then numericUpDownSecondServiceNumber.Value = CByte(item.Data)
        End If
    End Sub

    Private Sub contextMenuReset_Click(ByVal sender As Object, ByVal e As EventArgs) Handles contextMenuReset.Click
        mApiUser.ResetHardware()
        mResponsesReceived.Clear()
        listViewResponse.Items.Clear()
    End Sub
End Class

Public Class ComboBoxItem
    Public Property Data As Object
    Public Property Text As String

    Public Sub New(ByVal textInput As String, ByVal dataInput As Object)
        Text = textInput
        Data = dataInput
    End Sub

    Public Overrides Function ToString() As String
        Return Text
    End Function
End Class

Public Class ServiceInformation
    Private _Service As TPUDSService, _ParametersOfService As Object(), _NetAddressInformation As TPUDSNetAddrInfo, _DisableTesterPresent As Boolean, _Priority As Byte

    Public Property Service As TPUDSService
        Get
            Return _Service
        End Get
        Private Set(ByVal value As TPUDSService)
            _Service = value
        End Set
    End Property

    Public Property ParametersOfService As Object()
        Get
            Return _ParametersOfService
        End Get
        Private Set(ByVal value As Object())
            _ParametersOfService = value
        End Set
    End Property

    Public Property NetAddressInformation As TPUDSNetAddrInfo
        Get
            Return _NetAddressInformation
        End Get
        Private Set(ByVal value As TPUDSNetAddrInfo)
            _NetAddressInformation = value
        End Set
    End Property

    Public Property DisableTesterPresent As Boolean
        Get
            Return _DisableTesterPresent
        End Get
        Private Set(ByVal value As Boolean)
            _DisableTesterPresent = value
        End Set
    End Property

    Public Property Priority As Byte
        Get
            Return _Priority
        End Get
        Private Set(ByVal value As Byte)
            _Priority = value
        End Set
    End Property

    Public Sub New(ByVal serviceInput As TPUDSService, ByVal parametersOfServiceInput As Object(), ByVal netAddrInfo As TPUDSNetAddrInfo, ByVal Optional disableTesterPresentInput As Boolean = False, ByVal Optional priorityInput As Byte = 6)
        Service = serviceInput
        ParametersOfService = parametersOfServiceInput
        NetAddressInformation = netAddrInfo
        DisableTesterPresent = disableTesterPresentInput
        Priority = priorityInput
    End Sub
End Class

Public Class MappingInformation
    Private mPointer As IntPtr
    Private mMessage As TPUDSMsg
    Private mSourceAddress As Byte
    Private mTargetAddress As Byte
    Private mRemoteAddress As Byte
    Private mTargetType As TPUDSAddressingType
    Private mProtocol As TPUDSProtocol
    Private mNetAddressInformation As TPUDSNetAddrInfo
    Public Property CanId As UInteger
    Public Property ResponseCanId As UInteger

    Public Property SourceAddress As Byte
        Get
            Return mSourceAddress
        End Get
        Set(ByVal value As Byte)
            mSourceAddress = value
            mNetAddressInformation.SA = mSourceAddress
        End Set
    End Property

    Public Property TargetAddress As Byte
        Get
            Return mTargetAddress
        End Get
        Set(ByVal value As Byte)
            mTargetAddress = value
            mNetAddressInformation.TA = mTargetAddress
        End Set
    End Property

    Public Property RemoteAddress As Byte
        Get
            Return mRemoteAddress
        End Get
        Set(ByVal value As Byte)
            mRemoteAddress = value
            mNetAddressInformation.RA = mRemoteAddress
        End Set
    End Property

    Public Property TargetType As TPUDSAddressingType
        Get
            Return mTargetType
        End Get
        Set(ByVal value As TPUDSAddressingType)
            mTargetType = value
            mNetAddressInformation.TA_TYPE = mTargetType
        End Set
    End Property

    Public Property Protocol As TPUDSProtocol
        Get
            Return mProtocol
        End Get
        Set(ByVal value As TPUDSProtocol)
            mProtocol = value
            mNetAddressInformation.PROTOCOL = mProtocol
        End Set
    End Property

    Public ReadOnly Property NetAddressInformation As TPUDSNetAddrInfo
        Get
            Return mNetAddressInformation
        End Get
    End Property

    Public ReadOnly Property MappingPointer As IntPtr
        Get
            mMessage.NETADDRINFO = NetAddressInformation

            If IsUUDT Then
                mMessage.LEN = 4
            Else
                mMessage.LEN = 8
            End If

            mMessage.DATA(0) = CByte(CanId >> 24 And 255)
            mMessage.DATA(1) = CByte(CanId >> 16 And 255)
            mMessage.DATA(2) = CByte(CanId >> 8 And 255)
            mMessage.DATA(3) = CByte(CanId And 255)

            If Not IsUUDT Then
                mMessage.DATA(4) = CByte(ResponseCanId >> 24 And 255)
                mMessage.DATA(5) = CByte(ResponseCanId >> 16 And 255)
                mMessage.DATA(6) = CByte(ResponseCanId >> 8 And 255)
                mMessage.DATA(7) = CByte(ResponseCanId And 255)
            End If

            Marshal.StructureToPtr(mMessage, mPointer, False)
            Return mPointer
        End Get
    End Property

    Public ReadOnly Property MappingPointerRemoval As IntPtr
        Get
            mMessage.NETADDRINFO = NetAddressInformation
            mMessage.LEN = 4
            mMessage.DATA(0) = CByte(CanId >> 24 And 255)
            mMessage.DATA(1) = CByte(CanId >> 16 And 255)
            mMessage.DATA(2) = CByte(CanId >> 8 And 255)
            mMessage.DATA(3) = CByte(CanId And 255)
            Marshal.StructureToPtr(mMessage, mPointer, False)
            Return mPointer
        End Get
    End Property

    Public ReadOnly Property PointerSize As UInteger
        Get
            Return Marshal.SizeOf(mMessage)
        End Get
    End Property

    Public ReadOnly Property CanIdString As String
        Get

            If Not ProtocolIsDetachedFromIdsAndAddresses(Protocol) Then
                Return GetCanIdString(CanId, ProtocolIs29Bit(Protocol))
            Else
                Return "-"
            End If
        End Get
    End Property

    Public ReadOnly Property ResponseCanIdString As String
        Get

            If Not ProtocolIsDetachedFromIdsAndAddresses(Protocol) AndAlso TargetType <> TPUDSAddressingType.PUDS_ADDRESSING_FUNCTIONAL AndAlso Not IsUUDT Then
                Return GetCanIdString(ResponseCanId, ProtocolIs29Bit(Protocol))
            Else
                Return "-"
            End If
        End Get
    End Property

    Public ReadOnly Property TargetTypeString As String
        Get
            Return [Enum].GetName(GetType(TPUDSAddressingType), TargetType)
        End Get
    End Property

    Public ReadOnly Property TargetTypeShortString As String
        Get
            Return GetTargetTypeString(TargetType)
        End Get
    End Property

    Public ReadOnly Property ProtocolString As String
        Get
            Return [Enum].GetName(GetType(TPUDSProtocol), Protocol)
        End Get
    End Property

    Public ReadOnly Property ProtocolShortString As String
        Get
            Return GetProtocolString(Protocol)
        End Get
    End Property

    Public ReadOnly Property SourceAddressString As String
        Get

            If Not ProtocolIsDetachedFromIdsAndAddresses(Protocol) Then
                Return SourceAddress.ToString("X2") & "h"
            Else
                Return "-"
            End If
        End Get
    End Property

    Public ReadOnly Property TargetAddressString As String
        Get

            If Not ProtocolIsDetachedFromIdsAndAddresses(Protocol) Then
                Return TargetAddress.ToString("X2") & "h"
            Else
                Return "-"
            End If
        End Get
    End Property

    Public ReadOnly Property RemoteAddressString As String
        Get

            If Not ProtocolIsDetachedFromIdsAndAddresses(Protocol) Then
                Return RemoteAddress.ToString("X2") & "h"
            Else
                Return "-"
            End If
        End Get
    End Property

    Public ReadOnly Property IsTwoWayString As String
        Get
            If ProtocolIsDetachedFromIdsAndAddresses(Protocol) OrElse TargetType = TPUDSAddressingType.PUDS_ADDRESSING_FUNCTIONAL OrElse IsUUDT Then Return "-"
            If IsTwoWay Then Return Boolean.TrueString
            Return Boolean.FalseString
        End Get
    End Property

    Public ReadOnly Property Name As String
        Get
            If ProtocolIsDetachedFromIdsAndAddresses(Protocol) Then Return ProtocolShortString & ", " & TargetTypeShortString
            If IsUUDT Then Return ProtocolShortString & " (UUDT): Can ID = " & CanIdString
            If IsRemote Then Return ProtocolShortString & ", " & TargetTypeShortString & ": " & SourceAddressString & " -> " & RemoteAddressString & " (remote)"
            Return ProtocolShortString & ", " & TargetTypeShortString & ": " & SourceAddressString & " -> " & TargetAddressString
        End Get
    End Property

    Public ReadOnly Property IsRemote As Boolean
        Get
            Return ProtocolIsRemote(Protocol)
        End Get
    End Property

    Public Property IsTwoWay As Boolean
    'No mapping needs to be/can be added for protocols with fixed CAN IDs, they are only represented as MappingInformation to simplify data transactions within the application.
    Public ReadOnly Property IsFixedCanIdprotocol As Boolean
        Get
            Return ProtocolIsDetachedFromIdsAndAddresses(Protocol)
        End Get
    End Property

    Public ReadOnly Property IsUUDT As Boolean
        Get
            Return mProtocol = TPUDSProtocol.PUDS_PROTOCOL_NONE
        End Get
    End Property

    Public Sub New(ByVal Optional isTwoWaylocal As Boolean = False)
        mMessage = New TPUDSMsg
        mMessage.DATA = New Byte(4094) {}
        IsTwoWay = isTwoWaylocal
        mPointer = Marshal.AllocHGlobal(Marshal.SizeOf(mMessage))
    End Sub

    Public Sub New(ByVal canIdInput As UInteger, ByVal responseCanIdInput As UInteger, ByVal sourceAddressInput As Byte, ByVal targetAddressInput As Byte, ByVal remoteAddressInput As Byte, ByVal targetTypeInput As TPUDSAddressingType, ByVal protocolInput As TPUDSProtocol, ByVal Optional IsTwoWay As Boolean = False)
        Me.New(IsTwoWay)
        CanId = canIdInput
        ResponseCanId = responseCanIdInput
        SourceAddress = sourceAddressInput
        TargetAddress = targetAddressInput
        RemoteAddress = remoteAddressInput
        TargetType = targetTypeInput
        Protocol = protocolInput
    End Sub

    Public Sub New(ByVal targetTypeInput As TPUDSAddressingType, ByVal protocolInput As TPUDSProtocol)
        Me.New(False)
        TargetType = targetTypeInput
        Protocol = protocolInput
        CanId = 0
        ResponseCanId = 0
        SourceAddress = 0
        TargetAddress = 0
        RemoteAddress = 0
    End Sub

    Protected Overrides Sub Finalize()
        Marshal.FreeHGlobal(mPointer)
    End Sub

    Public Function Backwards() As MappingInformation
        Return New MappingInformation(ResponseCanId, CanId, TargetAddress, SourceAddress, RemoteAddress, TargetType, Protocol)
    End Function

    Public Overrides Function Equals(ByVal obj As Object) As Boolean
        Dim info = TryCast(obj, MappingInformation)
        If info Is Nothing Then Return False
        If ProtocolIsDetachedFromIdsAndAddresses(Protocol) Then Return SourceAddress = info.SourceAddress AndAlso TargetAddress = info.TargetAddress AndAlso RemoteAddress = info.RemoteAddress AndAlso TargetType = info.TargetType AndAlso Protocol = info.Protocol
        Return CanId = info.CanId AndAlso ResponseCanId = info.ResponseCanId AndAlso SourceAddress = info.SourceAddress AndAlso TargetAddress = info.TargetAddress AndAlso RemoteAddress = info.RemoteAddress AndAlso TargetType = info.TargetType AndAlso Protocol = info.Protocol
    End Function

    Public Overrides Function GetHashCode() As Integer
        Dim hashCode = -1246325849
        hashCode = hashCode * -1521134295 + CanId.GetHashCode
        hashCode = hashCode * -1521134295 + ResponseCanId.GetHashCode
        hashCode = hashCode * -1521134295 + SourceAddress.GetHashCode
        hashCode = hashCode * -1521134295 + TargetAddress.GetHashCode
        hashCode = hashCode * -1521134295 + RemoteAddress.GetHashCode
        hashCode = hashCode * -1521134295 + TargetType.GetHashCode
        hashCode = hashCode * -1521134295 + Protocol.GetHashCode
        Return hashCode
    End Function
End Class

Public Class ResponseInformation
    Private _Response As TPUDSMsg

    Public Property Response As TPUDSMsg
        Get
            Return _Response
        End Get
        Private Set(ByVal value As TPUDSMsg)
            _Response = value
        End Set
    End Property

    Public ReadOnly Property SourceText As String
        Get
            Return Response.NETADDRINFO.SA.ToString("X2")
        End Get
    End Property

    Public ReadOnly Property TargetText As String
        Get
            Return Response.NETADDRINFO.TA.ToString("X2")
        End Get
    End Property

    Public ReadOnly Property RemoteText As String
        Get
            Return Response.NETADDRINFO.RA.ToString("X2")
        End Get
    End Property

    Public ReadOnly Property TargetTypeText As String
        Get
            Return [Enum].GetName(GetType(TPUDSAddressingType), Response.NETADDRINFO.TA_TYPE)
        End Get
    End Property

    Public ReadOnly Property ProtocolText As String
        Get
            Return [Enum].GetName(GetType(TPUDSProtocol), Response.NETADDRINFO.PROTOCOL)
        End Get
    End Property

    Public ReadOnly Property ServiceIdentifierText As String
        Get
            Return If(Response.NETADDRINFO.PROTOCOL = TPUDSProtocol.PUDS_PROTOCOL_NONE, "- (UUDT Response)", Response.ServiceID.ToString("X2"))
        End Get
    End Property

    Public ReadOnly Property ResultText As String
        Get
            Return [Enum].GetName(GetType(TPUDSServiceResult), Response.RESULT)
        End Get
    End Property

    Public ReadOnly Property CountText As String
        Get
            Return Count.ToString
        End Get
    End Property

    Public ReadOnly Property LengthText As String
        Get
            Return Response.LEN.ToString
        End Get
    End Property

    Public ReadOnly Property DataText As String
        Get
            Dim data = ""

            For i = 0 To Response.LEN - 1
                data += Response.DATA(i).ToString("X2") & " "
            Next

            Return data
        End Get
    End Property

    Public Property Count As Integer

    Public Sub New(ByVal responseInput As TPUDSMsg)
        Response = responseInput
        Count = 1
    End Sub

    Public Overrides Function Equals(ByVal obj As Object) As Boolean
        Dim information As ResponseInformation = Nothing
        Return CSharpImpl.__Assign(information, TryCast(obj, ResponseInformation)) IsNot Nothing AndAlso EqualityComparer(Of TPUDSNetAddrInfo).Default.Equals(Response.NETADDRINFO, information.Response.NETADDRINFO) AndAlso Response.MSGTYPE = information.Response.MSGTYPE AndAlso (Response.ServiceID = information.Response.ServiceID OrElse Response.NETADDRINFO.PROTOCOL = information.Response.NETADDRINFO.PROTOCOL AndAlso Response.NETADDRINFO.PROTOCOL = TPUDSProtocol.PUDS_PROTOCOL_NONE)
    End Function

    Private Class CSharpImpl
        <Obsolete("Please refactor calling code to use normal Visual Basic assignment")>
        Shared Function __Assign(Of T)(ByRef target As T, value As T) As T
            target = value
            Return value
        End Function
    End Class
End Class

Public Module UdsExampleUtils
    Public ReadOnly AllChannelHandles = {UDSApi.PUDS_NONEBUS, UDSApi.PUDS_ISABUS1, UDSApi.PUDS_ISABUS2, UDSApi.PUDS_ISABUS3, UDSApi.PUDS_ISABUS4, UDSApi.PUDS_ISABUS5, UDSApi.PUDS_ISABUS6, UDSApi.PUDS_ISABUS7, UDSApi.PUDS_ISABUS8, UDSApi.PUDS_DNGBUS1, UDSApi.PUDS_PCIBUS1, UDSApi.PUDS_PCIBUS2, UDSApi.PUDS_PCIBUS3, UDSApi.PUDS_PCIBUS4, UDSApi.PUDS_PCIBUS5, UDSApi.PUDS_PCIBUS6, UDSApi.PUDS_PCIBUS7, UDSApi.PUDS_PCIBUS8, UDSApi.PUDS_PCIBUS9, UDSApi.PUDS_PCIBUS10, UDSApi.PUDS_PCIBUS11, UDSApi.PUDS_PCIBUS12, UDSApi.PUDS_PCIBUS13, UDSApi.PUDS_PCIBUS14, UDSApi.PUDS_PCIBUS15, UDSApi.PUDS_PCIBUS16, UDSApi.PUDS_USBBUS1, UDSApi.PUDS_USBBUS2, UDSApi.PUDS_USBBUS3, UDSApi.PUDS_USBBUS4, UDSApi.PUDS_USBBUS5, UDSApi.PUDS_USBBUS6, UDSApi.PUDS_USBBUS7, UDSApi.PUDS_USBBUS8, UDSApi.PUDS_USBBUS9, UDSApi.PUDS_USBBUS10, UDSApi.PUDS_USBBUS11, UDSApi.PUDS_USBBUS12, UDSApi.PUDS_USBBUS13, UDSApi.PUDS_USBBUS14, UDSApi.PUDS_USBBUS15, UDSApi.PUDS_USBBUS16, UDSApi.PUDS_PCCBUS1, UDSApi.PUDS_PCCBUS2, UDSApi.PUDS_LANBUS1, UDSApi.PUDS_LANBUS2, UDSApi.PUDS_LANBUS3, UDSApi.PUDS_LANBUS4, UDSApi.PUDS_LANBUS5, UDSApi.PUDS_LANBUS6, UDSApi.PUDS_LANBUS7, UDSApi.PUDS_LANBUS8, UDSApi.PUDS_LANBUS9, UDSApi.PUDS_LANBUS10, UDSApi.PUDS_LANBUS11, UDSApi.PUDS_LANBUS12, UDSApi.PUDS_LANBUS13, UDSApi.PUDS_LANBUS14, UDSApi.PUDS_LANBUS15, UDSApi.PUDS_LANBUS16}

    ''' <summary>
    ''' Represents a PCAN device
    ''' </summary>
    Public Enum TPCANDevice As Byte
        ''' <summary>
        ''' Undefined, unknown or not selected PCAN device value
        ''' </summary>
        PCAN_NONE = 0
        ''' <summary>
        ''' PCAN Non-Plug and Play devices. NOT USED WITHIN PCAN-Basic API
        ''' </summary>
        PCAN_PEAKCAN = 1
        ''' <summary>
        ''' PCAN-ISA, PCAN-PC/104, and PCAN-PC/104-Plus
        ''' </summary>
        PCAN_ISA = 2
        ''' <summary>
        ''' PCAN-Dongle
        ''' </summary>
        PCAN_DNG = 3
        ''' <summary>
        ''' PCAN-PCI, PCAN-cPCI, PCAN-miniPCI, and PCAN-PCI Express
        ''' </summary>
        PCAN_PCI = 4
        ''' <summary>
        ''' PCAN-USB and PCAN-USB Pro
        ''' </summary>
        PCAN_USB = 5
        ''' <summary>
        ''' PCAN-PC Card
        ''' </summary>
        PCAN_PCC = 6
        ''' <summary>
        ''' PCAN Virtual hardware. NOT USED WITHIN PCAN-Basic API
        ''' </summary>
        PCAN_VIRTUAL = 7
        ''' <summary>
        ''' PCAN Gateway devices
        ''' </summary>
        PCAN_LAN = 8
    End Enum

    Function ProtocolIs29Bit(ByVal protocol As TPUDSProtocol) As Boolean
        Return protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B OrElse protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_REMOTE OrElse protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_3_29B OrElse protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_NORMAL OrElse protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_EXTENDED
    End Function

    Function ProtocolIsRemote(ByVal protocol As TPUDSProtocol) As Boolean
        Return protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B_REMOTE OrElse protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_REMOTE
    End Function

    Function ProtocolIsDetachedFromIdsAndAddresses(ByVal protocol As TPUDSProtocol) As Boolean
        Return protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B OrElse protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_REMOTE OrElse protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_3_29B
    End Function

    Function GetHardwareChannelName(ByVal handle As TPUDSCANHandle) As String
        Dim device As TPCANDevice
        Dim channel As Integer

        If handle < 256 Then
            device = CType(handle >> 4, TPCANDevice)
            channel = handle And 15
        Else
            device = CType(handle >> 8, TPCANDevice)
            channel = handle And 255
        End If

        Return String.Format("{0} {1} ({2:X2}h)", device, channel, handle)
    End Function

    Function GetBitrateString(ByVal baudrate As TPUDSBaudrate) As String
        Select Case baudrate
            Case TPUDSBaudrate.PUDS_BAUD_1M
                Return "1 MBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_800K
                Return "800 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_500K
                Return "500 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_250K
                Return "250 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_125K
                Return "125 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_100K
                Return "100 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_95K
                Return "95,238 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_83K
                Return "83,333 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_50K
                Return "50 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_47K
                Return "47,619 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_33K
                Return "33,333 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_20K
                Return "20 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_10K
                Return "10 kBit/s"
            Case TPUDSBaudrate.PUDS_BAUD_5K
                Return "5 kBit/s"
        End Select

        Return baudrate.ToString
    End Function

    Function GetCanIdString(ByVal id As UInteger, ByVal isExtended As Boolean) As String
        If isExtended Then
            Return id.ToString("X8") & "h"
        Else
            Return id.ToString("X3") & "h"
        End If
    End Function

    Function GetProtocolString(ByVal protocol As TPUDSProtocol) As String
        Select Case protocol
            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B
                Return "11bit normal"
            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B_REMOTE
                Return "11bit mixed,remote"
            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B
                Return "29bit fixed normal"
            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_REMOTE
                Return "29bit mixed,remote"
            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_3_29B
                Return "29bit enhanced diagnostic"
            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_NORMAL
                Return "29bit normal"
            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_11B_EXTENDED
                Return "11bit mixed,remote"
            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_EXTENDED
                Return "29bit enhanced diagnostic"
            Case Else
                Return "no protocol"
        End Select
    End Function

    Function GetTargetTypeString(ByVal addressingType As TPUDSAddressingType) As String
        Select Case addressingType
            Case TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL
                Return "physical addressing"
            Case TPUDSAddressingType.PUDS_ADDRESSING_FUNCTIONAL
                Return "functional addressing"
            Case Else
                Return ""
        End Select
    End Function

    Private Class CSharpImpl
        <Obsolete("Please refactor calling code to use normal Visual Basic assignment")>
        Shared Function __Assign(Of T)(ByRef target As T, value As T) As T
            target = value
            Return value
        End Function
    End Class
End Module
