﻿Imports System
Imports System.Drawing
Imports System.Windows.Forms
Imports PcanUdsSampleVisualBasic.Peak.Can.Uds

Partial Friend Class FormMapping
    Inherits Form

    Private _MappingInformation As MappingInformation

    Public Property MappingInformation As MappingInformation
        Get
            Return _MappingInformation
        End Get
        Private Set(ByVal value As MappingInformation)
            _MappingInformation = value
        End Set
    End Property

    Private mSourceAddress As UInteger
    Private mFixedCanId As Boolean
    Private Const FixedCanAddressExplanation = "This protocol type has a fixed CAN ID, which is influenced by the source and target addresses and the priority used for the communication." & "Because the CAN IDs are always the same, they can not be added as mapping." & "The addresses and priority can be chosen anew for every service send in the ""Service"" tab.\n"
    Private Const TwoDigitAddresses = "XX and YY are the target and source addresses, respectivly."
    Private Const ThreeDigitAddresses = "XXX and YYY are the target and source addresses, respectivly."

    Public Sub New(ByVal source As UInteger)
        mFixedCanId = False
        mSourceAddress = source
        MappingInformation = New MappingInformation
        InitializeComponent()
        textBoxLocalAddress.Text = mSourceAddress.ToString("X")

        For Each protocol As TPUDSProtocol In [Enum].GetValues(GetType(TPUDSProtocol))
            If Not ProtocolIsDetachedFromIdsAndAddresses(protocol) Then comboBoxProtocol.Items.Add(New ComboBoxItem([Enum].GetName(GetType(TPUDSProtocol), protocol), protocol))
        Next

        comboBoxProtocol.Items.Add(New ComboBoxItem("----- undefinable mappings -----", Nothing))

        For Each protocol As TPUDSProtocol In [Enum].GetValues(GetType(TPUDSProtocol))
            If ProtocolIsDetachedFromIdsAndAddresses(protocol) Then comboBoxProtocol.Items.Add(New ComboBoxItem([Enum].GetName(GetType(TPUDSProtocol), protocol), protocol))
        Next

        For Each addressingType As TPUDSAddressingType In [Enum].GetValues(GetType(TPUDSAddressingType))
            comboBoxTargetType.Items.Add(New ComboBoxItem([Enum].GetName(GetType(TPUDSAddressingType), addressingType), addressingType))
        Next

        comboBoxProtocol.SelectedIndex = 0
        comboBoxTargetType.SelectedIndex = 0
    End Sub

    Private Sub UpdateFixedCanId()
        Dim CanId As UInteger = 0
        If comboBoxTargetType.SelectedItem Is Nothing Then Return
        Dim addressingType As TPUDSAddressingType = TryCast(comboBoxTargetType.SelectedItem, ComboBoxItem).Data
        Dim protocol As TPUDSProtocol = TryCast(comboBoxProtocol.SelectedItem, ComboBoxItem).Data

        Select Case protocol
            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B

                If addressingType = TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL Then
                    CanId = &HDA0000
                Else
                    CanId = &HDB0000
                End If

            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_2_29B_REMOTE

                If addressingType = TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL Then
                    CanId = &HCE0000
                Else
                    CanId = &HCD0000
                End If

            Case TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_3_29B
                CanId = &H3000000
        End Select

        Select Case Decimal.ToInt32(numericUpDownCanId.Value)
            Case 0
                CanId += &H0
            Case 1
                CanId += &H4000000
            Case 2
                CanId += &H8000000
            Case 3
                CanId += &HC000000
            Case 4
                CanId += &H10000000
            Case 5
                CanId += &H14000000
            Case 6
                CanId += &H18000000
            Case 7
                CanId += &H1C000000
        End Select

        If protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_3_29B Then
            labelFixedCanId.Text = CanId.ToString("X8").Replace("000000", "XXXYYY") & "h"
        Else
            labelFixedCanId.Text = CanId.ToString("X8").Replace("0000", "XXYY") & "h"
        End If
    End Sub

    ''' <summary>
    ''' Event handler called when selectin in comboBox "Message Type" is changed.
    ''' </summary>
    ''' <param name="sender">The source of the event.</param>
    ''' <param name="e">Information on the event.</param>
    Private Sub comboBoxProtocol_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles comboBoxProtocol.SelectedIndexChanged
        If comboBoxProtocol.SelectedItem Is Nothing Then
            DisableNumericUpDowns()
            Return
        End If

        Dim item As ComboBoxItem = Nothing

        If CSharpImpl.__Assign(item, TryCast(comboBoxProtocol.SelectedItem, ComboBoxItem)) IsNot Nothing AndAlso item.Data Is Nothing Then
            ChangeUiVisibility(False)
            Return
        Else
            ChangeUiVisibility(True)
        End If

        Dim protocol As TPUDSProtocol = TryCast(comboBoxProtocol.SelectedItem, ComboBoxItem).Data

        If protocol <> TPUDSProtocol.PUDS_PROTOCOL_NONE Then

            If Not comboBoxTargetType.Enabled Then
                comboBoxTargetType.Enabled = True
                numericUpDownComponents_ValueChanged(Nothing, EventArgs.Empty)
            End If

            labelCanIdResp.Visible = True
            numericUpDownCanIdResp.Visible = True
        Else

            If comboBoxTargetType.SelectedItem Is Nothing OrElse CType(TryCast(comboBoxTargetType.SelectedItem, ComboBoxItem).Data, TPUDSAddressingType) <> TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL Then

                For Each comboboxItem As ComboBoxItem In comboBoxTargetType.Items

                    If CType(comboboxItem.Data, TPUDSAddressingType) = TPUDSAddressingType.PUDS_ADDRESSING_PHYSICAL Then
                        comboBoxTargetType.SelectedItem = comboboxItem
                        Exit For
                    End If
                Next
            End If

            labelCanIdResp.Visible = False
            numericUpDownCanIdResp.Visible = False
            comboBoxTargetType.Enabled = False
        End If

        If ProtocolIsDetachedFromIdsAndAddresses(protocol) Then
            buttonOk.Enabled = False

            If Not mFixedCanId Then
                labelFixedCanId.Visible = True
                labelTargetAddr.Visible = False
                labelRemoteAddr.Visible = False
                labelLocalAddress.Visible = False
                textBoxLocalAddress.Visible = False
                numericUpDownTargetAddr.Visible = False
                numericUpDownRemoteAddr.Visible = False
                mFixedCanId = True
                numericUpDownCanId.Maximum = 7
                numericUpDownCanId.Enabled = True
                labelCanId.Text = "Priority"
                labelCanIdResp.Text = "CAN ID"
            End If
            numericUpDownCanIdResp.Visible = False
            If protocol = TPUDSProtocol.PUDS_PROTOCOL_ISO_15765_3_29B Then
                labelSrcAddr.Text = FixedCanAddressExplanation & ThreeDigitAddresses
            Else
                labelSrcAddr.Text = FixedCanAddressExplanation & TwoDigitAddresses
            End If

            UpdateFixedCanId()
            Return
        ElseIf mFixedCanId Then
            labelCanId.Text = "CAN ID (hex):"
            labelCanIdResp.Text = "CAN ID response (hex):"
            labelSrcAddr.Text = "Source address (hex):"
            mFixedCanId = False
            labelFixedCanId.Visible = False
            labelSrcAddr.Visible = True
            labelTargetAddr.Visible = True
            labelRemoteAddr.Visible = True
            textBoxLocalAddress.Visible = True
            labelLocalAddress.Visible = True
            numericUpDownCanIdResp.Visible = True
            numericUpDownTargetAddr.Visible = True
            numericUpDownRemoteAddr.Visible = True
            numericUpDownComponents_ValueChanged(Nothing, EventArgs.Empty)
        End If

        If Not mFixedCanId Then
            EnableNumericUpDowns()

            If ProtocolIsRemote(protocol) Then
                numericUpDownRemoteAddr.Enabled = True
            Else
                numericUpDownRemoteAddr.Enabled = False
                numericUpDownRemoteAddr.Value = 0
            End If

            If ProtocolIs29Bit(protocol) Then
                numericUpDownCanId.Maximum = &H1FFFFFFF
                numericUpDownCanIdResp.Maximum = &H1FFFFFFF
            Else
                numericUpDownCanId.Maximum = &H7FF
                numericUpDownCanIdResp.Maximum = &H7FF
            End If
        End If
    End Sub

    Private Sub ChangeUiVisibility(ByVal visibility As Boolean)
        comboBoxTargetType.Enabled = visibility
        numericUpDownTargetAddr.Enabled = visibility
        numericUpDownRemoteAddr.Enabled = visibility
        labelCanIdResp.Enabled = visibility
        labelCanId.Enabled = visibility
        numericUpDownCanId.Enabled = visibility
        numericUpDownCanIdResp.Enabled = visibility
        labelTargetType.Enabled = visibility
        labelTargetAddr.Enabled = visibility
        labelRemoteAddr.Enabled = visibility
        buttonOk.Enabled = visibility
        labelSrcAddr.Enabled = visibility
        textBoxLocalAddress.Enabled = visibility
        labelLocalAddress.Enabled = visibility
        label2.Enabled = visibility
        radioButtonSending.Enabled = visibility
        radioButtonReceiving.Enabled = visibility
        labelFixedCanId.Enabled = visibility
    End Sub

    ''' <summary>
    ''' Event handler called when selectin in comboBox "Target Addressing Type" is changed.
    ''' </summary>
    ''' <param name="sender">The source of the event.</param>
    ''' <param name="e">Information on the event.</param>
    Private Sub comboBoxTargetType_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles comboBoxTargetType.SelectedIndexChanged
        If comboBoxTargetType.SelectedItem Is Nothing Then
            DisableNumericUpDowns()
            Return
        End If

        EnableNumericUpDowns()
        Dim targetType As TPUDSAddressingType = TryCast(comboBoxTargetType.SelectedItem, ComboBoxItem).Data

        If mFixedCanId Then
            UpdateFixedCanId()
            Return
        End If

        numericUpDownComponents_ValueChanged(Nothing, EventArgs.Empty)

        If targetType = TPUDSAddressingType.PUDS_ADDRESSING_FUNCTIONAL Then
            numericUpDownCanIdResp.Enabled = False
            numericUpDownCanIdResp.Maximum = &HFFFFFFFF
            numericUpDownCanIdResp.Value = &HFFFFFFFF
            radioButtonSending.Checked = True
            radioButtonReceiving.Enabled = False
            radioButtonSending.Enabled = False
        Else
            radioButtonReceiving.Enabled = True
            radioButtonSending.Enabled = True
        End If

        comboBoxProtocol_SelectedIndexChanged(Nothing, EventArgs.Empty)
    End Sub

    Private Sub DisableNumericUpDowns()
        numericUpDownCanId.Enabled = False
        numericUpDownCanIdResp.Enabled = False
        numericUpDownTargetAddr.Enabled = False
        numericUpDownRemoteAddr.Enabled = False
    End Sub

    Private Sub EnableNumericUpDowns()
        numericUpDownCanId.Enabled = True
        numericUpDownCanIdResp.Enabled = True
        numericUpDownTargetAddr.Enabled = True
        numericUpDownRemoteAddr.Enabled = True
    End Sub

    ''' <summary>
    ''' Event handler called when value is changed in various numericUpDown components.
    ''' </summary>
    ''' <param name="sender">The source of the event.</param>
    ''' <param name="e">Information on the event.</param>
    Private Sub numericUpDownComponents_ValueChanged(ByVal sender As Object, ByVal e As EventArgs) Handles numericUpDownTargetAddr.ValueChanged, numericUpDownRemoteAddr.ValueChanged, numericUpDownCanIdResp.ValueChanged, numericUpDownCanId.ValueChanged
        If mFixedCanId Then
            UpdateFixedCanId()
        Else

            If numericUpDownCanId.Value <> numericUpDownCanIdResp.Value AndAlso mSourceAddress <> numericUpDownTargetAddr.Value Then
                buttonOk.Enabled = True
            Else
                buttonOk.Enabled = False
            End If
        End If
    End Sub

    Private Sub AssignMappingsValuesToDataStructure()
        MappingInformation.CanId = CUInt(numericUpDownCanId.Value)
        MappingInformation.ResponseCanId = CUInt(numericUpDownCanIdResp.Value)

        If radioButtonSending.Checked Then
            MappingInformation.SourceAddress = CByte(mSourceAddress)
            MappingInformation.TargetAddress = CByte(numericUpDownTargetAddr.Value)
        Else
            MappingInformation.TargetAddress = CByte(mSourceAddress)
            MappingInformation.SourceAddress = CByte(numericUpDownTargetAddr.Value)
        End If

        MappingInformation.RemoteAddress = CByte(numericUpDownRemoteAddr.Value)
        If comboBoxProtocol.SelectedItem IsNot Nothing Then MappingInformation.Protocol = CType(TryCast(comboBoxProtocol.SelectedItem, ComboBoxItem).Data, TPUDSProtocol)
        If comboBoxTargetType.SelectedItem IsNot Nothing Then MappingInformation.TargetType = CType(TryCast(comboBoxTargetType.SelectedItem, ComboBoxItem).Data, TPUDSAddressingType)
    End Sub

    Private Sub radioButtonSending_CheckedChanged(ByVal sender As Object, ByVal e As EventArgs) Handles radioButtonSending.CheckedChanged
        If radioButtonSending.Checked Then
            textBoxLocalAddress.Location = New Point(textBoxLocalAddress.Location.X, 136)
            labelLocalAddress.Location = New Point(labelLocalAddress.Location.X, 139)
            numericUpDownTargetAddr.Location = New Point(numericUpDownTargetAddr.Location.X, 163)
        Else
            numericUpDownTargetAddr.Location = New Point(numericUpDownTargetAddr.Location.X, 136)
            textBoxLocalAddress.Location = New Point(textBoxLocalAddress.Location.X, 163)
            labelLocalAddress.Location = New Point(labelLocalAddress.Location.X, 166)
        End If
    End Sub

    Private Sub buttonOk_Click(ByVal sender As Object, ByVal e As EventArgs) Handles buttonOk.Click
        AssignMappingsValuesToDataStructure()
    End Sub

    Private Class CSharpImpl
        <Obsolete("Please refactor calling code to use normal Visual Basic assignment")>
        Shared Function __Assign(Of T)(ByRef target As T, value As T) As T
            target = value
            Return value
        End Function
    End Class
End Class