﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Peak.Can.Xcp;

namespace XCP_Master_test
{
    using Peak.Can.Basic;
    using TPCANHandle = System.UInt16;
    using TPCANBitrateFD = System.String;
    using TXCPChannel = System.UInt16;
    using TXCPHandle = System.UInt32;

    public partial class Form1 : Form
    {
        private TXCPChannel m_XcpChannel;
        private TXCPHandle m_XcpSession;        
        private TXCPProtocolLayerConfig m_XcpProtocolConfig;
        private TXCPTransportLayerCAN m_XcpSlaveData;

        private TPCANBitrateFD m_Bitrate;

        public Form1()
        {
            InitializeComponent();

            // Arbitration: 1 Mbit/s - Data: 2 Mbit/s
            //
            m_Bitrate = "f_clock_mhz=20, nom_brp=5, nom_tseg1=2, nom_tseg2=1, nom_sjw=1, data_brp=2, data_tseg1=3, data_tseg2=1, data_sjw=1";

            // Protocol timouts configuration: 
            //
            m_XcpProtocolConfig = new TXCPProtocolLayerConfig();
            m_XcpProtocolConfig.T1 = 25;
            m_XcpProtocolConfig.T2 = 25;
            m_XcpProtocolConfig.T3 = 25;
            m_XcpProtocolConfig.T4 = 25;
            m_XcpProtocolConfig.T5 = 25;
            m_XcpProtocolConfig.T6 = 25;
            m_XcpProtocolConfig.T7 = 25;
            // m_XcpProtocolConfig.AddressGranularity = 1;  DEPRECIATED
            // m_XcpProtocolConfig.MotorolaFormat = false;  DEPRECIATED

            m_XcpSession = 0;
            m_XcpChannel = 0;
        }

        private bool InitializeXCPChannel()
        {
            TXCPResult result;
            StringBuilder strText = new StringBuilder(256);

            // Data of slave to connect
            m_XcpSlaveData.BroadcastID = (uint)(chbFD.Checked ? 0x40000300 : 0x300);
            m_XcpSlaveData.MasterID = (uint)(chbFD.Checked ? 0x40000200 : 0x200);
            m_XcpSlaveData.SlaveID = (uint)(chbFD.Checked ? 0x40000100 : 0x100);
            m_XcpSlaveData.IncrementalIdUsed = false;

            // Initializes PCAN-Basic Channel
            //
            if (chbFD.Checked)
                result = XCPApi.InitializeCanChannelFD(out m_XcpChannel, PCANBasic.PCAN_USBBUS1, m_Bitrate);
            else
                result = XCPApi.InitializeCanChannel(out m_XcpChannel, PCANBasic.PCAN_USBBUS1, TPCANBaudrate.PCAN_BAUD_500K);

            if (result == TXCPResult.XCP_ERR_OK)
            {
                // Associates a CAN channel with Slave data to communicate over CAN
                // This operation retrieves the Session-handle (m_XcpSession) to be 
                // used with all other XCP Command-Functions
                //
                result = XCPApi.AddSlaveOnCAN(m_XcpChannel, m_XcpSlaveData, m_XcpProtocolConfig, out m_XcpSession);
                if(result != TXCPResult.XCP_ERR_OK)
                {
                    XCPApi.GetErrorText(result, strText);
                    MessageBox.Show("Error: " + strText.ToString());

                    XCPApi.UninitializeChannel(m_XcpChannel);
                    m_XcpChannel = 0;
                    return false;
                }

                return true;
            }
            else
            {
                
                XCPApi.GetErrorText(result, strText);
                MessageBox.Show("Error: " + strText.ToString());
            }
            return false;
        }

        private void btnInit_Click(object sender, EventArgs e)
        {
            // Establishes the physical (CAN) connection by initializing 
            // a PCAN-Basic channel and associating it with the slave
            // information to use (get the Session handle)
            //
            if(InitializeXCPChannel())
            {
                btnInit.Enabled = false;
                btnFinalize.Enabled = true;
                btnConnect.Enabled = true;
                btnDisconnect.Enabled = false;
            }
            else
            {
                btnInit.Enabled = true;
                btnFinalize.Enabled = false;
                btnConnect.Enabled = false;
                btnDisconnect.Enabled = false;
            }
        }

        private void btnFinalize_Click(object sender, EventArgs e)
        {
            TXCPResult result;

            // Terminates the logical connection first, if any
            if (btnDisconnect.Enabled)
                btnDisconnect_Click(btnDisconnect, new EventArgs());

            // Releases the physical conenction (PCAN-Basic channel)
            result = XCPApi.UninitializeChannel(m_XcpChannel);
            
            m_XcpChannel = 0;
            btnInit.Enabled = true;
            btnFinalize.Enabled = false;
            btnConnect.Enabled = false;
            btnDisconnect.Enabled = false;
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            TXCPResult result;
            byte[] msg;

            msg = new byte[chbFD.Checked ? Peak.Can.Xcp.XCPApi.CAN_MAX_LEN_FD : Peak.Can.Xcp.XCPApi.CAN_MAX_LEN];

            // Enables a session (connection) between this (master) application 
            // and the slave described by the m_XcpSession handle
            //
            result = XCPApi.Connect(m_XcpSession, 0, msg, (ushort)msg.Length);          
            btnConnect.Enabled = (result != TXCPResult.XCP_ERR_OK);
            btnDisconnect.Enabled = !btnConnect.Enabled;

            if (result == TXCPResult.XCP_ERR_OK)
            {
                // Show the information from Slave:
                //
                label1.Text = string.Format("0x{0:X2}", msg[1]);
                label2.Text = string.Format("0x{0:X2}", msg[2]);
                label3.Text = string.Format("{0:D2}", msg[3]);
                label4.Text = string.Format("{0:D2}", ((msg[2] & 1) == 1) ? msg[5] : msg[4]);
                label5.Text = string.Format("Version: {0:D2}", msg[6]);
                label6.Text = string.Format("Version: {0:D2}", msg[7]);
            }
            else
            {
                StringBuilder strText = new StringBuilder(256);
                XCPApi.GetErrorText(result, strText);
                MessageBox.Show("Error while connecting: " + strText.ToString());
            }
        }

        private void btnDisconnect_Click(object sender, EventArgs e)
        {
            TXCPResult result;
            byte[] msg;

            msg = new byte[chbFD.Checked ? Peak.Can.Xcp.XCPApi.CAN_MAX_LEN_FD : Peak.Can.Xcp.XCPApi.CAN_MAX_LEN];
            
            // Sets the ECU (slave) in a disconnected state
            //
            result = XCPApi.Disconnect(m_XcpSession, msg, (ushort)msg.Length);
            btnDisconnect.Enabled = (result != TXCPResult.XCP_ERR_OK);
            btnConnect.Enabled = !btnDisconnect.Enabled;

            label1.Text = label2.Text = label3.Text = label4.Text = label5.Text = label6.Text = "";
        }
    }
}
