// PxcpSample.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "Windows.h"

// Header inclues for APi declarations/definitions
//
#include "PXCP.h"
#include <stdio.h>
#include <math.h>

// XCP structs and variables
//
TXCPChannel g_XcpChannel;
TXCPHandle g_XcpSession;
TXCPProtocolLayerConfig g_XcpProto;
TXCPTransportLayerCAN g_CanLayer;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;
	TXCPResult result;
//	BYTE buffer[CAN_MAX_CTO];
	BYTE* buffer;
	CString m_Bitrate;
    byte m_MaxCTO;
    byte m_MaxDTO;
	int i;

	// Arbitration: 1 Mbit/s - Data: 2 Mbit/s
    //
    m_Bitrate = "f_clock_mhz=20, nom_brp=5, nom_tseg1=2, nom_tseg2=1, nom_sjw=1, data_brp=2, data_tseg1=3, data_tseg2=1, data_sjw=1";

	int test = (int)floor(0.98);

	m_MaxCTO = CAN_MAX_CTO;
	m_MaxDTO = CAN_MAX_DTO;

	printf("CONFIGURATION:\n");
	// XCP Protocol configuration
	//
	g_XcpProto.T1 = g_XcpProto.T2 = g_XcpProto.T3 = g_XcpProto.T4 = g_XcpProto.T5 = g_XcpProto.T6 = g_XcpProto.T7 = 25;
//	g_XcpProto.AddressGranularity = 1;    DEPRECIATED
//	g_XcpProto.MotorolaFormat = false;	  DEPRECIATED
	printf("Protocol: All Timeouts to 25 millis\n\n");

	printf("Select the kind of connection (1 or 2):\n");
	printf("  1. CAN, PCAN_USBBUS1 at 500kBit\n");
	printf("  2. CAN-FD, PCAN_USBBUS1 at 1MBit/2MBit\n");
    i = getchar();
	// Slave/Transport_layer configuration
	//
	g_CanLayer.IncrementalIdUsed = false;
	switch(i)
	{
		case 49:
			g_CanLayer.BroadcastID = 0x300;
			g_CanLayer.MasterID = 0x200;
			g_CanLayer.SlaveID = 0x100;
			break;
		case 50:
			g_CanLayer.BroadcastID = 0x40000300;
			g_CanLayer.MasterID = 0x40000200;
			g_CanLayer.SlaveID = 0x40000100;
			break;
		default:
			printf("Could'n read the value. Terminating...");
			return 0;
	}
	getchar();
	printf("Transport: CAN_ID_BROADCAST: 0x300, CAN_ID_MASTER: 0x200, CAN_ID_SLAVE: 0x100\n");

	// Transport Layer initialization
	//
	if(i == 49)
		result = XCP_InitializeCanChannel(&g_XcpChannel, PCAN_USBBUS1, PCAN_BAUD_500K);
	else
	{
		result = XCP_InitializeCanChannelFD(&g_XcpChannel, PCAN_USBBUS1, m_Bitrate.GetBuffer());
		m_Bitrate.ReleaseBuffer();
	}
	if(result == XCP_ERR_OK)
	{
		printf("\n----->CAN Channel, sucessfully initialized\n");
		// Master/Slave session configuration
		//
		result = XCP_AddSlaveOnCAN(g_XcpChannel, g_CanLayer, g_XcpProto, &g_XcpSession);
		if(result == XCP_ERR_OK)
		{
			printf("\n	----->XCP session configured sucessfully\n");
			buffer = new byte[(i == 49) ? CAN_MAX_LEN : CAN_MAX_LEN_FD];
			// XCP Session is activated
			//
			result = XCP_Connect(g_XcpSession, 0, buffer, (i == 49) ? CAN_MAX_LEN : CAN_MAX_LEN_FD);
			if(result == XCP_ERR_OK)
			{
				printf("\n		----->XCP session connected!\n");
				// Show the information from Slave:
				//
				printf("\n		------Resouorces Mask: 0x%X", buffer[1]);
				printf("\n		------COMM_MODE_BASIC Mask: 0x%X", buffer[2]);
				printf("\n		------MAX_CTO: %d", buffer[3]);
				printf("\n		------MAX_DTO: %d", ((buffer[2] & 1) ? buffer[5] : buffer[4]));
				printf("\n		------XCP protocol layer Version: %d", buffer[6]);
				printf("\n		------XCP transport layer  Version: %d\n", buffer[7]);

				// Set the slave status to deactivated, in an asynchronous way
				//
				result = XCP_Disconnect(g_XcpSession, NULL, 0);
				if(result == XCP_ERR_OK)
				{						
					// Reads the response to the disconnection command
					//
					Sleep(25);
					result = XCP_DequeuePacket(g_XcpSession, XCP_CTO_QUEUE, buffer, CAN_MAX_CTO);
					if(result == XCP_ERR_OK)
					{
						if(buffer[0] == XCP_MSGTYPE_RES)
							printf("\n		<-----XCP session disconnected!\n");
						else
							printf("\n		<-----Disconnection ERROR: Pack-Type received: 0x%X !\n", buffer[0]);
					}
					else
						printf("		   ***ERROR: Disconnect CTO not received: 0x%X***", result);
				}
				else
					printf("\n		   ***ERROR while disconnecting session: 0x%X***", result);
			}
			else
				printf("\n		***ERROR while connecting session: 0x%X***", result);
			// Remove the Master/Slave session configured before 
			// (resources as CTO/DTO qwueues are freed).
			//
			XCP_RemoveSlave(g_XcpSession);
			printf("\n	<-----XCP session configuration was removed!\n");
			delete buffer;
		}
		else
			printf("\n	***ERROR while adding Master/Slave session configuration: 0x%X***", result);

		// Frees the protocol layer connection (CAN channel is uninitialized)
		//
		XCP_UninitializeChannel(g_XcpChannel);
		printf("\n<-----XCP Channel (PCAN-Basic PCAN_USBBUS1 channel) uninitialized!\n");
	}
	else
		printf("\n***ERROR while initializing channel: 0x%X***", result);
	
	printf("\nHit a key to exit\n");	
	i =getchar();

	return nRetCode;
}
