﻿Imports System.Text
Imports Peak.Can.Basic
Imports Peak.Can.Xcp
Imports TPCANHandle = System.UInt16
Imports TXCPChannel = System.UInt16
Imports TXCPHandle = System.UInt32
Imports TPCANBitrateFD = System.String


Public Class Form1
    Private m_XcpChannel As TXCPChannel
    Private m_XcpSession As TXCPHandle
    Private m_XcpProtocolConfig As TXCPProtocolLayerConfig
    Private m_XcpSlaveData As TXCPTransportLayerCAN

    Private m_Bitrate As TPCANBitrateFD

    Public Sub New()

        InitializeComponent()

        ' Arbitration: 1 Mbit/s - Data: 2 Mbit/s
        '
        m_Bitrate = "f_clock_mhz=20, nom_brp=5, nom_tseg1=2, nom_tseg2=1, nom_sjw=1, data_brp=2, data_tseg1=3, data_tseg2=1, data_sjw=1"

        ' Protocol configuration: data granularity, timouts, byte aligment
        m_XcpProtocolConfig = New TXCPProtocolLayerConfig()
        m_XcpProtocolConfig.T1 = 25
        m_XcpProtocolConfig.T2 = 25
        m_XcpProtocolConfig.T3 = 25
        m_XcpProtocolConfig.T4 = 25
        m_XcpProtocolConfig.T5 = 25
        m_XcpProtocolConfig.T6 = 25
        m_XcpProtocolConfig.T7 = 25
        ' m_XcpProtocolConfig.AddressGranularity = 1          DEPRECIATED
        ' m_XcpProtocolConfig.MotorolaFormat = False          DEPRECIATED

        m_XcpSession = 0
        m_XcpChannel = 0
    End Sub

    Private Function InitializeXCPChannel() As Boolean
        Dim result As TXCPResult
        Dim strText As StringBuilder = New StringBuilder(256)

        ' Data of slave to connect
        m_XcpSlaveData.BroadcastID = If(chbFD.Checked, &H40000300, &H300)
        m_XcpSlaveData.MasterID = If(chbFD.Checked, &H40000200, &H200)
        m_XcpSlaveData.SlaveID = If(chbFD.Checked, &H40000100, &H100)
        m_XcpSlaveData.IncrementalIdUsed = False

        ' Initializes PCAN-Basic Channel
        '
        If (chbFD.Checked) Then
            result = XCPApi.InitializeCanChannelFD(m_XcpChannel, PCANBasic.PCAN_USBBUS1, m_Bitrate)
        Else
            result = XCPApi.InitializeCanChannel(m_XcpChannel, PCANBasic.PCAN_USBBUS1, TPCANBaudrate.PCAN_BAUD_500K)
        End If

        If (result = TXCPResult.XCP_ERR_OK) Then
            ' Associates a CAN channel with Slave data to communicate over CAN
            ' This operation retrieves the Session-handle (m_XcpSession) to be 
            ' used with all other XCP Command-Functions
            '
            result = XCPApi.AddSlaveOnCAN(m_XcpChannel, m_XcpSlaveData, m_XcpProtocolConfig, m_XcpSession)
            If (result <> TXCPResult.XCP_ERR_OK) Then
                XCPApi.GetErrorText(result, strText)
                MessageBox.Show("Error: " + strText.ToString())

                XCPApi.UninitializeChannel(m_XcpChannel)
                m_XcpChannel = 0
                Return False
            End If
            Return True
        Else
            XCPApi.GetErrorText(result, strText)
            MessageBox.Show("Error: " + strText.ToString())
        End If
        Return False
    End Function

    Private Sub btnInit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnInit.Click
        ' Establishes the physical (CAN) connection by initializing 
        ' a PCAN-Basic channel and associating it with the slave
        ' information to use (get the Session handle)
        '
        If (InitializeXCPChannel()) Then
            btnInit.Enabled = False
            btnFinalize.Enabled = True
            btnConnect.Enabled = True
            btnDisconnect.Enabled = False
        Else
            btnInit.Enabled = True
            btnFinalize.Enabled = False
            btnConnect.Enabled = False
            btnDisconnect.Enabled = False
        End If

    End Sub

    Private Sub btnFinalize_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFinalize.Click
        Dim result As TXCPResult

        ' Terminates the logical connection first, if any
        If (btnDisconnect.Enabled) Then
            btnDisconnect_Click(btnDisconnect, New EventArgs())
        End If

        ' Releases the physical conenction (PCAN-Basic channel)
        result = XCPApi.UninitializeChannel(m_XcpChannel)

        m_XcpChannel = 0
        btnInit.Enabled = True
        btnFinalize.Enabled = False
        btnConnect.Enabled = False
        btnDisconnect.Enabled = False
    End Sub

    Private Sub btnConnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnConnect.Click
        Dim result As TXCPResult
        Dim msg As Byte()
        Dim strText As StringBuilder = New StringBuilder(256)

        msg = New Byte(If(chbFD.Checked, Peak.Can.Xcp.XCPApi.CAN_MAX_LEN_FD, Peak.Can.Xcp.XCPApi.CAN_MAX_LEN)) {}

        ' Enables a session (connection) between this (master) application 
        ' and the slave described by the m_XcpSession handle
        '
        result = XCPApi.Connect(m_XcpSession, 0, msg, msg.Length)
        btnConnect.Enabled = (result <> TXCPResult.XCP_ERR_OK)
        btnDisconnect.Enabled = Not btnConnect.Enabled

        If (result = TXCPResult.XCP_ERR_OK) Then
            ' Show the information from Slave:
            '
            label1.Text = String.Format("0x{0:X2}", msg(1))
            label2.Text = String.Format("0x{0:X2}", msg(2))
            label3.Text = String.Format("{0:D2}", msg(3))
            label4.Text = String.Format("{0:D2}", If(((msg(2) And 1) = 1), msg(5), msg(4)))
            label5.Text = String.Format("Version: {0:D2}", msg(6))
            label6.Text = String.Format("Version: {0:D2}", msg(7))
        Else
            XCPApi.GetErrorText(result, strText)
            MessageBox.Show("Error while connecting: " + strText.ToString())
        End If

    End Sub

    Private Sub btnDisconnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDisconnect.Click
        Dim result As TXCPResult
        Dim msg As Byte()

        msg = New Byte(If(chbFD.Checked, Peak.Can.Xcp.XCPApi.CAN_MAX_LEN_FD, Peak.Can.Xcp.XCPApi.CAN_MAX_LEN)) {}

        '  Sets the uconnected ECU (slave) in a disconnected state
        '
        result = XCPApi.Disconnect(m_XcpSession, msg, msg.Length)
        btnDisconnect.Enabled = (result <> TXCPResult.XCP_ERR_OK)
        btnConnect.Enabled = Not btnDisconnect.Enabled
        label1.Text = ""
        label2.Text = ""
        label3.Text = ""
        label4.Text = ""
        label5.Text = ""
        label6.Text = ""
    End Sub
End Class
