/* SPDX-License-Identifier: LGPL-2.1-only */
/*
 * @file pcbcore_data.h
 * @brief **Automatically generated file** Provides extra data to extend
 * support of PCANBasic API enhanced features.
 *
 * $Id: pcbcore_data.h 13816 2022-03-17 11:26:41Z Fabrice $
 *
 * Copyright (C) 2001-2025  PEAK System-Technik GmbH <www.peak-system.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * PCAN is a registered Trademark of PEAK-System Germany GmbH
 *
 * Contact:      <linux@peak-system.com>
 * Maintainer:   Fabrice Vergnaud <f.vergnaud@peak-system.com>
 */

#ifndef __PCBCORE_DATA_H__
#define __PCBCORE_DATA_H__

#ifndef __PCB_DATA_FW_ECHO
#define __PCB_DATA_FW_ECHO {\
	0x05,0x35,0x2E,0x33,0x2E,0x30,0x50,0x43,0x41,0x4E,0x2D,0x55,0x53,0x42,0x00,\
	0x05,0x38,0x2E,0x36,0x2E,0x31,0x50,0x43,0x41,0x4E,0x2D,0x55,0x53,0x42,0x00,\
	0x05,0x33,0x2E,0x34,0x2E,0x33,0x50,0x43,0x41,0x4E,0x2D,0x55,0x53,0x42,0x20,0x46,0x44,0x00,\
	0x05,0x33,0x2E,0x34,0x2E,0x33,0x50,0x43,0x41,0x4E,0x2D,0x55,0x53,0x42,0x20,0x50,0x72,0x6F,0x20,0x46,0x44,0x00,\
	0x05,0x33,0x2E,0x34,0x2E,0x33,0x50,0x43,0x41,0x4E,0x2D,0x55,0x53,0x42,0x20,0x58,0x36,0x00,\
	0x05,0x33,0x2E,0x34,0x2E,0x33,0x50,0x43,0x41,0x4E,0x2D,0x43,0x68,0x69,0x70,0x20,0x55,0x53,0x42,0x00,\
	0x06,0x2B,0x31,0x2E,0x33,0x2E,0x30,0x50,0x43,0x41,0x4E,0x2D,0x50,0x43,0x49,0x20,0x45,0x78,0x70,0x72,0x65,0x73,0x73,0x00,\
	0x06,0x2B,0x33,0x2E,0x35,0x2E,0x36,0x50,0x43,0x41,0x4E,0x2D,0x50,0x43,0x49,0x20,0x45,0x78,0x70,0x72,0x65,0x73,0x73,0x20,0x46,0x44,0x00,\
	0x06,0x2B,0x31,0x2E,0x33,0x2E,0x30,0x50,0x43,0x41,0x4E,0x2D,0x6D,0x69,0x6E,0x69,0x50,0x43,0x49,0x65,0x00,\
	0x06,0x2B,0x33,0x2E,0x35,0x2E,0x36,0x50,0x43,0x41,0x4E,0x2D,0x6D,0x69,0x6E,0x69,0x50,0x43,0x49,0x65,0x20,0x46,0x44,0x00,\
	0x06,0x2B,0x33,0x2E,0x35,0x2E,0x36,0x50,0x43,0x41,0x4E,0x2D,0x4D,0x2E,0x32,0x00,\
	0x06,0x2B,0x31,0x2E,0x33,0x2E,0x30,0x50,0x43,0x41,0x4E,0x2D,0x50,0x43,0x49,0x2F,0x31,0x30,0x34,0x2D,0x45,0x78,0x70,0x72,0x65,0x73,0x73,0x00,\
	0x06,0x2B,0x33,0x2E,0x35,0x2E,0x36,0x50,0x43,0x41,0x4E,0x2D,0x50,0x43,0x49,0x2F,0x31,0x30,0x34,0x2D,0x45,0x78,0x70,0x72,0x65,0x73,0x73,0x20,0x46,0x44,0x00,\
	0x06,0x2B,0x33,0x2E,0x35,0x2E,0x36,0x50,0x43,0x41,0x4E,0x2D,0x43,0x68,0x69,0x70,0x20,0x50,0x43,0x49,0x65,0x20,0x46,0x44,0x00,\
	0x06,0x2B,0x33,0x2E,0x34,0x2E,0x33,0x50,0x43,0x41,0x4E,0x2D,0x50,0x43,0x49,0x65,0x20,0x46,0x44,0x00,\
	0x06,0x2B,0x33,0x2E,0x34,0x2E,0x33,0x50,0x43,0x41,0x4E,0x2D,0x63,0x50,0x43,0x49,0x65,0x20,0x46,0x44,0x00,\
	0x06,0x2B,0x33,0x2E,0x34,0x2E,0x33,0x50,0x43,0x41,0x4E,0x2D,0x50,0x43,0x2F,0x31,0x30,0x34,0x2D,0x50,0x6C,0x75,0x73,0x20,0x46,0x44,0x00,\
	0x00,0x50,0x43,0x41,0x4E,0x2D,0x50,0x43,0x2F,0x31,0x30,0x34,0x00,\
	0x00,0x50,0x43,0x41,0x4E,0x2D,0x50,0x43,0x49,0x00,\
	0x00,0x50,0x43,0x41,0x4E,0x2D,0x63,0x50,0x43,0x49,0x00,\
	0x00,0x50,0x43,0x41,0x4E,0x2D,0x6D,0x69,0x6E,0x69,0x50,0x43,0x49,0x00,\
	0x00,0x50,0x43,0x41,0x4E,0x2D,0x43,0x68,0x69,0x70,0x20,0x50,0x43,0x49,0x65,0x00,\
	0x00,0x50,0x43,0x41,0x4E,0x2D,0x45,0x78,0x70,0x72,0x65,0x73,0x73,0x43,0x61,0x72,0x64,0x00,\
	0x00,0x50,0x43,0x41,0x4E,0x2D,0x45,0x78,0x70,0x72,0x65,0x73,0x73,0x43,0x61,0x72,0x64,0x20,0x33,0x34,0x00,\
	0x00, 0x00};
#endif

#ifndef __PCB_IS_FW_ECHO
#define __PCB_IS_FW_ECHO(pinfo) ({    \
    int res = 0;                                                                                \
    int dev = 0;                                                                                \
    if (pinfo) {                                                                                \
        const uint8_t ptr[] = __PCB_DATA_FW_ECHO;                                               \
        size_t i = 0;                                                                           \
        struct pcaninfo_version ver;                                                            \
        do {                                                                                    \
            if (strcmp(pinfo->adapter_name, (const char *)&ptr[i + 1 + ptr[i]]) == 0) {         \
                dev = 1;                                                                        \
                if (ptr[i + 1] != '+') {                                                        \
                    res = (memcmp(pinfo->adapter_version, &ptr[i + 1],                          \
                                  ptr[i] * sizeof(uint8_t)) == 0);                              \
                } else {                                                                        \
                    if (pcaninfo_parse_version((const char*)&ptr[i + 1 + 1], &ver) == 0 &&      \
                        (ver.status & PCB_VERSION_DEFINED_MIN)) {                               \
                        res = (ver.major == version_fw.major && ver.minor <= version_fw.minor); \
                    }                                                                           \
                }                                                                               \
                if (res) i = sizeof(ptr);                                                       \
            }                                                                                   \
            i = i + 1 + ptr[i] + strlen((const char *)&ptr[i + 1 + ptr[i]]) + 1;                \
        } while (i < sizeof(ptr) && (ptr[i] | ptr[i+1]));                                       \
    }                                                                                           \
    if (!dev && !res) res = -1;                                                                 \
    res;})
#endif

#endif
