/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2025 Stephane Grosjean <stephane.grosjean@hms-networks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the version 2 of the GNU General Public License
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */
#ifndef __PLIN_CHRDEV_H__
#define __PLIN_CHRDEV_H__

#include <linux/sched.h>

struct plin_driver_chrdev {
	int major;
};

struct plin_udata {
	struct list_head link;
	struct plin_dev *dev;
	unsigned int f_flags;

	struct kfifo rx_fifo;
	wait_queue_head_t rx_wait;

	u32 flags;
};

struct plin_chrdev_data {
	int minor;
	int usr_count;
	struct list_head usr_list;

	struct mutex mutex_lock;
	struct mutex mutex_write;
	struct mutex mutex_ioctl;

	/* called when the device node is opened for the first time */
	int (*open)(struct plin_dev *dev, struct plin_udata *usr);

	/* called when the device node is closed by its last user */
	void (*close)(struct plin_dev *dev, struct plin_udata *usr);
};

#define dev_minor(d)		((d)->chrdev.minor)
#define dev_usr_count(d)	((d)->chrdev.usr_count)
#define dev_usr_list(d)		((d)->chrdev.usr_list)
#define dev_open(d)		((d)->chrdev.open)
#define dev_close(d)		((d)->chrdev.close)

extern int plin_chrdev_rx_msg(struct plin_dev *dev, struct plin_msg *msg);

extern int plin_chrdev_init_dev(struct plin_dev *dev);
extern void plin_chrdev_free_dev(struct plin_dev *dev);

extern int plin_chrdev_init(void);
extern void plin_chrdev_exit(void);

#endif
