/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2025 Stephane Grosjean <stephane.grosjean@hms-networks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the version 2 of the GNU General Public License
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */
#ifndef __PLIN_SYSFS_H__
#define __PLIN_SYSFS_H__

struct plin_intf;
struct plin_dev;

struct plin_dev_sysfs {
	struct device *dev;
};

extern const char *plin_sysfs_get_mode_str(int mode);

extern void plin_sysfs_create_intf(struct plin_intf *intf);

extern void plin_sysfs_destroy_intf(struct plin_intf *intf);

extern void plin_sysfs_create_dev_ex(struct plin_dev *dev,
				     struct device *parent);
extern void plin_sysfs_destroy_dev(struct plin_dev *dev);

static inline void plin_sysfs_create_dev(struct plin_dev *dev)
{
	plin_sysfs_create_dev_ex(dev, NULL);
}

extern int plin_sysfs_init(void);
extern void plin_sysfs_exit(void);

#endif
