#!/bin/bash
#
# Stop device mode.
#
# USAGE:
#
# $ ./stop_lin.sh /dev/plinX
#
MYSELF=`basename $0`
LIN=./lin

CUT=cut
GREP=grep
#SUDO=sudo

[ "${1}x" == "x" ] && echo "Usage: $MYSELF /dev/plinX" && exit 1

dev=$1

# 1 - setup mode=NONE
$SUDO $LIN disconnect $dev

# 2 - get the status of the LIN node
dev_mode=`$SUDO $LIN get status $dev | $GREP "^mode=" | $CUT -d= -f2`
[ "${dev_mode}x" != "none (0)x" ] && echo "Error: unable to stop LIN $dev" && exit 2

# 3 - say we're ok:
$SUDO $LIN identify $dev

# 4 - Ok
exit 0
