//   Demo2_ext-id to use extended CAN-ID's

#include "compiler.h"
#include "mb90495.h"
#include "vectors.h"
#include "can.h"
#include "hardware.h"
#include "timer.h"
#include "i2c.h"
#include "i2c_2.h"
#include "eeprom.h"
#include "adi.h"
#include "pwm.h"
#include "uart1.h"
#include "mcan.h"

//*************************************************************
static void Eval_CANFrames(void);			//CAN receive function
//***********************************************************************
// CAN-Queues
#define QUEUE_RCV_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
#define QUEUE_XMT_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
//**************************************************************
//UART-Queues
#define TX_entries 60		//UART transmit buffer 59 Byte (max. size + 1)		
#define RX_entries 60		//UART receive buffer 59 Byte (max. size + 1)
//*************** Globale Variablen ****************************
CANI_qentrytyp rcv_queue[QUEUE_RCV_SIZE];	
CANI_qentrytyp xmt_queue[QUEUE_XMT_SIZE];	

u8_t Buf_XMTQueue[TX_entries];
u8_t Buf_RCVQueue[RX_entries];

//*************************************************************
void Timer_2000Hz()
{
	static u8_t n;
	
	n++;
	if(n&1)	// runs only ever second call
	{
		LED_1000Hz();
		AD_1000Hz();
	}
}

//***********************************************************************
static void Eval_CANFrames()
{
	if(CAN_Read()==CAN_ERR_OK)	// if an new CAN-Message was received
	{
		switch(CAN_BUFF_ID)
		{
			// Firmwareupdate via CAN
			//convert x.mhx into x.bin via mot2bin.exe (see ...\Release\ABS) and upload with CAN2Flash.exe to MicroMod  
			case 0x7e7:
/* 
The Library-Funktion  CAN_Read() fills the variables CAN_BUFF_ID, CAN_BUFF_LEN, CAN_BUFF_DATA[8] with the last Queue-entry of the CAN-message.
When using own CAN-LowLevel drivers must befor call the function mCAN_EvalInitialCmd() the variables
CAN_BUFF_ID
CAN_BUFF_LEN
CAN_BUFF_DATA[8]
be filled with the CAN-data.

*/
				// all outputs off
				Set_DOUTByte(0);
								
				mCAN_EvalInitialCmd();			
			break;
	//process other CAN-ID 
			default:
			break;
		} // switch
		
	} // if(CAN_Read()=...
}
//*************************************************************
void main()
{
	u8_t i;
	
	InitIrqLevels();
    __set_il(7);		// allow all levels 

	Hardware_Init();		
	Timer_Init();
	
	AD_Init();
	for(i=0;i<8;i++)
		AD_SetTimeConstant(i, 20);	// Tau fr Tiefpassfilter auf 20ms setzen
		
	UART1_SetXMTQueue(Buf_XMTQueue, TX_entries);		//transmit-buffer
	UART1_SetRCVQueue(Buf_RCVQueue, RX_entries);		//receive-buffer
	UART1_Init(19200,BITLEN_8,NO_PARITY,STOPLEN_1);

	CAN_SetRCVQueue(rcv_queue, QUEUE_RCV_SIZE);	// Set Receive Queue to 8 entries, 
	CAN_SetXMTQueue(xmt_queue, QUEUE_XMT_SIZE);	// Set CAN Transmit Queue to 8 entries
	CAN_Init(CAN_BAUD_500K);
	CAN_RegisterMsg(0);
	CAN_Online();
		
	__EI();				// Enable Interrupts
	
	UART1_Write((u8_t*)"\rDEMO_2, use extended CAN-ID's",30);	// example for String output
	
	CAN_BUFF_LEN=8;
	CAN_BUFF_FORMAT = CAN_EXT;// // extended CAN-ID 29 bit, not Standard 11 bit
	CAN_BUFF_ID=0x1234567;	// Testmessage 1
	CAN_BUFF_DATA[0]=1;
	CAN_BUFF_DATA[1]=2;
	CAN_BUFF_DATA[2]=3;
	CAN_BUFF_DATA[3]=4;
	CAN_BUFF_DATA[4]=5;
	CAN_BUFF_DATA[5]=6;
	CAN_BUFF_DATA[6]=7;
	CAN_BUFF_DATA[7]=8;
	CAN_Write();	
	
	Timer_Set(0, 1000);
	
	for(;;)							//Main_loop
	{	
		WATCHDOG;
		Eval_CANFrames();		//call CAN receive function
		
		if(Timer(0) == 0)
		{
		
			Timer_Set(0, 1000);
				
			CAN_BUFF_ID=0x98765;	// Testmessage 2
			CAN_BUFF_DATA[0]=10;
			CAN_BUFF_DATA[1]=20;
			CAN_BUFF_DATA[2]=30;
			CAN_BUFF_DATA[3]=40;
			CAN_BUFF_DATA[4]=50;
			CAN_BUFF_DATA[5]=60;
			CAN_BUFF_DATA[6]=70;
			CAN_BUFF_DATA[7]=80;
			CAN_BUFF_FORMAT = CAN_EXT;// extended CAN-ID
			CAN_Write();
		
		}				
	} //for_ever loop
}
	
	