
#ifndef __ADIH__ /* Schutz gegen mehrfaches #include */
#define __ADIH__

/***********************************************************************
 *      adi.h
 *      Projekt : PCANMIcroMod Library
 *      Funktion: 
 *
 *      Autor   : Bohlen
 *      Sprache : 
 *
 *      ----------------------------------------------------------------
 *   
 *      */
#include "compiler.h"

/*** Konstanten ***/

#define AD_FIRSTCHANNEL         0  /* erster ueberwachter ADC-Kanal */
#define AD_LASTCHANNEL          7  /* letzter    "         "       */



/*** Deklaration von Variable fuer andere Module ***/
#ifndef __ADIC__
#endif

/*** Prototypen fuer Function ***/

// <TITLE  AD_Init>
// Description:
// Initializes AD-converter.
// Parameter:
//  none
// Example:
// void main()
//
// {
//
// u16_t value;
//
// AD_Init();
//
// AD_SetTimeConstant(1,30);
// 
// value=AD_Read(1);
// 
// }
// ;

void AD_Init(void) ;

// <TITLE  AD_1000Hz>
// Description:
// This function should be called every 1ms to read in all analouge channels and perform a lowpass function, if enabled. 

void AD_1000Hz(void) ;

// <TITLE  AD_Read()>
// Description:
// Reads an analog channel.
// Parameter:
// chan: u8_t channel-number, range is 0..7
// Result:
// u16_t: Value 0..1023
u16_t AD_Read(u8_t chan) ;

// <TITLE  AD_SetTimeConstant()>
// Description:
// Sets a time for lowpass function of the selected channel.
// Parameter:
// chan: u8_t channel-number, range is 0..7
// tau: u16_t time constant in ms, range is 0(off)..32767
void AD_SetTimeConstant(u8_t channel, u16_t tau) ;

void SetMinSampletimes(u8_t channel, u16_t tau);   
void SetSampletimeManual(u8_t channel, u16_t tau);    
__interrupt void irq_adceii(void);


#endif /* __ADIH__ */
