#ifndef _EEPROM_H_
#define _EEPROM_H_

void I2C_Byte_Write(u16_t adr,u8_t dat);
u8_t I2C_Byte_Read(u16_t adr);

#define EEprom_Init() I2C_Init()	// allow call of EEprom_Init instead of I2C_Init()

// <TITLE  EEprom_OpenRead>
// Description:
// Open the EEprom for read access. To use the Eeprom I2C_Init must be called previously. 
// The read-Pointer is set to the start of the EEprom.
// Parameter:
// none
// Result:
// none
void EEprom_OpenRead(void);

// <TITLE  EEprom_CloseWrite>
// Description:
// Finishes read access.
// Parameter:
// none
// Result:
// none
void EEprom_CloseRead(void);

// <TITLE  EEprom_OpenWrite>
// Description:
// Open the EEprom for write access.  To use the Eeprom I2C_Init must be called previously.
// The Write-Pointer is set to the start of the EEprom.
// Parameter:
// none
// Result:
// none
void EEprom_OpenWrite(void);

// <TITLE  EEprom_CloseWrite>
// Description:
// Finishes write access, writes checksum to protect data.
// Parameter:
// none
// Result:
// none
void EEprom_CloseWrite(void);

// <TITLE  EEprom_Read()>
// Description:
// Reads 'len' data from EEprom. Data are copied into memory that starts at address'dat'. 
// Parameter:
// dat: Destination Pointer
// 
// len: Number of Bytes
// Result:
// none
void EEprom_Read(u8_t* dat, u16_t len);

// <TITLE  EEprom_Write()>
// Description:
// Writes 'len' data into EEprom. Data are copied from memory that starts at address'dat'.
// Parameter:
// dat: Source Pointer
// 
// len: Number of Bytes
// Result:
// none
void EEprom_Write(u8_t* dat, u16_t len);

// <TITLE  EEprom_isvalid>
// Description:
// Checks the consistency of the EEprom content.
// Parameter:
// none
// Result:
// 0: Checksum is incorrect.
// 1: Checksum is correct.
u8_t EEprom_isvalid(void);

void Eeprom_dump(u16_t id, u8_t inc);

#endif