/* Demo5_timer
This program will send after power on two CAN messages with baudrate 500k and CAN-ID 0x011. 
Time between the two messages is 50ms. 

The cyclical main loop will send a message with CAN-ID 0x200 when an CAN message with CAN ID 0x100 is received.
Every 100ms will be a CAN message with ID 0x012 send, containing the time in ms after system power on.
*/

#include "compiler.h"
#include "mb90495.h"
#include "vectors.h"
#include "can.h"
#include "hardware.h"
#include "timer.h"
#include "i2c.h"
#include "i2c_2.h"
#include "eeprom.h"
#include "adi.h"
#include "pwm.h"
#include "uart1.h"
#include "mcan.h"

//*************************************************************
static void Eval_CANFrames(void);			//CAN receive function
//***********************************************************************
// CAN-Queues
#define QUEUE_RCV_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
#define QUEUE_XMT_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...

//*************** Globale Variablen ****************************
CANI_qentrytyp rcv_queue[QUEUE_RCV_SIZE];	
CANI_qentrytyp xmt_queue[QUEUE_XMT_SIZE];	

//***********************************************************************

void Timer_2000Hz()
{
	static u8_t n;
	
	n++;
	if(n&1)	// runs only ever second call
	{
		LED_1000Hz();
	}
}

//***********************************************************************
static void Eval_CANFrames()
{
	if(CAN_Read()==CAN_ERR_OK)	// if an new CAN-Message was received
	{
		switch(CAN_BUFF_ID)
		{
			// Firmwareupdate via CAN
			//convert x.mhx into x.bin via mot2bin.exe (see ...\Release\ABS) and upload with CAN2Flash.exe to MicroMod  
			case 0x7e7:
/* 
The Library-Funktion  CAN_Read() fills the variables CAN_BUFF_ID, CAN_BUFF_LEN, CAN_BUFF_DATA[8] with the last Queue-entry of the CAN-message.
When using own CAN-LowLevel drivers must befor call the function mCAN_EvalInitialCmd() the variables
CAN_BUFF_ID
CAN_BUFF_LEN
CAN_BUFF_DATA[8]
be filled with the CAN-data.

*/
				// all outputs off
				Set_DOUTByte(0);
								
				mCAN_EvalInitialCmd();			
			break;
			case 0x100:
				CAN_BUFF_ID=0x200;
				CAN_BUFF_LEN=1;
				CAN_BUFF_DATA[0]=25;
				CAN_Write();
			break;
			
	//process other CAN-ID 
			default:
			break;
		} // switch
		
	} // if(CAN_Read()=...
}

//***********************************************************************
void main()
{
	long int time;
	
	InitIrqLevels();
    __set_il(7);		// allow all levels 

	Hardware_Init();
	Timer_Init();
	
	CAN_SetRCVQueue(rcv_queue, QUEUE_RCV_SIZE);	// Set Receive Queue to 8 entries, 
	CAN_SetXMTQueue(xmt_queue, QUEUE_XMT_SIZE);	// Set CAN Transmit Queue to 8 entries
	CAN_Init(CAN_BAUD_500K);
	CAN_RegisterMsg(0);
	CAN_Online();

	__EI();				// Enable Interrupts, necessary for Timer-function	
	
	CAN_BUFF_ID=0x11;	// Testmessage 1
	CAN_BUFF_LEN=8;
	CAN_BUFF_FORMAT = 0;
	CAN_Write();

	// glean actual timeand add 50ms 
	time = Timer_SystemTime() + 50 ;	

	// now wait until the 50ms are over, do nothing until this
	while(time > Timer_SystemTime()) WATCHDOG; 

	CAN_BUFF_FORMAT = 0;
	CAN_BUFF_ID=0x11;	// Testmessage 2 after 50 ms
	CAN_BUFF_LEN=8;
	CAN_Write();

	time=Timer_SystemTime()+100;
	for(;;)							//Main_loop
	{
		Eval_CANFrames();		//call CAN receive function
		WATCHDOG;
		
		// main loop send every 100ms the frame with the time after power on
		if(time<Timer_SystemTime())
		{	static long int clock;
			CAN_BUFF_ID=0x12;	// Testmessage 3: system time in ms will be sended
			CAN_BUFF_LEN=4;
			CAN_BUFF_DATA[0]=time>>24;
			CAN_BUFF_DATA[1]=time>>16;
			CAN_BUFF_DATA[2]=time>>8;
			CAN_BUFF_DATA[3]=time;
			CAN_BUFF_FORMAT = 0;
			CAN_Write();
			
			clock = time;
			CAN_BUFF_ID=0x13;	// Testmessage 3: system time in real time quants will be sended
			CAN_BUFF_LEN=5;
			CAN_BUFF_DATA[4]=clock%1000;		//ms will be send in two bytes		
			CAN_BUFF_DATA[3]=(clock%1000) >>8;				
			CAN_BUFF_DATA[2]=(clock/1000)%60;	//s
			CAN_BUFF_DATA[1]=(clock/60000)%60; 	//min
			CAN_BUFF_DATA[0]=clock/3600000;		//h
			CAN_BUFF_FORMAT = 0;
			CAN_Write();
			
			time = time+100;	// set time for the next message
		}
		
	} //for_ever loop
}