#ifndef _UART0_H_
#define _UART0_H_

#define NO_PARITY	0
#define EVEN_PARITY	1
#define ODD_PARITY 	2

#define STOPLEN_1	0
#define STOPLEN_2	1

#define BITLEN_7	0
#define BITLEN_8	1

// Supported bitrates:
// 38400, 19200, 9600, 4800

__interrupt void UART0_Receive();
__interrupt void UART0_Transmit();
void UART0_SetXMTQueue(u8_t* p, int entries);	// set entries to maxlen+1 (one entry required for signalling an empty queue)
void UART0_SetRCVQueue(u8_t* p, int entries);	// set entries to maxlen+1 (one entry required for signalling an empty queue)
void UART0_Init(long int baudrate, u8_t bitlen, u8_t parity, u8_t stoplen);
int UART0_Read(u8_t* buf, int len);	// fills "buf" with up to "len" bytes, returns number of valid bytes
u8_t UART0_Write(u8_t* buf, int len);	// puts "len" bytes from "buf" into transmit queue. If not all bytes fit into queue, then nothing is copied into queue
int UART0_GetTXFree(void);					// returns number of free bytes in Transmit queue
int UART0_GetRXFull(void);					// returns number of valid bytes in receive queue

#endif