/*
Demo6_eeprom using
*/

#include "compiler.h"
#include "mb90495.h"
#include "vectors.h"
#include "can.h"
#include "hardware.h"
#include "timer.h"
#include "i2c.h"
#include "i2c_2.h"
#include "eeprom.h"
#include "adi.h"
#include "pwm.h"
#include "uart1.h"
#include "mcan.h"

//*************************************************************
static void Eval_CANFrames(void);			//CAN receive function
//***********************************************************************
// CAN-Queues
#define QUEUE_RCV_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
#define QUEUE_XMT_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...

//*************** Globale Variablen ****************************
CANI_qentrytyp rcv_queue[QUEUE_RCV_SIZE];	
CANI_qentrytyp xmt_queue[QUEUE_XMT_SIZE];	
/* Test-Variablen for Parameter */
u8_t bParam1;
u16_t wParam2, tmp;
long int lParam3;

//***********************************************************************
void Timer_2000Hz()
{
	static u8_t n;
	
	n++;
	if(n&1)	// runs only ever second call
	{
		LED_1000Hz();
	}
}
//***********************************************************************
static void Eval_CANFrames()
{
	if(CAN_Read()==CAN_ERR_OK)	// if an new CAN-Message was received
	{
		switch(CAN_BUFF_ID)
		{
			// Firmwareupdate via CAN
			//convert x.mhx into x.bin via mot2bin.exe (see ...\Release\ABS) and upload with CAN2Flash.exe to MicroMod  
			case 0x7e7:
/* 
The Library-Funktion  CAN_Read() fills the variables CAN_BUFF_ID, CAN_BUFF_LEN, CAN_BUFF_DATA[8] with the last Queue-entry of the CAN-message.
When using own CAN-LowLevel drivers must befor call the function mCAN_EvalInitialCmd() the variables
CAN_BUFF_ID
CAN_BUFF_LEN
CAN_BUFF_DATA[8]
be filled with the CAN-data.

*/
				// all outputs off
				Set_DOUTByte(0);
								
				mCAN_EvalInitialCmd();			
			break;
	//process other CAN-ID 
			case 0x100:
				switch(CAN_BUFF_DATA[0])
				{
					case 1: bParam1 = CAN_BUFF_DATA[1]; break;
					case 2: wParam2 = *(int*)(CAN_BUFF_DATA+1); break;
					case 3: lParam3 = *(long int*)(CAN_BUFF_DATA+1); break;
					case 4:
						WATCHDOG;
						EEprom_OpenWrite();	// EEprom zum schreiben vorbereiten
						EEprom_Write(&bParam1,1);		// 1 byte Eeprom Daten schreiben
						EEprom_Write((u8_t*)&wParam2,2); // 2 bytes Eeprom Daten schreiben
						EEprom_Write((u8_t*)&lParam3,4);	// 4 bytes Eeprom Daten schreiben
						EEprom_CloseWrite();
					break;
				}			
			break;
			case 0x200:
				{
					CAN_BUFF_ID++;
					CAN_BUFF_LEN=2;
					CAN_BUFF_FORMAT = 0;
					tmp = CAN_BUFF_DATA[0]+bParam1;
					CAN_BUFF_DATA[0]=tmp>>8;
					CAN_BUFF_DATA[1]=tmp;					
					CAN_Write();
				}
			break;
	
			default:
			break;
		} // switch
		
	} // if(CAN_Read()=...
}

/*******************************************************/

void main()
{
	InitIrqLevels();
    __set_il(7);		// allow all levels 

	Hardware_Init();
	Timer_Init();
	
	CAN_SetRCVQueue(rcv_queue, QUEUE_RCV_SIZE);	// Set Receive Queue to 8 entries, 
	CAN_SetXMTQueue(xmt_queue, QUEUE_XMT_SIZE);	// Set CAN Transmit Queue to 8 entries
	CAN_Init(CAN_BAUD_500K);
	CAN_RegisterMsg(0);
	CAN_Online();
	
// check for valid content of the EEprom
// Eeprom-content is valid when befor the data with "EEprom_Write()"						
// into the EEprom was written. When it is writing a checksum will be added. 
	if(EEprom_isvalid() )								
	{
		// 1. Parameter: Adresse of the Variable
		// 2. Parameter: Len of the Variable in Bytes
		//	byte/char: Len=1
		// 	int/word: Len=2
		//  long int: Len=4
		EEprom_OpenRead();	// prepare EEprom for read
		EEprom_Read(&bParam1, 1);		// reading 1 byte Eeprom data
		EEprom_Read((u8_t*)&wParam2, 2); // reading 2 byte Eeprom data
		EEprom_Read((u8_t*)&lParam3, 4);	// reading 4 byte Eeprom data
	}
	else
	// if the content of the EEprom is invalide, the variabls overwrite with Default values
	{
		bParam1 = 0x1;
		wParam2 = 0x1234;
		lParam3 = 0x78ff1025;
	}
	
	__EI();				// Enable Interrupts to enable the timer						
						
	Timer_Set(0,100);
	
	for(;;)						//Endless loop
	{
		WATCHDOG;
		Eval_CANFrames();		//call CAN receive function
		if(Timer(0) == 0)
		{
			Timer_Set(0,500);
			CAN_BUFF_ID=0x1;	// Testmessage 1
			CAN_BUFF_LEN=1;
			CAN_BUFF_FORMAT = 0;
			CAN_BUFF_DATA[0]=bParam1;
			CAN_Write();

			CAN_BUFF_ID=0x2;	// Testmessage 2
			CAN_BUFF_LEN=2;
			CAN_BUFF_FORMAT = 0;
			*(u16_t*)CAN_BUFF_DATA=wParam2;
			CAN_Write();

			CAN_BUFF_ID=0x3;	// Testmessage 3
					CAN_BUFF_LEN=4;
			CAN_BUFF_FORMAT = 0;
			*(long int*)CAN_BUFF_DATA=lParam3;
			CAN_Write();		
		}
				
	} //for_ever loop
}	//Main loop