#ifndef _HARDWRE_H_
#define _HARDWRE_H_
#include "compiler.h"

#define WDTC_WTE  WDTC

// <TITLE  Hardware_Init>
// Description:
// Initializes the Hardware (Watchdog, directions,...)
// Parameter:
// none
// Result:
// none
void	Hardware_Init(void);

// <TITLE  Get_DIN()>
// Description:
// Reads one digital Input.
// Parameter:
// chan: number of digital Channel, 0..7
// Result:
// Status of digital Input.
u8_t	Get_DIN(u8_t chan);

// <TITLE  Get_DINByte>
// Description:
// Reads all 8 digital Inputs.
// Parameter:
// Result:
// Status of all 8 digital Inputs.
//
// bit 0: Status of Input 0
//
// ...
//
// bit 7: Status of Input 7

u8_t	Get_DINByte(void);

// <TITLE  Set_DOUT()>
// Description:
// Sets one digital Output.
// Parameter:
// chan: Number of digital Channel, 0..7
//
// val: 0: sets output inactive
//
// 1: sets output active
// Result:
// none
void	Set_DOUT(u8_t chan, u8_t val);

// <TITLE  Get_DOUT()>
// Description:
// Reads one digital Output.
// Parameter:
// chan: number of digital Channel, 0..7
// Result:
// Status of digital Output.
u8_t	Get_DOUT(u8_t chan);

// <TITLE  Set_DOUTByte>
// Description:
// Sets all 8 digital Outputs.
// Parameter:
// bit 0: Status of Output 0
//
// ...
//
// bit 7: Status of Output 7
// Result:
// none
void	Set_DOUTByte(u8_t val);

// <TITLE  Get_DOUTByte>
// Description:
// Reads all 8 digital Outputs.
// Parameter:
// Result:
// Status of all 8 digital Outputs.
//
// bit 0: Status of Input 0
//
// ...
//
// bit 7: Status of Input 7
u8_t	Get_DOUTByte(void);

// <TITLE  Set_DOUTByteMask>
// Description:
// Sets all  digital Outputs where Bits in Parameter 'mask' is 1.
// Parameter:
// mask: 
// defines which Outputs to modify.
// val:
//
// bit 0: Status of Output 0
//
// ...
//
// bit 7: Status of Output 7
// Result:
// none
void 	Set_DOUTByteMask(u8_t mask,u8_t val);


// <TITLE  LED_1000Hz>
// Description:
// Call this function every 1ms for flashing.
// Parameter:
// none
// Result:
// none
void LED_1000Hz(void);

// <TITLE  LED_SetSpeed()>
// Description:
// Call this function to set the flashing frequency of the LED.
// Parameter:
// speed: 0..4
// Result:
// none
void LED_SetSpeed(u8_t);

u8_t check_hwid(void);
#define WATCHDOG (WDTC_WTE=0)

#endif
