/*
Example for using  Software-Timer.
3 Software-Timers are used to send CAN-Messages with different Cycletimes.
Do NOT use more than 3 timers!!! (system will crash)

*/

#include "compiler.h"
#include "mb90495.h"
#include "vectors.h"
#include "can.h"
#include "hardware.h"
#include "timer.h"
#include "i2c.h"
#include "i2c_2.h"
#include "eeprom.h"
#include "adi.h"
#include "pwm.h"
#include "uart1.h"
#include "mcan.h"


#define TIMEOUT_0		21			//Interval for Send CAN-Message 
#define TIMEOUT_1		54
#define TIMEOUT_2		73

//*************************************************************
static void Eval_CANFrames(void);			//CAN receive function
//***********************************************************************
// CAN-Queues
#define QUEUE_RCV_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
#define QUEUE_XMT_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
//*************** Globale Variablen ****************************
CANI_qentrytyp rcv_queue[QUEUE_RCV_SIZE];	
CANI_qentrytyp xmt_queue[QUEUE_XMT_SIZE];	

//***********************************************************************
void Timer_2000Hz()
{
	static u8_t n;
	
	n++;
	if(n&1)	// runs only ever second call
	{
		LED_1000Hz();
		AD_1000Hz();
	}
}
//***********************************************************************
static void Eval_CANFrames()
{
	if(CAN_Read()==CAN_ERR_OK)	// if an new CAN-Message was received
	{
		switch(CAN_BUFF_ID)
		{
			// Firmwareupdate via CAN
			//convert x.mhx into x.bin via mot2bin.exe (see ...\Release\ABS) and upload with CAN2Flash.exe to MicroMod  
			case 0x7e7:
/* 
The Library-Funktion  CAN_Read() fills the variables CAN_BUFF_ID, CAN_BUFF_LEN, CAN_BUFF_DATA[8] with the last Queue-entry of the CAN-message.
When using own CAN-LowLevel drivers must befor call the function mCAN_EvalInitialCmd() the variables
CAN_BUFF_ID
CAN_BUFF_LEN
CAN_BUFF_DATA[8]
be filled with the CAN-data.

*/
				// all outputs off
				Set_DOUTByte(0);
								
				mCAN_EvalInitialCmd();			
			break;
	//process other CAN-ID 
			case 0x100:
				CAN_BUFF_ID=0x200;
				CAN_BUFF_LEN=1;
				CAN_BUFF_DATA[0]=25;
				CAN_Write();
			break;
			
			default:			
			break;
		} // switch
		
	} // if(CAN_Read()=...
}

//***********************************************************************
void main()
{
	InitIrqLevels();
    __set_il(7);		// allow all levels 

	Hardware_Init();
	Timer_Init();
	
	CAN_SetRCVQueue(rcv_queue, QUEUE_RCV_SIZE);	// Set Receive Queue to 8 entries, 
	CAN_SetXMTQueue(xmt_queue, QUEUE_XMT_SIZE);	// Set CAN Transmit Queue to 8 entries
	CAN_Init(CAN_BAUD_500K);
	CAN_RegisterMsg(0);
	CAN_Online();

	__EI();				// Enable Interrupts
						// erst danach funktioniert der Timer !


	Timer_Set(0,TIMEOUT_0);
	Timer_Set(1,TIMEOUT_1);
	Timer_Set(2,TIMEOUT_2);


	for(;;)
	{
		WATCHDOG;
		Eval_CANFrames();		//call CAN receive function
		
		if(Timer(0)==0)
		{
			Timer_Set(0,TIMEOUT_0);
			CAN_BUFF_ID=0x11;	
			CAN_BUFF_LEN=8;
			CAN_BUFF_DATA[0]=0x11;
			CAN_BUFF_DATA[1]=0x22;
			CAN_BUFF_DATA[2]=0x33;
			CAN_BUFF_DATA[3]=0x44;
			CAN_BUFF_FORMAT = 0;
			// Send inverted Data
			CAN_BUFF_DATA[4]=~0x11;
			CAN_BUFF_DATA[5]=~0x22;
			CAN_BUFF_DATA[6]=~0x33;
			CAN_BUFF_DATA[7]=~0x44;
			CAN_Write();
		}

		if(Timer(1)==0)
		{
			Timer_Set(1,TIMEOUT_1);
			CAN_BUFF_ID=0x12;	
			CAN_BUFF_LEN=3;
			CAN_BUFF_DATA[0]=0x11;
			CAN_BUFF_DATA[1]=0x22;
			CAN_BUFF_DATA[2]=0x33;
			CAN_BUFF_FORMAT = 0;
			CAN_Write();
		}

		if(Timer(2)==0)
		{
			Timer_Set(2,TIMEOUT_2);
			CAN_BUFF_ID=0x13;	
			CAN_BUFF_LEN=1;
			CAN_BUFF_DATA[0]=0x99;
			CAN_BUFF_FORMAT = 0;
			CAN_Write();
		}

	} //for_ever loop
}