
#ifndef __I2C1H__        /* Schutz gegen mehrfaches #include */
#define __I2C1H__

/***********************************************************************
 *      i2c.h
 *      Funktion: Headerdatei fuer das Softwaremodul "i2c_1.c".
 *
*/

// <TITLE I2C_1_Init>
// Description:
// Initializes the I2C_1-Interface. The Hardware resourses are shared with the UART.
// Pin P4.4 is used as SDA, Pin P4.0 is used as SCL. External Pull-Up Resistors (2...5 kOhm) are required

// Parameter:
// none
// Result:
// none
u8_t I2C_1_Init(void);

// <TITLE I2C_1_Start>
// Description:
// Generates Start-Sequence for I2C-Bus.
// Parameter:
// none
// Result:
// none
void    I2C_1_Start(void);

// <TITLE I2C_1_MasterWrite()>
// Description:
// Writes ony Byte to the I2C-Bus. 
// Parameter:
// input_byte: Byte that is written to the I2C_Bus.
// Result:
// 0: acknowledge-error
//
// 1: write successful 
u8_t   I2C_1_MasterWrite(u8_t input_byte);

// <TITLE I2C_1_MasterRead()>
// Description:
// Reads ony Byte from the I2C-Bus. 
// Parameter:
// ack: 1 generate no acknowledge 
//
// 0: generate acknowledge
// Result:
// Data from I2C-Bus.
u8_t   I2C_1_MasterRead(u8_t ack);

// <TITLE I2C_1_Stop>
// Description:
// Generates Stop-Sequence for I2C-Bus.
// Parameter:
// none
// Result:
// none
u8_t   I2C_1_Stop(void);


#endif
