/*
Example for using  simple UART-Functions.

*/
#include "compiler.h"
#include "mb90495.h"
#include "vectors.h"
#include "can.h"
#include "hardware.h"
#include "uart1.h"
#include "uart0.h"
#include "timer.h"
#include "i2c.h"
#include "i2c_2.h"
#include "eeprom.h"
#include "adi.h"
#include "pwm.h"
#include "mcan.h"

//***********************************************************************
static void Eval_CANFrames(void);			//CAN
u8_t GetSign(void);	
//***********************************************************************
// CAN-Queues size
#define QUEUE_RCV_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
#define QUEUE_XMT_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...

//**************************************************************
//UART-Queues size
#define TX_entries 9		//UART transmit buffer 8 Byte (max. size + 1)		
#define RX_entries 2		//UART receive buffer 8 Byte (max. size + 1)

//*************** Globale Variablen ****************************

CANI_qentrytyp rcv_queue[QUEUE_RCV_SIZE];	
CANI_qentrytyp xmt_queue[QUEUE_XMT_SIZE];	

u8_t Buf_XMTQueue[TX_entries];
u8_t Buf_RCVQueue[RX_entries];

u8_t c;
//***********************************************************************
void Timer_2000Hz()
{
	static u8_t n;
	
	n++;
	if(n&1)	// runs only ever second call
	{
		LED_1000Hz();
	}
}
//***********************************************************************
u8_t GetSign()
{	
	u8_t back;
	back = UART1_Read( &c, 1);
	return back;
}
//***********************************************************************
static void Eval_CANFrames()
{
	if(CAN_Read()==CAN_ERR_OK)	// if an new CAN-Message was received
	{
		switch(CAN_BUFF_ID)
		{
			// Firmwareupdate via CAN
			//convert x.mhx into x.bin via mot2bin.exe (see ...\Release\ABS) and upload with CAN2Flash.exe to MicroMod  
			case 0x7e7:
/* 
The Library-Funktion  CAN_Read() fills the variables CAN_BUFF_ID, CAN_BUFF_LEN, CAN_BUFF_DATA[8] with the last Queue-entry of the CAN-message.
When using own CAN-LowLevel drivers must befor call the function mCAN_EvalInitialCmd() the variables
CAN_BUFF_ID
CAN_BUFF_LEN
CAN_BUFF_DATA[8]
be filled with the CAN-data.

*/
				// all outputs off
				Set_DOUT(0,0);
				Set_DOUT(1,0);
				Set_DOUT(2,0);
				Set_DOUT(3,0);
				Set_DOUT(4,0);
				Set_DOUT(5,0);
				Set_DOUT(6,0);
				Set_DOUT(7,0);
				
				mCAN_EvalInitialCmd();			
			break;
	//process other CAN-ID 
			case 0x100:
				CAN_BUFF_DATA[CAN_BUFF_LEN-1]=0; // 0-termination of string...
				// send CAN-Databuffer as sting
				UART1_Write((u8_t*)CAN_BUFF_DATA, CAN_BUFF_LEN);		
			break;
			
			default:
			break;
		} // switch
		
	} // if(CAN_Read()=...
}

//*************************************************************
void main()
{
	
	InitIrqLevels();
    __set_il(7);		// allow all levels 

	Hardware_Init();
	Timer_Init();
	I2C_Init();
	
	UART1_SetXMTQueue(Buf_XMTQueue, sizeof (Buf_XMTQueue));		//transmit-buffer
	UART1_SetRCVQueue(Buf_RCVQueue, sizeof (Buf_RCVQueue));		//receive-buffer
	UART1_Init(38400,BITLEN_8,NO_PARITY,STOPLEN_1);
	
	CAN_SetRCVQueue(rcv_queue, QUEUE_RCV_SIZE);	// Set Receive Queue to 8 entries, 
	CAN_SetXMTQueue(xmt_queue, QUEUE_XMT_SIZE);	// Set CAN Transmit Queue to 8 entries
	CAN_Init(CAN_BAUD_500K);
	CAN_RegisterMsg(0);
	//CAN_Online();		// is part of the example
	__EI();				// Enable Interrupts
						// also for the timer needed!


	for(;;)
	{
		WATCHDOG;
		Eval_CANFrames();		//call CAN receive function
		
		if(GetSign() > 0)				//get a sign from the UART
		{
			if(c=='1') CAN_Online();
			if(c=='2') CAN_Offline();
			if(c=='3') CAN_TxQueueReset();

			if(c!=0)
			{
				CAN_BUFF_ID=0x101;
				CAN_BUFF_LEN=1;
				CAN_BUFF_DATA[0]=c;
				CAN_Write();
			}
		}

	} //for_ever loop
}