
#ifndef __UDCOUNTH__   /* Schutz gegen mehrfaches #include */
#define __UDCOUNTH__

/***********************************************************************
 *      udcount.h
 *      Projekt :
 *      Funktion: 
 *
 *      Autor   : Bohlen
 *      Sprache : 
 *
 *      ----------------------------------------------------------------
 *      */
#include "compiler.h"

typedef struct _TUDCChannel 
{
	u8_t flags;			// 7:enable 6:mode 
						// mode=0	obere/untere Grenze=Anschlag
       					// mode=1	endlos im Kreis, berlauf von max->min und umgekehrt
	u8_t dir_last;		// 7-4 lastin 3-0 dir: 0=stillstand ,1=vorwaerts, 2 = rueckwaerts
	u16_t counter ; 		// zaehlerstand
    u16_t oldcount ; 	// Zum Zeitpunkt der letzten Abfrage (fuer Delta berechnung)
    u16_t minlimit;		// 
    u16_t maxlimit;  	// 
 }  TUDCChannel ;
 // 4 * 10 bytes =40 Bytes

/*** Konstantendefinitionen ***/
#define UDC_CHANNELS 4       // soviele Counter sind moeglich
#define UDC_ROLL_OVER 	0x01


/*** Prototypen fr Methoden ***/
void UDC_Init(u8_t channel, u16_t initval, u16_t loval, u16_t hival, u8_t mode);
void    UDC_Server(void) ;
u16_t   UDC_GetCount(u8_t channel) ;
int     UDC_GetDelta(u8_t channel) ;




#endif /* __UDCOUNTH__ */

