#ifndef _uart_h_
#define _uart_h_


// <TITLE UART_Init()>
// Description:
// Initializes the UARD with a given Baudrate.
// Parameter:
// baudrate:
// 0: 76800 Baud
//
// 1: 38400 Baud
//
// 2: 19200 Baud
// 
// 3: 9600 Baud
// Result:
// none
void UART_Init(char baud);

// <TITLE Putch()>
// Description:
// Writes a charakter to the UART.
// Parameter:
// ch: charakter to write.
// Result:
// none
void Putch (char ch) ;

// <TITLE Getch>
// Description:
// Reads a charakter from the UART. Waits until a character is received
// Parameter:
// Result:
// -1: Error. 
// Read charakter

char Getch(void) ;

// <TITLE Getch>
// Description:
// Reads a charakter from the UART. Returns 0 if no character is available.
// Parameter:
// Result:
// -1: Error, 0: no character available
// Read charakter. 
char GetKey(void)  ;

// <TITLE puts()>
// Description:
// Writes a String to the UART.
// Parameter:
// Name2: Pointer to a 0-terminated String. 
// Result:
// none
void puts (const char *Name2) ;


// <TITLE itoa()>
// Description:
// Converts an integer into a String.
// Parameter:
// i: integer number.
// Result:
// Pointer to the String.
char * itoa(int i);

// <TITLE uitoa()>
// Description:
// Converts an unsigned integer into a String.
// Parameter:
// i: unsigned integer number.
// Result:
// Pointer to the String.
char * uitoa(unsigned int i);
char * itoa_hex(unsigned int i);


// <TITLE itoa_hex()>
// Description:
// Converts an integer into a String. Number base is 16.
// Parameter:
// i: unsigned integer number.
// Result:
// Pointer to the String.
char * itoa_hex(unsigned int i); 

#define SER_BAUD_76800	0
#define SER_BAUD_38400	1
#define SER_BAUD_19200	2
#define SER_BAUD_9600	3


#endif