/*------------------------------------------------------------------------
  VECTORS.C
  - Interrupt level (priority) setting
  - Interrupt vector definition

  03.11.99  1.00   wpe    V30L20   original version, no resource assignment

------------------------------------------------------------------------*/
#include "compiler.h"
#include "mb90495.h"
#include "timer.h"	// wegen prototype Interruptfunktion
#include "can.h"
#include "adi.h"
#include "pwm.h"
#include "uart1.h"
#include "uart0.h"
#include "uart.h"
/*------------------------------------------------------------------------
   InitIrqLevels()

   This function  pre-sets all interrupt control registers. It can be used
   to set all interrupt priorities in static applications. If this file
   contains assignments to dedicated resources, verify  that the
   appropriate controller is used.

   NOTE: value 7 disables the interrupt and value 0 sets highest priority.
   NOTE: Two resource interrupts always share one ICR register.
*/
void InitIrqLevels(void)
{
/*  ICRxx               shared IRQs for ICR */

    ICR00 = 6;      /*  IRQ11
                        IRQ12 */
    ICR01 = 7;      /*  IRQ13     
                        IRQ14 */
    ICR02 = 7;      /*  IRQ15
                        IRQ16 */
    ICR03 = 8 | 4;  /*  IRQ17
                        IRQ18 */
    ICR04 = 5;      /*  IRQ19 16bit I/O Timer fr ICU
                        IRQ20 */
    ICR05 = 7;      /*  IRQ22 */

    ICR06 = 5;      /*  IRQ23	ICU
                        IRQ24 	ICU */
    ICR07 = 5;      /*  IRQ25
                        IRQ26 */
    ICR08 = 7;      /*  IRQ27
                        IRQ28 */
    ICR09 = 5;      /*  IRQ30 	ICU */

    ICR12 = 6;      /*  IRQ36 TIMER1*/

    ICR13 = 4;      /*  IRQ37
                        IRQ38 UART1*/
    ICR14 = 4;      /*  IRQ39
                        IRQ40 UART0*/
    ICR15 = 7;      /*  IRQ41
                        IRQ42 */
                        
                        
}
/*------------------------------------------------------------------------
   Prototypes
   
   Add your own prototypes here. Each vector definition needs is proto-
   type. Either do it here or include a header file containing them.

*/
__interrupt void DefaultIRQHandler (void);

/*------------------------------------------------------------------------
   Vector definiton

   Use following statements to define vectors. All resource related
   vectors are predefined. Remaining software interrupts can be added here
   as well.
   NOTE: If software interrupts 0 to 7 are defined here, this might 
   conflict with the reset vector in the start-up file.
*/

#pragma intvect DefaultIRQHandler  9    /* software interrupt 9         */
#pragma intvect DefaultIRQHandler 10    /* exeception handler           */
#pragma intvect CAN_Receive 	  11    /* CAN #0 (receive complete)    */
#pragma intvect CAN_Transmit	  12    /* CAN #0 (transmission complete
                                               /node status transition) */
#pragma intvect DefaultIRQHandler 15    /* external interrupt INT0/INT1 */
#pragma intvect DefaultIRQHandler 16    /* timebase timer               */
#pragma intvect DefaultIRQHandler 17    /* 16-bit reload timer #0       */
#pragma intvect irq_adceii 		  18    /* A/D converter                */
#pragma intvect IOTIMER			  19    /* I/O timer                    */
#pragma intvect DefaultIRQHandler 20    /* external interrupt INT2/INT3 */
#pragma intvect DefaultIRQHandler 22    /* PPG #0/1                     */
#pragma intvect INPUTCAPTURE0	  23    /* input capture CH.0           */
#pragma intvect DefaultIRQHandler 24    /* external interrupt INT4/INT5 */
#pragma intvect INPUTCAPTURE1	  25    /* input capture CH.1           */
#pragma intvect DefaultIRQHandler 26    /* PPG #2/3                     */
#pragma intvect DefaultIRQHandler 27    /* external interrupt INT6/INT7 */
#pragma intvect DefaultIRQHandler 28    /* watch timer                  */
#pragma intvect INPUTCAPTURE23	  30    /* input capture CH.2/3         */
#pragma intvect ReloadTimer1      36    /* 16-bit reload timer #1       */
#pragma intvect UART1_Receive 	  37    /* UART #1 (receive complete)   */
#pragma intvect UART1_Transmit    38    /* UART #1 (transmission compl.)*/
#pragma intvect UART0_Receive 	  39    /* UART #0 (receive complete)   */
#pragma intvect UART0_Transmit    40    /* UART #0 (transmission compl.)*/
#pragma intvect DefaultIRQHandler 41    /* Flash Memory                 */
#pragma intvect DefaultIRQHandler 42    /* delayed interrupt            */

/*------------------------------------------------------------------------
   DefaultIRQHandler()

   This function is a placeholder for all vector definitions. Either use
   your own placeholder or add necessary code here. 
*/
__interrupt 
void DefaultIRQHandler (void)
{
    __DI();                              /* disable interrupts */
    puts("\rModule Vector.C: Faulty Interrupt, restarting System");
    for(;;)
   	   __wait_nop();                    /* halt system */
}
