/*
Example for change Baudrate.

*/

#include "compiler.h"
#include "mb90495.h"
#include "vectors.h"
#include "can.h"
#include "hardware.h"
#include "timer.h"
#include "i2c.h"
#include "i2c_2.h"
#include "eeprom.h"
#include "adi.h"
#include "pwm.h"
#include "uart1.h"
#include "mcan.h"

//************************************************************
static void Eval_CANFrames(void);			//CAN receive function
//***********************************************************************
// CAN-Queues
#define QUEUE_RCV_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
#define QUEUE_XMT_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
//**************************************************************
//UART-Queues
#define TX_entries 9		//UART transmit buffer 8 Byte (max. size + 1)		
#define RX_entries 9		//UART receive buffer 8 Byte (max. size + 1)
//*************** Globale Variablen ****************************
CANI_qentrytyp rcv_queue[QUEUE_RCV_SIZE];	
CANI_qentrytyp xmt_queue[QUEUE_XMT_SIZE];	

u8_t Buf_XMTQueue[TX_entries];
u8_t Buf_RCVQueue[RX_entries];
//***********************************************************************
void Timer_2000Hz()
{
	static u8_t n;
	
	n++;
	if(n&1)	// runs only ever second call
	{
		LED_1000Hz();
	}
}
//***********************************************************************
static void Eval_CANFrames()
{
	if(CAN_Read()==CAN_ERR_OK)	// if an new CAN-Message was received
	{
		switch(CAN_BUFF_ID)
		{
			// Firmwareupdate via CAN
			//convert x.mhx into x.bin via mot2bin.exe (see ...\Release\ABS) and upload with CAN2Flash.exe to MicroMod  
			case 0x7e7:
/* 
The Library-Funktion  CAN_Read() fills the variables CAN_BUFF_ID, CAN_BUFF_LEN, CAN_BUFF_DATA[8] with the last Queue-entry of the CAN-message.
When using own CAN-LowLevel drivers must befor call the function mCAN_EvalInitialCmd() the variables
CAN_BUFF_ID
CAN_BUFF_LEN
CAN_BUFF_DATA[8]
be filled with the CAN-data.

*/
				// all outputs off
				Set_DOUTByte(0);
								
				mCAN_EvalInitialCmd();			
			break;
	//process other CAN-ID 
			case 0x100:	
				CAN_BUFF_ID=0x101;	// response message in actual baudrate
				CAN_BUFF_LEN=0;
				CAN_Write();					
			break;
			
			default:
			break;
		} // switch
		
	} // if(CAN_Read()=...
}

//*************************************************************
void main()
{
u8_t old_din0=0, old_din1=0, old_din2=0;

	InitIrqLevels();
    __set_il(7);		// allow all levels 

	Hardware_Init();
	Timer_Init();
	I2C_Init();
	
	UART1_SetXMTQueue(Buf_XMTQueue, TX_entries);		//transmit-buffer
	UART1_SetRCVQueue(Buf_RCVQueue, RX_entries);		//receive-buffer
	UART1_Init(38400,BITLEN_8,NO_PARITY,STOPLEN_1);
	
	CAN_SetRCVQueue(rcv_queue, QUEUE_RCV_SIZE);	// Set Receive Queue to 8 entries, 
	CAN_SetXMTQueue(xmt_queue, QUEUE_XMT_SIZE);	// Set CAN Transmit Queue to 8 entries
	CAN_Init(CAN_BAUD_500K);
	CAN_RegisterMsg(0);
	CAN_Online();
	__EI();				// Enable Interrupts

	Timer_Set(0,500);	
	
	CAN_BUFF_ID=0x121;	// PowerOn Message
	CAN_BUFF_LEN=0;
	CAN_Write();
	
	for(;;)
	{
	u8_t din;
		WATCHDOG;
		Eval_CANFrames();		//call CAN receive function
		
		din=Get_DIN(0);
		if((din==1) && (old_din0==0))	// pos. edge @ DIN0 sets CAN to 1MBaud
		{
			Set_DOUTByte(0x01);
			
			CAN_Offline();
			Timer_Set(1,10);	// 10ms delay
			while(Timer(1)!=0);
			//CAN_Init(CAN_BAUD_1M);
			BTR=CAN_BAUD_1M;
			CAN_Online();
		}	
		old_din0=din;
		
		din=Get_DIN(1);
		if((din==1) && (old_din1==0))	// pos. edge @ DIN1 sets CAN to 500kBaud
		{
			Set_DOUTByte(0x02);

			CAN_Offline();
			Timer_Set(1,10);	// 10ms delay
			while(Timer(1)!=0);
			//CAN_Init(CAN_BAUD_500K);
			BTR=CAN_BAUD_500K;
			CAN_Online();
		}			
		old_din1=din;
		
		din=Get_DIN(2);
		if((din==1) && (old_din2==0))	// pos. edge @ DIN2 sets CAN to 100kBaud
		{
			Set_DOUTByte(0x04);
			CAN_Offline();
			Timer_Set(1,10);	// 10ms delay
			while(Timer(1)!=0);
			//CAN_Init(CAN_BAUD_100K);
			BTR=CAN_BAUD_100K;
			CAN_Online();
		}					
		old_din2=din;
		
		
			
	} //for_ever loop
}